/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.container;

import de.lehmannet.om.EquPosition;
import de.lehmannet.om.ISite;
import de.lehmannet.om.util.Ephemerides;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class HorizontalSkymap
extends JLabel {
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private static final int WIDTH = 50;
    private static final int HEIGHT = 50;
    private static final int SKY_BORDER = 1;
    private static final int POINT_DIAMETER = 4;
    private EquPosition position = null;
    private Calendar calendar = null;
    private ISite site = null;

    public HorizontalSkymap(EquPosition position, Calendar date, ISite site) {
        this.position = position;
        this.calendar = date;
        this.site = site;
        this.createImage();
    }

    private void createImage() {
        BufferedImage image = new BufferedImage(50, 50, 2);
        this.paintSky(image);
        this.paintLabel(image);
        this.paintObjectPosition(image);
        super.setIcon(new ImageIcon(image));
    }

    private void paintSky(BufferedImage image) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setPaint(new Color(12, 114, 12));
        g2d.fillRect(0, 0, 50, 50);
        g2d.setPaint(Color.black);
        g2d.fillOval(1, 1, 48, 48);
    }

    private void paintObjectPosition(BufferedImage image) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        double azimut = Ephemerides.getAzimut((EquPosition)this.position, (Calendar)this.calendar, (double)this.site.getLongitude().getValue(), (double)this.site.getLatitude().getValue());
        double altitude = Ephemerides.altitudeAboveHorizon((EquPosition)this.position, (Calendar)this.calendar, (double)this.site.getLongitude().getValue(), (double)this.site.getLatitude().getValue());
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        super.setToolTipText("<html>" + this.bundle.getString("horizontalSkymap.azimut") + ": " + df.format(azimut) + "<br>" + this.bundle.getString("horizontalSkymap.altitude") + ": " + df.format(altitude) + "</html>");
        int radius = 24;
        Point center = new Point(25, 25);
        if (azimut == 0.0) {
            azimut = 1.0;
        }
        double altitudeOnRadius = Math.abs((double)radius - (double)radius / (90.0 / altitude));
        double x = Math.cos(Math.toRadians(90.0 - azimut)) * altitudeOnRadius;
        double y = Math.sin(Math.toRadians(90.0 - azimut)) * altitudeOnRadius;
        if (azimut > 0.0 && azimut < 90.0) {
            if (x > 0.0) {
                x *= -1.0;
            }
            if (y < 0.0) {
                y *= -1.0;
            }
        } else if (azimut > 90.0 && azimut < 180.0) {
            if (x > 0.0) {
                x *= -1.0;
            }
            if (y > 0.0) {
                y *= -1.0;
            }
        } else if (azimut > 180.0 && azimut < 270.0) {
            if (x < 0.0) {
                x *= -1.0;
            }
            if (y > 0.0) {
                y *= -1.0;
            }
        } else if (azimut > 270.0) {
            if (x < 0.0) {
                x *= -1.0;
            }
            if (y < 0.0) {
                y *= -1.0;
            }
        }
        x = center.getX() + x;
        y = center.getY() - y;
        g2d.setPaint(Color.yellow);
        g2d.fillOval((int)x, (int)y, 4, 4);
    }

    private void paintLabel(BufferedImage image) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        String west = this.bundle.getString("horizontalSkymap.abbr.west");
        String north = this.bundle.getString("horizontalSkymap.abbr.north");
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.setFont(new Font("sansserif", 0, 9));
        g2d.drawChars(north.toCharArray(), 0, north.length(), 22, 8);
        g2d.drawChars(west.toCharArray(), 0, west.length(), 41, 28);
    }
}

