/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.dialog.CheckBoxNode;
import de.lehmannet.om.ui.dialog.CheckBoxNodeEditor;
import de.lehmannet.om.ui.dialog.CheckBoxNodeRenderer;
import de.lehmannet.om.ui.dialog.SchemaElementLeaf;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class NewDocumentDialog
extends JDialog
implements ActionListener {
    public static final int CANCEL = -1;
    public static final int OK_BLANK = 0;
    public static final int OK_COPY = 1;
    private static final String AC_BLANK = "blank";
    private static final String AC_NEW = "new";
    private static final String AC_OK = "ok";
    private static final String AC_CANCEL = "cancel";
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private JTree tree = null;
    private JScrollPane scrollPanel = null;
    private Boolean blank = null;
    private IImager[] imagers = null;
    private IEyepiece[] eyepieces = null;
    private IFilter[] filters = null;
    private ILens[] lenses = null;
    private IObservation[] observations = null;
    private IObserver[] observers = null;
    private IScope[] scopes = null;
    private ISession[] sessions = null;
    private ISite[] sites = null;
    private ITarget[] targets = null;

    public NewDocumentDialog(ObservationManager om) {
        super((Frame)om, true);
        this.om = om;
        super.setTitle(this.bundle.getString("dialog.newDoc.title"));
        super.setSize(480, 480);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initTree();
        this.initDialog();
        this.setVisible(true);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (AC_BLANK.equals(e.getActionCommand())) {
            this.tree.setEnabled(false);
            this.blank = Boolean.TRUE;
        } else if (AC_NEW.equals(e.getActionCommand())) {
            this.tree.setEnabled(true);
            this.blank = Boolean.FALSE;
        } else if (AC_OK.equals(e.getActionCommand())) {
            boolean success = this.prepareResult();
            if (success) {
                super.dispose();
            }
        } else {
            this.blank = null;
            super.dispose();
        }
    }

    public int getResult() {
        if (this.blank == null) {
            return -1;
        }
        if (this.blank.booleanValue()) {
            return 0;
        }
        return 1;
    }

    public ISchemaElement[] getSchemaElements(int schemaElementCode) {
        if (this.getResult() == -1 || this.getResult() == 0) {
            return null;
        }
        switch (schemaElementCode) {
            case 3: {
                return this.imagers;
            }
            case 0: {
                return this.eyepieces;
            }
            case 8: {
                return this.filters;
            }
            case 9: {
                return this.lenses;
            }
            case 2: {
                return this.observations;
            }
            case 6: {
                return this.observers;
            }
            case 1: {
                return this.scopes;
            }
            case 5: {
                return this.sessions;
            }
            case 4: {
                return this.sites;
            }
            case 7: {
                return this.targets;
            }
        }
        return null;
    }

    JTree getTree() {
        return this.tree;
    }

    private boolean prepareResult() {
        TreeModel model = this.tree.getModel();
        Object current = model.getRoot();
        Object node = null;
        Object leaf = null;
        for (int i = 0; i < model.getChildCount(current); ++i) {
            Object uo;
            node = this.tree.getModel().getChild(current, i);
            if (!(node instanceof DefaultMutableTreeNode) || !(((DefaultMutableTreeNode)node).getUserObject() instanceof CheckBoxNode) || !((CheckBoxNode)(uo = ((DefaultMutableTreeNode)node).getUserObject())).isSelected()) continue;
            ArrayList<ISchemaElement> resultList = new ArrayList<ISchemaElement>();
            for (int j = 0; j < model.getChildCount(node); ++j) {
                SchemaElementLeaf sel;
                Object luo;
                leaf = model.getChild(node, j);
                if (!(leaf instanceof DefaultMutableTreeNode) || !((luo = ((DefaultMutableTreeNode)leaf).getUserObject()) instanceof SchemaElementLeaf) || !(sel = (SchemaElementLeaf)luo).isSelected()) continue;
                ISchemaElement se = sel.getSchemaElement();
                resultList.add(se);
            }
            if (resultList.isEmpty()) continue;
            if (resultList.get(0) instanceof IImager) {
                this.imagers = resultList.toArray(new IImager[0]);
                continue;
            }
            if (resultList.get(0) instanceof IEyepiece) {
                this.eyepieces = resultList.toArray(new IEyepiece[0]);
                continue;
            }
            if (resultList.get(0) instanceof IFilter) {
                this.filters = resultList.toArray(new IFilter[0]);
                continue;
            }
            if (resultList.get(0) instanceof ILens) {
                this.lenses = resultList.toArray(new ILens[0]);
                continue;
            }
            if (resultList.get(0) instanceof IObservation) {
                this.observations = resultList.toArray(new IObservation[0]);
                continue;
            }
            if (resultList.get(0) instanceof IObserver) {
                this.observers = resultList.toArray(new IObserver[0]);
                continue;
            }
            if (resultList.get(0) instanceof IScope) {
                this.scopes = resultList.toArray(new IScope[0]);
                continue;
            }
            if (resultList.get(0) instanceof ISession) {
                this.sessions = resultList.toArray(new ISession[0]);
                continue;
            }
            if (resultList.get(0) instanceof ISite) {
                this.sites = resultList.toArray(new ISite[0]);
                continue;
            }
            if (!(resultList.get(0) instanceof ITarget)) continue;
            this.targets = resultList.toArray(new ITarget[0]);
        }
        boolean solvedDependencyProblem = false;
        if (this.observations != null && this.observations.length > 0) {
            for (int i = 0; i < this.observations.length; ++i) {
                ITarget target;
                ISite site;
                ISession session;
                IScope scope;
                IObserver observer;
                ILens lens;
                IImager imager;
                IFilter filter;
                IEyepiece eyepiece = this.observations[i].getEyepiece();
                if (eyepiece != null) {
                    if (this.eyepieces != null && this.eyepieces.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.eyepieces.length; ++j) {
                            if (!this.eyepieces[j].equals(eyepiece)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.eyepieces = (IEyepiece[])this.resizeArray((ISchemaElement[])this.eyepieces, this.eyepieces.length + 1);
                            this.eyepieces[this.eyepieces.length - 1] = eyepiece;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.eyepieces = new IEyepiece[]{eyepiece};
                        solvedDependencyProblem = true;
                    }
                }
                if ((filter = this.observations[i].getFilter()) != null) {
                    if (this.filters != null && this.filters.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.filters.length; ++j) {
                            if (!this.filters[j].equals(filter)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.filters = (IFilter[])this.resizeArray((ISchemaElement[])this.filters, this.filters.length + 1);
                            this.filters[this.filters.length - 1] = filter;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.filters = new IFilter[]{filter};
                        solvedDependencyProblem = true;
                    }
                }
                if ((imager = this.observations[i].getImager()) != null) {
                    if (this.imagers != null && this.imagers.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.imagers.length; ++j) {
                            if (!this.imagers[j].equals(imager)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.imagers = (IImager[])this.resizeArray((ISchemaElement[])this.imagers, this.imagers.length + 1);
                            this.imagers[this.imagers.length - 1] = imager;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.imagers = new IImager[]{imager};
                        solvedDependencyProblem = true;
                    }
                }
                if ((lens = this.observations[i].getLens()) != null) {
                    if (this.lenses != null && this.lenses.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.lenses.length; ++j) {
                            if (!this.lenses[j].equals(lens)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.lenses = (ILens[])this.resizeArray((ISchemaElement[])this.lenses, this.lenses.length + 1);
                            this.lenses[this.lenses.length - 1] = lens;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.lenses = new ILens[]{lens};
                        solvedDependencyProblem = true;
                    }
                }
                if ((observer = this.observations[i].getObserver()) != null) {
                    if (this.observers != null && this.observers.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.observers.length; ++j) {
                            if (!this.observers[j].equals(observer)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.observers = (IObserver[])this.resizeArray((ISchemaElement[])this.observers, this.observers.length + 1);
                            this.observers[this.observers.length - 1] = observer;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.observers = new IObserver[]{observer};
                        solvedDependencyProblem = true;
                    }
                }
                if ((scope = this.observations[i].getScope()) != null) {
                    if (this.scopes != null && this.scopes.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.scopes.length; ++j) {
                            if (!this.scopes[j].equals(scope)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.scopes = (IScope[])this.resizeArray((ISchemaElement[])this.scopes, this.scopes.length + 1);
                            this.scopes[this.scopes.length - 1] = scope;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.scopes = new IScope[]{scope};
                        solvedDependencyProblem = true;
                    }
                }
                if ((session = this.observations[i].getSession()) != null) {
                    if (this.sessions != null && this.sessions.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.sessions.length; ++j) {
                            if (!this.sessions[j].equals(session)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.sessions = (ISession[])this.resizeArray((ISchemaElement[])this.sessions, this.sessions.length + 1);
                            this.sessions[this.sessions.length - 1] = session;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.sessions = new ISession[]{session};
                        solvedDependencyProblem = true;
                    }
                }
                if ((site = this.observations[i].getSite()) != null) {
                    if (this.sites != null && this.sites.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.sites.length; ++j) {
                            if (!this.sites[j].equals(site)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.sites = (ISite[])this.resizeArray((ISchemaElement[])this.sites, this.sites.length + 1);
                            this.sites[this.sites.length - 1] = site;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.sites = new ISite[]{site};
                        solvedDependencyProblem = true;
                    }
                }
                if ((target = this.observations[i].getTarget()) == null) continue;
                if (this.targets != null && this.targets.length > 0) {
                    boolean found = false;
                    for (int j = 0; j < this.targets.length; ++j) {
                        if (!this.targets[j].equals(target)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.targets = (ITarget[])this.resizeArray((ISchemaElement[])this.targets, this.targets.length + 1);
                    this.targets[this.targets.length - 1] = target;
                    solvedDependencyProblem = true;
                    continue;
                }
                this.targets = new ITarget[]{target};
                solvedDependencyProblem = true;
            }
        }
        if (this.sessions != null && this.sessions.length > 0) {
            for (int i = 0; i < this.sessions.length; ++i) {
                ISite site = this.sessions[i].getSite();
                if (site != null) {
                    if (this.sites != null && this.sites.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.sites.length; ++j) {
                            if (!this.sites[j].equals(site)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.sites = (ISite[])this.resizeArray((ISchemaElement[])this.sites, this.sites.length + 1);
                            this.sites[this.sites.length - 1] = site;
                            solvedDependencyProblem = true;
                        }
                    } else {
                        this.sites = new ISite[]{site};
                        solvedDependencyProblem = true;
                    }
                }
                List coObservers = this.sessions[i].getCoObservers();
                Iterator iterator = coObservers.iterator();
                IObserver observer = null;
                while (iterator.hasNext()) {
                    observer = (IObserver)iterator.next();
                    if (observer == null) continue;
                    if (this.observers != null && this.observers.length > 0) {
                        boolean found = false;
                        for (int j = 0; j < this.observers.length; ++j) {
                            if (!this.observers[j].equals(observer)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.observers = (IObserver[])this.resizeArray((ISchemaElement[])this.observers, this.observers.length + 1);
                        this.observers[this.observers.length - 1] = observer;
                        solvedDependencyProblem = true;
                        continue;
                    }
                    this.observers = new IObserver[]{observer};
                    solvedDependencyProblem = true;
                }
            }
        }
        if (this.targets != null && this.targets.length > 0) {
            for (int i = 0; i < this.targets.length; ++i) {
                IObserver observer = this.targets[i].getObserver();
                if (observer == null) continue;
                if (this.observers != null && this.observers.length > 0) {
                    boolean found = false;
                    for (int j = 0; j < this.observers.length; ++j) {
                        if (!this.observers[j].equals(observer)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.observers = (IObserver[])this.resizeArray((ISchemaElement[])this.observers, this.observers.length + 1);
                    this.observers[this.observers.length - 1] = observer;
                    solvedDependencyProblem = true;
                    continue;
                }
                this.observers = new IObserver[]{observer};
                solvedDependencyProblem = true;
            }
        }
        if (solvedDependencyProblem) {
            this.om.createInfo(this.bundle.getString("dialog.newDoc.info.solvedDependencyProblem"));
        }
        return true;
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        ButtonGroup buttonGroup = new ButtonGroup();
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 1, 25, 2);
        constraints.fill = 2;
        JRadioButton newBlankDocument = new JRadioButton(this.bundle.getString("dialog.newDoc.button.blank"));
        newBlankDocument.setToolTipText(this.bundle.getString("dialog.newDoc.tooltip.blank"));
        newBlankDocument.setActionCommand(AC_BLANK);
        newBlankDocument.addActionListener(this);
        newBlankDocument.setSelected(true);
        this.blank = Boolean.TRUE;
        buttonGroup.add(newBlankDocument);
        gridbag.setConstraints(newBlankDocument, constraints);
        super.getContentPane().add(newBlankDocument);
        JRadioButton newDocument = new JRadioButton(this.bundle.getString("dialog.newDoc.button.new"));
        newDocument.setToolTipText(this.bundle.getString("dialog.newDoc.tooltip.new"));
        newDocument.setActionCommand(AC_NEW);
        buttonGroup.add(newDocument);
        newDocument.addActionListener(this);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 2, 1, 25, 2);
        gridbag.setConstraints(newDocument, constraints);
        super.getContentPane().add(newDocument);
        this.tree.setEnabled(false);
        this.tree.setToolTipText(this.bundle.getString("dialog.newDoc.tooltip.tree"));
        this.scrollPanel = new JScrollPane(this.tree);
        this.scrollPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("dialog.newDoc.border.tree")));
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 2, 1, 50, 88);
        constraints.fill = 1;
        gridbag.setConstraints(this.scrollPanel, constraints);
        super.getContentPane().add(this.scrollPanel);
        JButton ok = new JButton(this.bundle.getString("dialog.button.ok"));
        ok.setActionCommand(AC_OK);
        ok.addActionListener(this);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 1, 1, 25, 4);
        constraints.fill = 2;
        gridbag.setConstraints(ok, constraints);
        super.getContentPane().add(ok);
        JButton cancel = new JButton(this.bundle.getString("dialog.button.cancel"));
        cancel.setActionCommand(AC_CANCEL);
        cancel.addActionListener(this);
        ConstraintsBuilder.buildConstraints(constraints, 1, 3, 1, 1, 25, 4);
        constraints.fill = 2;
        gridbag.setConstraints(cancel, constraints);
        super.getContentPane().add(cancel);
    }

    private void initTree() {
        String imagesDir = this.om.getInstallDir().getAbsolutePath() + File.separatorChar + "images" + File.separatorChar;
        ImageIcon expanded = null;
        ImageIcon collapsed = null;
        CheckBoxNode root = new CheckBoxNode(this, this.bundle.getString("treeRoot"), false, null, null, null);
        expanded = new ImageIcon(imagesDir + "observation_e.png");
        collapsed = new ImageIcon(imagesDir + "observation_c.png");
        CheckBoxNode observations = new CheckBoxNode(this, this.bundle.getString("observations"), false, (ISchemaElement[])this.om.getXmlCache().getObservations(), expanded, collapsed);
        root.add(observations);
        expanded = new ImageIcon(imagesDir + "target_e.png");
        collapsed = new ImageIcon(imagesDir + "target_c.png");
        CheckBoxNode targets = new CheckBoxNode(this, this.bundle.getString("targets"), false, (ISchemaElement[])this.om.getXmlCache().getTargets(), expanded, collapsed);
        root.add(targets);
        expanded = new ImageIcon(imagesDir + "scope_e.png");
        collapsed = new ImageIcon(imagesDir + "scope_c.png");
        CheckBoxNode scopes = new CheckBoxNode(this, this.bundle.getString("scopes"), true, (ISchemaElement[])this.om.getXmlCache().getScopes(), expanded, collapsed);
        root.add(scopes);
        expanded = new ImageIcon(imagesDir + "imager_e.png");
        collapsed = new ImageIcon(imagesDir + "imager_c.png");
        CheckBoxNode imagers = new CheckBoxNode(this, this.bundle.getString("imagers"), true, (ISchemaElement[])this.om.getXmlCache().getImagers(), expanded, collapsed);
        root.add(imagers);
        expanded = new ImageIcon(imagesDir + "filter_e.png");
        collapsed = new ImageIcon(imagesDir + "filter_c.png");
        CheckBoxNode filters = new CheckBoxNode(this, this.bundle.getString("filters"), true, (ISchemaElement[])this.om.getXmlCache().getFilters(), expanded, collapsed);
        root.add(filters);
        expanded = new ImageIcon(imagesDir + "eyepiece_e.png");
        collapsed = new ImageIcon(imagesDir + "eyepiece_c.png");
        CheckBoxNode eyepieces = new CheckBoxNode(this, this.bundle.getString("eyepieces"), true, (ISchemaElement[])this.om.getXmlCache().getEyepieces(), expanded, collapsed);
        root.add(eyepieces);
        expanded = new ImageIcon(imagesDir + "lens_e.png");
        collapsed = new ImageIcon(imagesDir + "lens_c.png");
        CheckBoxNode lenses = new CheckBoxNode(this, this.bundle.getString("lenses"), true, (ISchemaElement[])this.om.getXmlCache().getLenses(), expanded, collapsed);
        root.add(lenses);
        expanded = new ImageIcon(imagesDir + "site_e.png");
        collapsed = new ImageIcon(imagesDir + "site_c.png");
        CheckBoxNode sites = new CheckBoxNode(this, this.bundle.getString("sites"), true, (ISchemaElement[])this.om.getXmlCache().getSites(), expanded, collapsed);
        root.add(sites);
        expanded = new ImageIcon(imagesDir + "session_e.png");
        collapsed = new ImageIcon(imagesDir + "session_c.png");
        CheckBoxNode sessions = new CheckBoxNode(this, this.bundle.getString("sessions"), false, (ISchemaElement[])this.om.getXmlCache().getSessions(), expanded, collapsed);
        root.add(sessions);
        expanded = new ImageIcon(imagesDir + "observer_e.png");
        collapsed = new ImageIcon(imagesDir + "observer_c.png");
        CheckBoxNode observers = new CheckBoxNode(this, this.bundle.getString("observers"), true, (ISchemaElement[])this.om.getXmlCache().getObservers(), expanded, collapsed);
        root.add(observers);
        this.tree = new JTree(root);
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.setCellEditor(new CheckBoxNodeEditor(this.tree, renderer));
        this.tree.setEditable(true);
    }

    private ISchemaElement[] resizeArray(ISchemaElement[] oldArray, int newSize) {
        Class<?> elementType = oldArray.getClass().getComponentType();
        ISchemaElement[] newArray = (ISchemaElement[])Array.newInstance(elementType, newSize);
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }
}

