/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.panel.ObservationDialogPanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ObservationDialog
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = -4963447134614319943L;
    private JButton next = new JButton("Next");
    private boolean createAdditionalObservation = false;

    public ObservationDialog(ObservationManager om, IObservation observation) {
        this(om, observation, null);
    }

    public ObservationDialog(ObservationManager om, IObservation observation, ISchemaElement se) {
        super(om, new ObservationDialogPanel(om, observation, se));
        if (observation == null) {
            super.setTitle(AbstractDialog.bundle.getString("dialog.observation.title"));
        } else {
            super.setTitle(AbstractDialog.bundle.getString("dialog.observation.titleEdit") + " " + observation.getDisplayName());
        }
        GridBagLayout gridbag = (GridBagLayout)super.getContentPane().getLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 13;
        constraints.fill = 1;
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 2, 1, 1, 1, 100, 5);
        this.next = new JButton(AbstractDialog.bundle.getString("dialog.button.next"));
        this.next.addActionListener(this);
        gridbag.setConstraints(this.next, constraints);
        super.getContentPane().add(this.next);
        super.getContentPane().remove(this.cancel);
        ConstraintsBuilder.buildConstraints(constraints, 3, 1, 1, 1, 100, 5);
        gridbag.setConstraints(this.cancel, constraints);
        super.getContentPane().add(this.cancel);
        super.setSize(-4963447134614319943L, om.getSize().width - 200, 620);
        super.setLocationRelativeTo(om);
        super.setVisible(true);
    }

    public IObservation getObservation() {
        if (this.schemaElement != null) {
            return (IObservation)this.schemaElement;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton && source.equals(this.next)) {
            this.createAdditionalObservation = true;
            super.actionPerformed(new ActionEvent(this.positive, 1001, "Next pressed"));
            return;
        }
        super.actionPerformed(e);
    }

    public boolean isCreateAdditionalObservation() {
        return this.createAdditionalObservation;
    }
}

