/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.IEquipment;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.CheckBoxEquipmentNode;
import de.lehmannet.om.ui.dialog.CheckBoxNodeEquipmentEditor;
import de.lehmannet.om.ui.dialog.CheckBoxNodeEquipmentRenderer;
import de.lehmannet.om.ui.dialog.EquipmentLeaf;
import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class UnavailableEquipmentDialog
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = 7709563738807903171L;
    private static final String AC_OK = "ok";
    private static final String AC_CANCEL = "cancel";
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private JTree tree = null;
    private JScrollPane scrollPanel = null;
    private boolean changedElements = false;

    public UnavailableEquipmentDialog(ObservationManager om) {
        super(om);
        this.om = om;
        super.setTitle(this.bundle.getString("dialog.unavailableEquipment.title"));
        super.setSize(7709563738807903171L, 380, 360);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initTree();
        this.initDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (AC_OK.equals(e.getActionCommand())) {
            this.markEquipmentUnavailable();
            this.om.updateLeft();
        }
        super.dispose();
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean changedElements() {
        return this.changedElements;
    }

    private void markEquipmentUnavailable() {
        TreeModel model = this.tree.getModel();
        Object current = model.getRoot();
        Object node = null;
        Object leaf = null;
        for (int i = 0; i < model.getChildCount(current); ++i) {
            node = this.tree.getModel().getChild(current, i);
            if (!(node instanceof DefaultMutableTreeNode) || !(((DefaultMutableTreeNode)node).getUserObject() instanceof CheckBoxEquipmentNode)) continue;
            Object uo = ((DefaultMutableTreeNode)node).getUserObject();
            for (int j = 0; j < model.getChildCount(node); ++j) {
                Object luo;
                leaf = model.getChild(node, j);
                if (!(leaf instanceof DefaultMutableTreeNode) || !((luo = ((DefaultMutableTreeNode)leaf).getUserObject()) instanceof EquipmentLeaf)) continue;
                EquipmentLeaf sel = (EquipmentLeaf)luo;
                ISchemaElement se = sel.getSchemaElement();
                if (!sel.isSelected()) {
                    if (!(se instanceof IEquipment)) continue;
                    ((IEquipment)se).setAvailability(false);
                    this.changedElements = true;
                    continue;
                }
                if (!(se instanceof IEquipment)) continue;
                ((IEquipment)se).setAvailability(true);
                this.changedElements = true;
            }
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        this.tree.setEnabled(true);
        this.tree.setToolTipText(this.bundle.getString("dialog.unavailableEquipment.tooltip.tree"));
        this.scrollPanel = new JScrollPane(this.tree);
        this.scrollPanel.setBorder(BorderFactory.createTitledBorder(this.bundle.getString("dialog.unavailableEquipment.border.tree")));
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 1, 50, 92);
        constraints.fill = 1;
        gridbag.setConstraints(this.scrollPanel, constraints);
        super.getContentPane().add(this.scrollPanel);
        JButton ok = new JButton(this.bundle.getString("dialog.button.ok"));
        ok.setActionCommand(AC_OK);
        ok.addActionListener(this);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 25, 4);
        constraints.fill = 2;
        gridbag.setConstraints(ok, constraints);
        super.getContentPane().add(ok);
        JButton cancel = new JButton(this.bundle.getString("dialog.button.cancel"));
        cancel.setActionCommand(AC_CANCEL);
        cancel.addActionListener(this);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 25, 4);
        constraints.fill = 2;
        gridbag.setConstraints(cancel, constraints);
        super.getContentPane().add(cancel);
    }

    private void initTree() {
        String imagesDir = this.om.getInstallDir().getAbsolutePath() + File.separatorChar + "images" + File.separatorChar;
        ImageIcon expanded = null;
        ImageIcon collapsed = null;
        CheckBoxEquipmentNode root = new CheckBoxEquipmentNode(this, this.bundle.getString("treeRoot"), null, null, null);
        expanded = new ImageIcon(imagesDir + "scope_e.png");
        collapsed = new ImageIcon(imagesDir + "scope_c.png");
        CheckBoxEquipmentNode scopes = new CheckBoxEquipmentNode(this, this.bundle.getString("scopes"), (ISchemaElement[])this.om.getXmlCache().getScopes(), expanded, collapsed);
        root.add(scopes);
        expanded = new ImageIcon(imagesDir + "imager_e.png");
        collapsed = new ImageIcon(imagesDir + "imager_c.png");
        CheckBoxEquipmentNode imagers = new CheckBoxEquipmentNode(this, this.bundle.getString("imagers"), (ISchemaElement[])this.om.getXmlCache().getImagers(), expanded, collapsed);
        root.add(imagers);
        expanded = new ImageIcon(imagesDir + "filter_e.png");
        collapsed = new ImageIcon(imagesDir + "filter_c.png");
        CheckBoxEquipmentNode filters = new CheckBoxEquipmentNode(this, this.bundle.getString("filters"), (ISchemaElement[])this.om.getXmlCache().getFilters(), expanded, collapsed);
        root.add(filters);
        expanded = new ImageIcon(imagesDir + "eyepiece_e.png");
        collapsed = new ImageIcon(imagesDir + "eyepiece_c.png");
        CheckBoxEquipmentNode eyepieces = new CheckBoxEquipmentNode(this, this.bundle.getString("eyepieces"), (ISchemaElement[])this.om.getXmlCache().getEyepieces(), expanded, collapsed);
        root.add(eyepieces);
        expanded = new ImageIcon(imagesDir + "lens_e.png");
        collapsed = new ImageIcon(imagesDir + "lens_c.png");
        CheckBoxEquipmentNode lenses = new CheckBoxEquipmentNode(this, this.bundle.getString("lenses"), (ISchemaElement[])this.om.getXmlCache().getLenses(), expanded, collapsed);
        root.add(lenses);
        this.tree = new JTree(root);
        CheckBoxNodeEquipmentRenderer renderer = new CheckBoxNodeEquipmentRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.setCellEditor(new CheckBoxNodeEquipmentEditor(this.tree, renderer));
        this.tree.setEditable(true);
    }
}

