/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.panel;

import de.lehmannet.om.Filter;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.BoxItem;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.OMLabel;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FilterPanel
extends AbstractPanel
implements ItemListener {
    private static final long serialVersionUID = 4294491718036332590L;
    private IFilter filter = null;
    private JTextField model = new JTextField();
    private JComponent type = null;
    private JComponent colorType = null;
    private JTextField wratten = new JTextField();
    private JTextField schott = new JTextField();
    private JTextField vendor = new JTextField();
    private OMLabel LcolorType = null;

    public FilterPanel(IFilter filter, boolean editable) {
        super(editable);
        this.filter = filter;
        this.createPanel();
        if (editable) {
            this.fillBoxes();
        }
        if (filter != null) {
            this.loadSchemaElement();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        BoxItem typeItem;
        Object source = e.getSource();
        if (source.equals(this.type) && e.getStateChange() == 1 && (typeItem = (BoxItem)((JComboBox)this.type).getSelectedItem()) != null && typeItem.getKey().equals("color")) {
            this.colorType.setEnabled(true);
            this.wratten.setEnabled(true);
            this.wratten.setEditable(true);
            this.schott.setEnabled(true);
            this.schott.setEditable(true);
            BoxItem emptyItem = new BoxItem("----");
            ((JComboBox)this.colorType).removeItem(emptyItem);
            this.LcolorType.setFont(new Font("sansserif", 1, 12));
            return;
        }
        this.colorType.setEnabled(false);
        BoxItem emptyItem = new BoxItem("----");
        ((JComboBox)this.colorType).removeItem(emptyItem);
        ((JComboBox)this.colorType).addItem(emptyItem);
        ((JComboBox)this.colorType).setSelectedItem(emptyItem);
        this.wratten.setEnabled(false);
        this.wratten.setText("");
        this.schott.setEnabled(false);
        this.schott.setText("");
        this.LcolorType.setFont(new Font("sansserif", 3, 12));
    }

    public ISchemaElement createSchemaElement() {
        String modelName = this.model.getText();
        if (modelName == null || "".equals(modelName)) {
            super.createWarning(AbstractPanel.bundle.getString("panel.filter.warning.noModel"));
            return null;
        }
        String t = this.getType();
        if (t == null) {
            super.createWarning(AbstractPanel.bundle.getString("panel.filter.warning.noType"));
            return null;
        }
        this.filter = new Filter(modelName, t);
        String ct = this.getColorType();
        if (ct != null) {
            this.filter.setColor(ct);
        }
        this.filter.setWratten(this.wratten.getText());
        this.filter.setSchott(this.schott.getText());
        this.filter.setVendor(this.vendor.getText());
        return this.filter;
    }

    public ISchemaElement getSchemaElement() {
        return this.filter;
    }

    public ISchemaElement updateSchemaElement() {
        if (this.filter == null) {
            return null;
        }
        String modelName = this.model.getText();
        if (modelName == null || "".equals(modelName)) {
            super.createWarning(AbstractPanel.bundle.getString("panel.filter.warning.noModel"));
            return null;
        }
        String t = this.getType();
        if (t == null) {
            super.createWarning(AbstractPanel.bundle.getString("panel.filter.warning.noType"));
            return null;
        }
        this.filter.setModel(modelName);
        this.filter.setType(t);
        String ct = this.getColorType();
        if (ct != null) {
            this.filter.setColor(ct);
        }
        this.filter.setWratten(this.wratten.getText());
        this.filter.setSchott(this.schott.getText());
        this.filter.setVendor(this.vendor.getText());
        return this.filter;
    }

    public static String getI18Ntype(String type) {
        return BoxItem.getI18NString(type);
    }

    public static String getI18Ncolor(String type) {
        return BoxItem.getI18NString(type);
    }

    private String getType() {
        Object t = null;
        if (super.isEditable()) {
            t = ((JComboBox)this.type).getSelectedItem();
            BoxItem bi = (BoxItem)t;
            if (bi.isEmptyItem()) {
                return null;
            }
            return bi.getKey();
        }
        t = ((JTextField)this.type).getText();
        return (String)t;
    }

    private String getColorType() {
        Object t = null;
        if (super.isEditable()) {
            t = ((JComboBox)this.colorType).getSelectedItem();
            BoxItem bi = (BoxItem)t;
            if (bi.isEmptyItem()) {
                return null;
            }
            return bi.getKey();
        }
        t = ((JTextField)this.colorType).getText();
        return (String)t;
    }

    private void loadSchemaElement() {
        this.model.setText(this.filter.getModel());
        this.model.setEditable(super.isEditable());
        if (this.filter.getVendor() != null) {
            this.vendor.setText(this.filter.getVendor());
        }
        this.vendor.setEditable(super.isEditable());
        if (super.isEditable()) {
            ((JComboBox)this.type).setSelectedItem(new BoxItem(this.filter.getType()));
            this.type.setEnabled(super.isEditable());
        } else {
            ((JTextField)this.type).setText(BoxItem.getI18NString(this.filter.getType()));
            ((JTextField)this.type).setEditable(super.isEditable());
        }
        if (this.filter.getColor() != null) {
            if (super.isEditable()) {
                this.colorType.setEnabled(super.isEditable());
            } else {
                ((JTextField)this.colorType).setEditable(super.isEditable());
            }
            if (super.isEditable()) {
                ((JComboBox)this.colorType).setSelectedItem(new BoxItem(this.filter.getColor()));
            } else {
                ((JTextField)this.colorType).setText(BoxItem.getI18NString(this.filter.getColor()));
            }
            if (this.filter.getWratten() != null && !"".equals(this.filter.getWratten())) {
                this.wratten.setText(this.filter.getWratten());
            }
            this.wratten.setEditable(super.isEditable());
            if (this.filter.getSchott() != null && !"".equals(this.filter.getSchott())) {
                this.schott.setText(this.filter.getSchott());
            }
            this.schott.setEditable(super.isEditable());
        }
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 5, 1);
        OMLabel LmodelName = new OMLabel(AbstractPanel.bundle.getString("panel.filter.label.model"), true);
        LmodelName.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.model"));
        gridbag.setConstraints(LmodelName, constraints);
        this.add(LmodelName);
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 45, 1);
        this.model.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.model"));
        gridbag.setConstraints(this.model, constraints);
        this.add(this.model);
        ConstraintsBuilder.buildConstraints(constraints, 2, 0, 1, 1, 5, 1);
        OMLabel Lvendor = new OMLabel(AbstractPanel.bundle.getString("panel.filter.label.vendor"), false);
        Lvendor.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.vendor"));
        gridbag.setConstraints(Lvendor, constraints);
        this.add(Lvendor);
        ConstraintsBuilder.buildConstraints(constraints, 3, 0, 1, 1, 45, 1);
        this.vendor.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.vendor"));
        gridbag.setConstraints(this.vendor, constraints);
        this.add(this.vendor);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 5, 1);
        OMLabel Ltype = new OMLabel(AbstractPanel.bundle.getString("panel.filter.label.type"), true);
        Ltype.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.type"));
        gridbag.setConstraints(Ltype, constraints);
        this.add(Ltype);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 45, 1);
        if (super.isEditable()) {
            this.type = new JComboBox();
            ((JComboBox)this.type).addItemListener(this);
        } else {
            this.type = new JTextField();
        }
        this.type.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.type"));
        gridbag.setConstraints(this.type, constraints);
        this.add(this.type);
        ConstraintsBuilder.buildConstraints(constraints, 2, 1, 1, 1, 5, 1);
        this.LcolorType = new OMLabel(AbstractPanel.bundle.getString("panel.filter.label.colorType"), false);
        this.LcolorType.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.colorType"));
        gridbag.setConstraints(this.LcolorType, constraints);
        this.add(this.LcolorType);
        ConstraintsBuilder.buildConstraints(constraints, 3, 1, 1, 1, 45, 1);
        if (super.isEditable()) {
            this.colorType = new JComboBox();
            this.colorType.setEnabled(false);
        } else {
            this.colorType = new JTextField();
            ((JTextField)this.colorType).setEditable(false);
        }
        this.colorType.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.colorType"));
        gridbag.setConstraints(this.colorType, constraints);
        this.add(this.colorType);
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 1, 1, 5, 1);
        OMLabel Lwratten = new OMLabel(AbstractPanel.bundle.getString("panel.filter.label.wratten"), false);
        Lwratten.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.wratten"));
        gridbag.setConstraints(Lwratten, constraints);
        this.add(Lwratten);
        ConstraintsBuilder.buildConstraints(constraints, 1, 2, 1, 1, 45, 1);
        this.wratten.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.wratten"));
        gridbag.setConstraints(this.wratten, constraints);
        this.wratten.setEditable(false);
        this.add(this.wratten);
        ConstraintsBuilder.buildConstraints(constraints, 2, 2, 1, 1, 5, 1);
        OMLabel Lschott = new OMLabel(AbstractPanel.bundle.getString("panel.filter.label.schott"), false);
        Lschott.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.schott"));
        gridbag.setConstraints(Lschott, constraints);
        this.add(Lschott);
        ConstraintsBuilder.buildConstraints(constraints, 3, 2, 1, 1, 45, 1);
        this.schott.setToolTipText(AbstractPanel.bundle.getString("panel.filter.tooltip.schott"));
        gridbag.setConstraints(this.schott, constraints);
        this.schott.setEditable(false);
        this.add(this.schott);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 4, 1, 100, 90);
        constraints.fill = 1;
        JLabel Lfill = new JLabel("");
        gridbag.setConstraints(Lfill, constraints);
        this.add(Lfill);
    }

    private void fillBoxes() {
        JComboBox t = (JComboBox)this.type;
        BoxItem typeEmptyItem = new BoxItem("----");
        if (super.isEditable() && this.filter == null) {
            t.addItem(typeEmptyItem);
        }
        t.addItem(new BoxItem("neutral"));
        t.addItem(new BoxItem("color"));
        t.addItem(new BoxItem("broad band"));
        t.addItem(new BoxItem("H-alpha"));
        t.addItem(new BoxItem("H-beta"));
        t.addItem(new BoxItem("O-III"));
        t.addItem(new BoxItem("narrow band"));
        t.addItem(new BoxItem("solar"));
        t.addItem(new BoxItem("corrective"));
        t.addItem(new BoxItem("other"));
        t.setSelectedItem(typeEmptyItem);
        JComboBox c = (JComboBox)this.colorType;
        BoxItem colorEmptyItem = new BoxItem("----");
        if (super.isEditable() && this.filter == null) {
            c.addItem(colorEmptyItem);
        }
        c.addItem(new BoxItem("light red"));
        c.addItem(new BoxItem("red"));
        c.addItem(new BoxItem("deep red"));
        c.addItem(new BoxItem("orange"));
        c.addItem(new BoxItem("light yellow"));
        c.addItem(new BoxItem("yellow"));
        c.addItem(new BoxItem("deep yellow"));
        c.addItem(new BoxItem("yellow-green"));
        c.addItem(new BoxItem("light green"));
        c.addItem(new BoxItem("green"));
        c.addItem(new BoxItem("medium blue"));
        c.addItem(new BoxItem("pale blue"));
        c.addItem(new BoxItem("blue"));
        c.addItem(new BoxItem("deep blue"));
        c.addItem(new BoxItem("violet"));
        c.setSelectedItem(colorEmptyItem);
    }
}

