/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.preferences;

import de.lehmannet.om.ui.box.LanguageBox;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.preferences.PreferencesPanel;
import de.lehmannet.om.ui.util.Configuration;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import de.lehmannet.om.ui.util.OMLabel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class GeneralPanel
extends PreferencesPanel {
    private static final long serialVersionUID = 7383101472997890151L;
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private JCheckBox loadLastFile = null;
    private JCheckBox checkForUpdates = null;
    private LanguageBox uiLanguage = null;
    private JComboBox xslTemplate = null;
    private JButton resetWindowSizes = null;

    public GeneralPanel(Configuration config, ObservationManager om) {
        super(config);
        this.om = om;
        this.createPanel();
    }

    public String getTabTitle() {
        return this.bundle.getString("dialog.preferences.generalTab.title");
    }

    public void writeConfig() {
        this.configuration.setConfig("om.lastOpenedXML.onStartup", "" + this.loadLastFile.isSelected());
        this.configuration.setConfig("om.update.checkForUpdates", "" + this.checkForUpdates.isSelected());
        this.configuration.setConfig("om.language", "" + this.uiLanguage.getSelectedISOLanguage());
        this.om.reloadLanguage();
        if (this.xslTemplate.getSelectedItem() != null) {
            this.configuration.setConfig("om.transform.xsl.template", "" + this.xslTemplate.getSelectedItem());
        }
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 10, 15);
        constraints.anchor = 17;
        OMLabel loadLastXMLLabel = new OMLabel(this.bundle.getString("dialog.preferences.label.loadLastXML"), true);
        loadLastXMLLabel.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.loadLastXML"));
        gridbag.setConstraints(loadLastXMLLabel, constraints);
        super.add(loadLastXMLLabel);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 0, 1, 1, 40, 15);
        this.loadLastFile = new JCheckBox();
        this.loadLastFile.setSelected(Boolean.valueOf(this.configuration.getConfig("om.lastOpenedXML.onStartup")));
        this.loadLastFile.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.loadLastXML"));
        gridbag.setConstraints(this.loadLastFile, constraints);
        super.add(this.loadLastFile);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 10, 15);
        constraints.anchor = 17;
        OMLabel checkForUpdates = new OMLabel(this.bundle.getString("dialog.preferences.label.checkForUpdatesDuringStartup"), true);
        checkForUpdates.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.checkForUpdatesDuringStartup"));
        gridbag.setConstraints(checkForUpdates, constraints);
        super.add(checkForUpdates);
        constraints.fill = 2;
        constraints.anchor = 17;
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 40, 15);
        this.checkForUpdates = new JCheckBox();
        this.checkForUpdates.setSelected(Boolean.valueOf(this.configuration.getConfig("om.update.checkForUpdates")));
        this.checkForUpdates.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.checkForUpdatesDuringStartup"));
        gridbag.setConstraints(this.checkForUpdates, constraints);
        super.add(this.checkForUpdates);
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 1, 1, 10, 15);
        constraints.anchor = 17;
        OMLabel uiLanguageLabel = new OMLabel(this.bundle.getString("dialog.preferences.label.uiLanguage"), true);
        uiLanguageLabel.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.uiLanguage"));
        gridbag.setConstraints(uiLanguageLabel, constraints);
        super.add(uiLanguageLabel);
        ConstraintsBuilder.buildConstraints(constraints, 1, 2, 1, 1, 40, 15);
        constraints.fill = 2;
        constraints.anchor = 17;
        List acceptedLanguages = this.getInstalledLanguages();
        this.uiLanguage = new LanguageBox(acceptedLanguages, Locale.getDefault().getLanguage(), false);
        this.uiLanguage.setEnabled(true);
        this.uiLanguage.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.uiLanguage"));
        gridbag.setConstraints(this.uiLanguage, constraints);
        super.add(this.uiLanguage);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 1, 1, 10, 15);
        constraints.anchor = 17;
        OMLabel LxslTemplate = new OMLabel(this.bundle.getString("dialog.preferences.label.xslTemplate"), true);
        LxslTemplate.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.xslTemplate"));
        gridbag.setConstraints(LxslTemplate, constraints);
        super.add(LxslTemplate);
        ConstraintsBuilder.buildConstraints(constraints, 1, 3, 1, 1, 40, 15);
        constraints.fill = 2;
        constraints.anchor = 17;
        this.createXslTemplateBox();
        this.xslTemplate.setEnabled(true);
        this.xslTemplate.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.xslTemplate"));
        gridbag.setConstraints(this.xslTemplate, constraints);
        super.add(this.xslTemplate);
        ConstraintsBuilder.buildConstraints(constraints, 0, 4, 1, 1, 10, 15);
        constraints.anchor = 17;
        OMLabel LresetWindowsSizes = new OMLabel(this.bundle.getString("dialog.preferences.label.resetWindowSizes"), true);
        LresetWindowsSizes.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.resetWindowSizes"));
        gridbag.setConstraints(LresetWindowsSizes, constraints);
        super.add(LresetWindowsSizes);
        ConstraintsBuilder.buildConstraints(constraints, 1, 4, 1, 1, 40, 15);
        constraints.fill = 2;
        constraints.anchor = 17;
        this.resetWindowSizes = new JButton(this.bundle.getString("dialog.preferences.button.resetWindowSizes"));
        this.resetWindowSizes.setActionCommand("ResetWindowSizes");
        this.resetWindowSizes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if ("ResetWindowSizes".equals(e.getActionCommand())) {
                    GeneralPanel.this.om.resetWindowSizes();
                }
            }
        });
        this.resetWindowSizes.setToolTipText(this.bundle.getString("dialog.preferences.tooltip.resetWindowSizes"));
        gridbag.setConstraints(this.resetWindowSizes, constraints);
        super.add(this.resetWindowSizes);
        ConstraintsBuilder.buildConstraints(constraints, 0, 5, 2, 1, 100, 40);
        constraints.fill = 1;
        JLabel Lfill = new JLabel("");
        gridbag.setConstraints(Lfill, constraints);
        super.add(Lfill);
    }

    private void createXslTemplateBox() {
        this.xslTemplate = new JComboBox();
        File path = new File(this.om.getInstallDir().getAbsolutePath() + File.separator + "xsl");
        if (!path.exists()) {
            return;
        }
        String[] directories = path.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir.getAbsolutePath() + File.separator + name);
                return file.isDirectory() && !"CVS".equals(file.getName());
            }
        });
        for (int i = 0; i < directories.length; ++i) {
            this.xslTemplate.addItem(directories[i]);
        }
        if (directories.length > 0) {
            this.xslTemplate.setSelectedItem(this.om.getConfiguration().getConfig("om.transform.xsl.template", directories[0]));
        } else {
            this.xslTemplate.setSelectedItem(this.om.getConfiguration().getConfig("om.transform.xsl.template"));
        }
    }

    private List getInstalledLanguages() {
        int i;
        File[] jars;
        ArrayList result = new ArrayList();
        String sep = System.getProperty("path.separator");
        String path = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(path, sep);
        File token = null;
        while (tokenizer.hasMoreTokens()) {
            token = new File(tokenizer.nextToken());
            if (!token.isFile() || !"observationManager.jar".equals(token.getName())) continue;
            result.addAll(this.scanJarFile(token));
            return result;
        }
        String extPath = System.getProperty("java.ext.dirs");
        File ext = new File(extPath);
        if (ext.exists() && (jars = ext.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return "observationManager.jar".equals(name);
            }
        })) != null && (i = 0) < jars.length) {
            result.addAll(this.scanJarFile(jars[i]));
            return result;
        }
        return result;
    }

    private ArrayList scanJarFile(File jarFile) {
        ArrayList<String> result = new ArrayList<String>();
        ZipFile archive = null;
        try {
            archive = new ZipFile(jarFile);
        }
        catch (ZipException zipEx) {
            System.err.println("Error while accessing JAR file.\n" + zipEx);
            return null;
        }
        catch (IOException ioe) {
            System.err.println("Error while accessing JAR file.\n" + ioe);
            return null;
        }
        Enumeration<? extends ZipEntry> enu = archive.entries();
        Locale l = null;
        while (enu.hasMoreElements()) {
            ZipEntry entry = enu.nextElement();
            String name = entry.getName();
            if (!name.startsWith("ObservationManager_") || !name.endsWith(".properties")) continue;
            l = new Locale(name.substring(name.indexOf("_") + 1, name.indexOf(".")));
            result.add(l.getLanguage());
        }
        return result;
    }
}

