/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.preferences;

import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.preferences.BehaviourPanel;
import de.lehmannet.om.ui.preferences.GeneralPanel;
import de.lehmannet.om.ui.preferences.PreferencesPanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JTabbedPane;

public class PreferencesDialog
extends OMDialog
implements ActionListener {
    private static final long serialVersionUID = -8289411368690909665L;
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager om = null;
    private JTabbedPane tabbedPane = null;
    private PreferencesPanel genericPanel = null;
    private PreferencesPanel behaviourPanel = null;
    private JButton ok = new JButton(this.bundle.getString("dialog.button.ok"));
    private JButton cancel = new JButton(this.bundle.getString("dialog.button.cancel"));

    public PreferencesDialog(ObservationManager om, PreferencesPanel[] additionalPanels) {
        super(om);
        this.om = om;
        super.setTitle(this.bundle.getString("dialog.preferences.title"));
        super.setSize(-8289411368690909665L, 750, 267);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(om);
        this.initDialog();
        for (int i = 0; i < additionalPanels.length; ++i) {
            this.addPreferencesTab(additionalPanels[i]);
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.cancel)) {
                this.dispose();
            } else {
                this.applySettings();
                this.dispose();
            }
        }
    }

    private void addPreferencesTab(PreferencesPanel panel) {
        if (panel != null) {
            this.tabbedPane.addTab(panel.getTabTitle(), panel);
        }
    }

    private void applySettings() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            ((PreferencesPanel)this.tabbedPane.getComponentAt(i)).writeConfig();
        }
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        super.getContentPane().setLayout(gridbag);
        this.tabbedPane = new JTabbedPane();
        this.genericPanel = new GeneralPanel(this.om.getConfiguration(), this.om);
        this.behaviourPanel = new BehaviourPanel(this.om.getConfiguration(), this.om);
        this.tabbedPane.addTab(this.genericPanel.getTabTitle(), this.genericPanel);
        this.tabbedPane.addTab(this.behaviourPanel.getTabTitle(), this.behaviourPanel);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 4, 33, 33);
        constraints.anchor = 18;
        constraints.fill = 2;
        gridbag.setConstraints(this.tabbedPane, constraints);
        super.getContentPane().add(this.tabbedPane);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 1, 1, 33, 33);
        constraints.fill = 2;
        constraints.anchor = 15;
        this.ok.addActionListener(this);
        gridbag.setConstraints(this.ok, constraints);
        super.getContentPane().add(this.ok);
        ConstraintsBuilder.buildConstraints(constraints, 1, 3, 1, 1, 33, 33);
        constraints.fill = 2;
        constraints.anchor = 15;
        this.cancel.addActionListener(this);
        gridbag.setConstraints(this.cancel, constraints);
        super.getContentPane().add(this.cancel);
    }
}

