/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.statistics;

import de.lehmannet.om.IFinding;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.catalog.IListableCatalog;
import de.lehmannet.om.ui.statistics.CatalogTargets;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JProgressBar;

class CatalogChecker
implements Runnable {
    private IListableCatalog catalog = null;
    private IObservation[] observations = null;
    private CatalogTargets catalogTargets = null;
    private List selectedObservers = null;
    private boolean useCoObservers = true;
    private boolean run = true;
    private JProgressBar progressBar = null;

    public CatalogChecker(IListableCatalog catalog, IObservation[] observations, List observers, boolean useCoObservers, JProgressBar progress) {
        this.catalog = catalog;
        this.observations = observations;
        this.selectedObservers = observers;
        this.useCoObservers = useCoObservers;
        this.progressBar = progress;
    }

    public CatalogTargets getCatalogTargets() {
        return this.catalogTargets;
    }

    public IListableCatalog getCatalog() {
        return this.catalog;
    }

    public void stop() {
        this.run = false;
    }

    public boolean isRunning() {
        return this.run;
    }

    public void run() {
        ITarget[] targets = this.catalog.getTargets();
        this.catalogTargets = new CatalogTargets(this.catalog, targets);
        double onePercent = 100.0 / (double)this.observations.length;
        for (int i = 0; i < this.observations.length && this.run; ++i) {
            if (!this.selectedObservers.contains(this.observations[i].getObserver())) {
                if (!this.useCoObservers || this.observations[i].getSession() == null || this.observations[i].getSession().getCoObservers() == null || this.observations[i].getSession().getCoObservers().isEmpty()) continue;
                List coObservers = this.observations[i].getSession().getCoObservers();
                ListIterator iterator = coObservers.listIterator();
                IObserver current = null;
                boolean found = false;
                while (iterator.hasNext()) {
                    current = (IObserver)iterator.next();
                    if (!this.selectedObservers.contains(current)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            ListIterator findingIterator = this.observations[i].getResults().listIterator();
            boolean findingSeen = false;
            while (findingIterator.hasNext()) {
                if (!((IFinding)findingIterator.next()).wasSeen()) continue;
                findingSeen = true;
                break;
            }
            if (!findingSeen) continue;
            this.catalogTargets.checkTarget(this.observations[i]);
            this.progressBar.setValue((int)Math.round((double)i * onePercent));
            this.progressBar.setString("" + (int)Math.round((double)i * onePercent) + "%");
        }
        this.run = false;
    }
}

