/*
 * Decompiled with CFR 0.152.
 */
package eap.filter;

import eap.filter.Filter;
import eap.filter.FilterException;
import eap.filter.PasswordProvider;
import eap.filter.PopupPasswordProvider;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class FilterBroker {
    Map filters = new HashMap();
    PasswordProvider password_source;
    String last_filename;

    public void setPasswordProvider(PasswordProvider passwordProvider) {
        this.password_source = passwordProvider;
    }

    public void addDefaultFilters() throws IOException {
        this.addDefaultFilters(this.getClass());
    }

    public void addDefaultFilters(Class clazz) throws IOException {
        String string;
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string = clazz.getPackage().getName().replace('.', '/') + "/filter.properties");
        if (inputStream == null) {
            throw new IOException("Could not find default filter property file");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        this.addFilters(properties);
    }

    public void addFilters(Properties properties) {
        int n = 0;
        String string;
        while ((string = properties.getProperty("exten" + n)) != null) {
            String string2 = properties.getProperty("class" + n);
            if (string2 == null) {
                return;
            }
            String string3 = properties.getProperty("name" + n);
            if (string3 != null) {
                this.addFilter(string, string2, string3);
            }
            ++n;
        }
        return;
    }

    public void addFilter(String string, String string2, String string3) {
        this.addFilter(new Filter(string, string2, string3));
    }

    private void addFilter(Filter filter) {
        this.filters.put(filter.getEnding(), filter);
    }

    private Filter findFilter(String string) {
        Iterator iterator = this.filters.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            return (Filter)this.filters.get(string2);
        }
        return null;
    }

    public boolean hasFilter(String string) {
        return this.findFilter(string) != null;
    }

    public InputStream filter(InputStream inputStream, String string) throws FilterException {
        Filter filter;
        if (string.endsWith(".tgz")) {
            string = string.substring(0, string.length() - 4) + ".tar.gz";
        }
        if ((filter = this.findFilter(string)) == null) {
            this.last_filename = string;
            return inputStream;
        }
        inputStream = filter.instantiate(inputStream, this.password_source);
        string = string.substring(0, string.length() - filter.getEnding().length());
        return this.filter(inputStream, string);
    }

    public String getLastFileName() {
        return this.last_filename;
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2 = null;
        FilterBroker filterBroker = new FilterBroker();
        filterBroker.addDefaultFilters();
        filterBroker.setPasswordProvider(new PopupPasswordProvider(null));
        InputStream inputStream = new FileInputStream(string2);
        inputStream = filterBroker.filter(inputStream, string2);
        System.out.println(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println(string);
        }
        System.exit(0);
    }
}

