/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsCard;
import eap.fits.FitsCardException;
import eap.fits.FitsData;
import eap.fits.FitsException;
import eap.fits.FitsHeader;
import eap.fits.NoSuchFitsCardException;
import eap.fits.RealImageConsumer;
import eap.fits.RealImageProducer;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FitsImageData
extends FitsData {
    private int naxes;
    private int[] dimen;
    private int[] base;
    private int bitpix;
    private int bytepix;
    private boolean isReal;
    private double min;
    private double max;
    private boolean min_known;
    private boolean max_known;
    private boolean scaled;
    private double bzero;
    private double bscale;
    private boolean null_flag_defined;
    private int null_flag;
    private int valid_pixels;
    private Set views;

    public FitsImageData(FitsHeader fitsHeader) throws FitsException {
        super(fitsHeader.dataSize());
        this.naxes = fitsHeader.card("NAXIS").intValue();
        int[] nArray = new int[this.naxes];
        for (int i = 0; i < this.naxes; ++i) {
            nArray[i] = fitsHeader.card("NAXIS" + (i + 1)).intValue();
        }
        this.bitpix = fitsHeader.card("BITPIX").intValue();
        if (this.bitpix < 0) {
            this.isReal = true;
            this.bitpix = -this.bitpix;
        } else {
            this.isReal = false;
        }
        this.initializeDimensions(this.bitpix, this.isReal, nArray);
        try {
            this.min = fitsHeader.card("DATAMIN").doubleValue();
            this.min_known = true;
        }
        catch (FitsCardException fitsCardException) {
            this.min_known = false;
        }
        try {
            this.max = fitsHeader.card("DATAMAX").doubleValue();
            this.max_known = true;
        }
        catch (FitsCardException fitsCardException) {
            this.max_known = false;
        }
        this.scaled = false;
        try {
            this.bzero = fitsHeader.card("BZERO").doubleValue();
            this.scaled = true;
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            this.bzero = 0.0;
        }
        try {
            this.bscale = fitsHeader.card("BSCALE").doubleValue();
            this.scaled = true;
        }
        catch (NoSuchFitsCardException noSuchFitsCardException) {
            this.bscale = 1.0;
        }
    }

    public FitsImageData(int n, boolean bl, int[] nArray) throws FitsException {
        super(FitsImageData.sizeFromDimensions(n, nArray));
        this.initializeDimensions(n, bl, nArray);
    }

    public FitsImageData() throws FitsException {
        this(8, false, null);
    }

    private void initializeDimensions(int n, boolean bl, int[] nArray) throws FitsException {
        this.naxes = nArray != null ? nArray.length : 0;
        if (this.naxes > 0) {
            int n2;
            this.dimen = new int[this.naxes];
            for (n2 = 0; n2 < this.naxes; ++n2) {
                this.dimen[n2] = nArray[n2];
            }
            this.base = new int[this.naxes];
            this.base[0] = 1;
            for (n2 = 1; n2 < this.naxes; ++n2) {
                this.base[n2] = this.base[n2 - 1] * nArray[n2 - 1];
            }
        }
        if (bl && n != 32 && n != 64 || n != 8 && n != 16 && n != 32) {
            throw new FitsException("BITPIX=" + n + " not supported");
        }
        this.bitpix = n;
        this.isReal = bl;
        this.bytepix = n / 8;
        this.views = new HashSet();
    }

    private static int sizeFromDimensions(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return 0;
        }
        int n2 = n / 8;
        for (int i = 0; i < nArray.length; ++i) {
            n2 *= nArray[i];
        }
        return n2;
    }

    public int pixelCount() {
        int n = 1;
        for (int i = 0; i < this.naxes; ++i) {
            n *= this.dimen[i];
        }
        return n;
    }

    public double min() throws FitsException {
        if (!this.min_known) {
            this.calculateMinMax();
        }
        return this.min;
    }

    public double max() throws FitsException {
        if (!this.max_known) {
            this.calculateMinMax();
        }
        return this.max;
    }

    public void setValidBytes(int n) throws FitsException {
        super.setValidBytes(n);
        this.valid_pixels = n / this.bytepix;
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            view.morePixelsAvailable();
        }
    }

    public RealImageProducer createView(int n, int n2, int[] nArray) throws FitsException {
        if (n >= this.naxes) {
            throw new FitsException("View X axis " + n + " invalid");
        }
        if (n2 >= this.naxes) {
            throw new FitsException("View Y axis " + n2 + " invalid");
        }
        View view = new View(n, n2, nArray);
        this.views.add(view);
        return view;
    }

    public RealImageProducer createView() throws FitsException {
        int[] nArray = new int[this.naxes];
        return this.createView(0, 1, nArray);
    }

    public void removeView(View view) {
        this.views.remove(view);
    }

    private long pixelNumber(int[] nArray) {
        long l = 0L;
        for (int i = 0; i < this.naxes; ++i) {
            l += (long)(nArray[i] * this.base[i]);
        }
        return l;
    }

    public void goToPixel(int[] nArray) {
        this.goToByte((long)this.bytepix * this.pixelNumber(nArray));
    }

    public void goToPixel() {
        this.goToByte(0L);
    }

    public Number getNextRawPixel() throws FitsException {
        Number number;
        block9: {
            try {
                if (this.isReal) {
                    if (this.bitpix == 32) {
                        number = new Float(this.interpreter.readFloat());
                        break block9;
                    }
                    if (this.bitpix == 64) {
                        number = new Double(this.interpreter.readDouble());
                        break block9;
                    }
                    throw new FitsException("BITPIX=" + -this.bitpix + " not supported");
                }
                if (this.bitpix == 8) {
                    number = new Integer(this.interpreter.readUnsignedByte());
                    break block9;
                }
                if (this.bitpix == 16) {
                    number = new Short(this.interpreter.readShort());
                    break block9;
                }
                if (this.bitpix == 32) {
                    number = new Integer(this.interpreter.readInt());
                    break block9;
                }
                throw new FitsException("BITPIX=" + this.bitpix + " not supported");
            }
            catch (EOFException eOFException) {
                throw new FitsException("No such pixel in " + this);
            }
            catch (IOException iOException) {
                throw new FitsException("Couldn't get pixel in " + this);
            }
        }
        return number;
    }

    public double getNextPixel() throws FitsException {
        Number number = this.getNextRawPixel();
        if (this.null_flag_defined && !this.isReal && number.intValue() == this.null_flag) {
            return Double.NaN;
        }
        if (this.scaled) {
            return number.doubleValue() * this.bscale + this.bzero;
        }
        return number.doubleValue();
    }

    private void calculateMinMax() throws FitsException {
        if (this.min_known && this.max_known) {
            return;
        }
        double d = Double.NaN;
        double d2 = Double.NaN;
        this.goToPixel();
        for (int i = 0; i < this.pixelCount(); ++i) {
            double d3 = this.getNextPixel();
            if (Double.isNaN(d3)) continue;
            if (d3 < d || Double.isNaN(d)) {
                d = d3;
            }
            if (!(d3 > d2) && !Double.isNaN(d2)) continue;
            d2 = d3;
        }
        if (!this.min_known) {
            this.min = d;
            this.min_known = true;
        }
        if (!this.max_known) {
            this.max = d2;
            this.max_known = true;
        }
    }

    public FitsHeader createHeader(String string) {
        FitsHeader fitsHeader = new FitsHeader();
        boolean bl = string.equalsIgnoreCase("PRIMARY");
        if (bl) {
            fitsHeader.add(new FitsCard("SIMPLE", true, "file conforms to FITS standard"));
        } else {
            fitsHeader.add(new FitsCard("XTENSION", "IMAGE", "image extension"));
        }
        if (this.isReal) {
            fitsHeader.add(new FitsCard("BITPIX", -this.bitpix, "number of bits per pixel"));
        } else {
            fitsHeader.add(new FitsCard("BITPIX", this.bitpix, "number of bits per pixel"));
        }
        fitsHeader.add(new FitsCard("NAXIS", this.naxes, "number of data axes"));
        for (int i = 0; i < this.naxes; ++i) {
            fitsHeader.add(new FitsCard("NAXIS" + (i + 1), this.dimen[i], "length of data axis " + (i + 1)));
        }
        if (bl) {
            fitsHeader.add(new FitsCard("EXTEND", true, "file may contain extensions"));
        } else {
            fitsHeader.add(new FitsCard("PCOUNT", 0, "number of random group parameters"));
            fitsHeader.add(new FitsCard("GCOUNT", 0, "number of random groups"));
        }
        if (!bl && string.length() > 0) {
            fitsHeader.add(new FitsCard("EXTNAME", string, "name of extension"));
        }
        if (this.scaled) {
            fitsHeader.add(new FitsCard("BZERO", this.bzero, "pixel scale zero point"));
            fitsHeader.add(new FitsCard("BSCALE", this.bscale, "pixel scale"));
        }
        if (this.min_known) {
            fitsHeader.add(new FitsCard("DATAMIN", this.min, "minimum pixel value"));
        }
        if (this.max_known) {
            fitsHeader.add(new FitsCard("DATAMAX", this.max, "maximum pixel value"));
        }
        fitsHeader.add(new FitsCard("END"));
        return fitsHeader;
    }

    private class View
    implements RealImageProducer {
        private int x_axis;
        private int y_axis;
        private int[] coord;
        private long first_image_pixel;
        private long last_image_pixel;
        private double[] pixels;
        private int npixels;
        private Set real_consumers;
        private int lines_sent;

        public View(int n, int n2, int[] nArray) throws FitsException {
            this.x_axis = n;
            this.y_axis = n2;
            this.coord = nArray;
            this.coord[n] = 0;
            this.coord[n2] = 0;
            this.first_image_pixel = FitsImageData.this.pixelNumber(this.coord);
            this.coord[n] = FitsImageData.this.dimen[n];
            this.coord[n2] = FitsImageData.this.dimen[n2];
            this.last_image_pixel = FitsImageData.this.pixelNumber(this.coord);
            this.real_consumers = new HashSet();
            this.pixels = new double[FitsImageData.this.dimen[n] * FitsImageData.this.dimen[n2]];
            this.npixels = 0;
            this.decodeImagePixels();
        }

        private void decodeImagePixels() throws FitsException {
            for (int i = this.npixels; i < this.pixels.length; ++i) {
                this.coord[this.x_axis] = i % FitsImageData.this.dimen[this.x_axis];
                this.coord[this.y_axis] = FitsImageData.this.dimen[this.y_axis] - i / FitsImageData.this.dimen[this.x_axis] - 1;
                if (FitsImageData.this.pixelNumber(this.coord) >= (long)FitsImageData.this.valid_pixels) {
                    this.npixels = i;
                    return;
                }
                FitsImageData.this.goToPixel(this.coord);
                this.pixels[i] = FitsImageData.this.getNextPixel();
            }
            this.npixels = this.pixels.length;
        }

        public void morePixelsAvailable() throws FitsException {
            this.decodeImagePixels();
            this.sendAvailablePixels();
        }

        public void addConsumer(RealImageConsumer realImageConsumer) {
            this.real_consumers.add(realImageConsumer);
        }

        public boolean isConsumer(RealImageConsumer realImageConsumer) {
            return this.real_consumers.contains(realImageConsumer);
        }

        public void removeConsumer(RealImageConsumer realImageConsumer) {
            this.real_consumers.remove(realImageConsumer);
        }

        public void startProduction(RealImageConsumer realImageConsumer) {
            this.addConsumer(realImageConsumer);
            Iterator iterator = this.real_consumers.iterator();
            while (iterator.hasNext()) {
                RealImageConsumer realImageConsumer2 = (RealImageConsumer)iterator.next();
                realImageConsumer2.setDimensions(FitsImageData.this.dimen[this.x_axis], FitsImageData.this.dimen[this.y_axis]);
                try {
                    realImageConsumer2.setMinMax(FitsImageData.this.min(), FitsImageData.this.max());
                }
                catch (FitsException fitsException) {
                    // empty catch block
                }
                int n = 0;
                n |= 0x10;
                n |= 8;
                n |= 2;
                realImageConsumer2.setHints(n |= 4);
                this.lines_sent = 0;
                this.sendAvailablePixels();
            }
        }

        public void requestTopDownLeftRightResend(RealImageConsumer realImageConsumer) {
        }

        public void sendAvailablePixels() {
            new PixelDeliverer().start();
        }

        public synchronized void actuallySendAvailablePixels() {
            Object object;
            if (this.real_consumers.size() == 0) {
                return;
            }
            int n = this.lines_sent * FitsImageData.this.dimen[this.x_axis];
            int n2 = this.npixels / FitsImageData.this.dimen[this.x_axis] - 1;
            int n3 = n2 - this.lines_sent + 1;
            if (n3 <= 0) {
                return;
            }
            Object object2 = this.real_consumers.iterator();
            while (object2.hasNext()) {
                object = (RealImageConsumer)object2.next();
                object.setPixels(0, this.lines_sent, FitsImageData.this.dimen[this.x_axis], n3, this.pixels, n, FitsImageData.this.dimen[this.x_axis]);
            }
            this.lines_sent = n2;
            if (this.npixels == this.pixels.length) {
                object2 = new HashSet(this.real_consumers);
                object = object2.iterator();
                while (object.hasNext()) {
                    RealImageConsumer realImageConsumer = (RealImageConsumer)object.next();
                    realImageConsumer.imageComplete(3);
                }
            }
        }

        private class PixelDeliverer
        extends Thread {
            private PixelDeliverer() {
            }

            public void run() {
                View.this.actuallySendAvailablePixels();
            }
        }
    }
}

