/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsColumn;
import eap.fits.FitsData;
import eap.fits.FitsException;
import eap.fits.FitsHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class FitsTableData
extends FitsData
implements TableModel {
    int ncolumns;
    int nrows;
    int bytes_per_row;
    List columns;
    Map offsets;
    private Set listeners;
    static /* synthetic */ Class class$java$lang$Object;

    public FitsTableData(FitsHeader fitsHeader) throws FitsException {
        super(fitsHeader.dataSize());
        this.bytes_per_row = fitsHeader.card("NAXIS1").intValue();
        this.nrows = fitsHeader.card("NAXIS2").intValue();
        this.ncolumns = fitsHeader.card("TFIELDS").intValue();
        this.columns = new ArrayList(this.ncolumns);
        this.offsets = new HashMap(this.ncolumns);
        this.listeners = new HashSet();
    }

    public FitsColumn getColumn(int n) {
        return (FitsColumn)this.columns.get(n);
    }

    private int getOffset(FitsColumn fitsColumn) {
        Integer n = (Integer)this.offsets.get(fitsColumn);
        return n;
    }

    private long elementLocation(int n, FitsColumn fitsColumn) {
        return n * this.bytes_per_row + this.getOffset(fitsColumn);
    }

    protected void goToElement(int n, FitsColumn fitsColumn) {
        this.goToByte(this.elementLocation(n, fitsColumn));
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    protected void fireTableModelEvent(TableModelEvent tableModelEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TableModelListener tableModelListener = (TableModelListener)iterator.next();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    protected void fireTableModelEvent(int n, int n2) {
        this.fireTableModelEvent(new TableModelEvent(this, n, n, n2));
    }

    public Class getColumnClass(int n) {
        FitsColumn fitsColumn = this.getColumn(n);
        if (fitsColumn.getCount() == 1) {
            return this.getColumn(n).scaledRepresentation();
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = FitsTableData.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getColumnCount() {
        return this.ncolumns;
    }

    public String getColumnName(int n) {
        FitsColumn fitsColumn = this.getColumn(n);
        String string = fitsColumn.getName();
        String string2 = fitsColumn.getUnits();
        if (string2 == null || string2.equals(" ")) {
            return string;
        }
        return string + " (" + string2 + ")";
    }

    public int findColumn(String string) {
        for (int i = 0; i < this.ncolumns; ++i) {
            if (!this.getColumn(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getRowCount() {
        return this.nrows;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

