/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsData;
import eap.fits.FitsException;
import eap.fits.FitsFile;
import eap.fits.FitsHDU;
import eap.fits.FitsHeader;
import eap.fits.NoSuchFitsHDUException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamFitsFile
extends FitsFile {
    InputStream file;

    public InputStreamFitsFile(InputStream inputStream) throws IOException {
        this.file = inputStream;
    }

    private boolean readBlock(byte[] byArray) throws IOException {
        int n = 0;
        for (int i = 0; i < byArray.length; i += n) {
            n = this.file.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            this.isComplete = true;
            if (i != 0) {
                throw new FitsException("Incomplete data block in " + this);
            }
            return false;
        }
        return true;
    }

    private FitsHDU readNextHDU() throws IOException {
        FitsHDU fitsHDU = new FitsHDU();
        FitsHeader fitsHeader = fitsHDU.getHeader();
        byte[] byArray = new byte[2880];
        while (this.readBlock(byArray) && !fitsHeader.add(byArray)) {
        }
        if (this.isComplete) {
            return null;
        }
        fitsHDU.initData();
        this.fillInData(fitsHDU);
        return fitsHDU;
    }

    private synchronized void fillInData(FitsHDU fitsHDU) throws IOException {
        FitsData fitsData = fitsHDU.getData();
        if (fitsData.isComplete()) {
            return;
        }
        byte[] byArray = fitsData.data();
        this.readBlock(byArray);
        fitsData.setValidBytes(byArray.length);
        int n = byArray.length;
        int n2 = (n + 2880 - 1) / 2880;
        byte[] byArray2 = new byte[n2 * 2880 - n];
        this.readBlock(byArray2);
    }

    public FitsHDU getHDU(int n) throws IOException {
        return this.getHDU(n, 0);
    }

    public FitsHDU getHDU(int n, int n2) throws IOException {
        for (int i = this.hdus.size(); i <= n && !this.isComplete(); ++i) {
            FitsHDU fitsHDU = this.readNextHDU();
            if (fitsHDU == null) continue;
            this.add(fitsHDU);
        }
        if (this.hdus.size() > n) {
            FitsHDU fitsHDU = (FitsHDU)this.hdus.get(n);
            return fitsHDU;
        }
        throw new NoSuchFitsHDUException("Can't get HDU " + n + " in " + this);
    }

    public FitsHDU getHDU(String string) throws IOException {
        return this.getHDU(string, 0);
    }

    public FitsHDU getHDU(String string, int n) throws IOException {
        int n2 = this.hdus.size();
        while (!this.index.containsKey(string) && !this.isComplete()) {
            FitsHDU fitsHDU = this.readNextHDU();
            if (fitsHDU != null) {
                this.add(fitsHDU);
            }
            ++n2;
        }
        if (this.index.containsKey(string)) {
            FitsHDU fitsHDU = (FitsHDU)this.index.get(string);
            return fitsHDU;
        }
        throw new NoSuchFitsHDUException("Can't get HDU" + string + " in " + this);
    }
}

