/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Angle {
    public static final String DEGREE = "deg";
    public static final String RADIANT = "rad";
    public static final String ARCMINUTE = "arcmin";
    public static final String ARCSECOND = "arcsec";
    public static final String XML_ATTRIBUTE_UNIT = "unit";
    private double value = Double.NaN;
    private String unit = "deg";

    public Angle(Node angleNode) throws SchemaException {
        double value;
        if (angleNode == null) {
            throw new SchemaException("Angle node cannot be NULL ");
        }
        Element angle = (Element)angleNode;
        String unit = angle.getAttribute(XML_ATTRIBUTE_UNIT).trim();
        if (unit != null) {
            if (!(unit.equals(RADIANT) || unit.equals(DEGREE) || unit.equals(ARCSECOND) || unit.equals(ARCMINUTE))) {
                throw new SchemaException("Angle unit is unknown. ");
            }
        } else {
            throw new SchemaException("Problem while retrieving Angle unit. ");
        }
        this.value = value = Double.parseDouble(angle.getFirstChild().getNodeValue());
        this.unit = unit;
    }

    public Angle(double value, String unit) throws IllegalArgumentException {
        if (DEGREE.equals(unit) || RADIANT.equals(unit) || ARCMINUTE.equals(unit) || ARCSECOND.equals(unit)) {
            this.unit = unit;
        }
        this.value = unit.equals(DEGREE) ? value % 360.0 : value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.value);
        buffer.append(" ");
        buffer.append(this.unit.toUpperCase());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Angle)) {
            return false;
        }
        Angle original = (Angle)obj;
        Angle angle = new Angle(original.getValue(), original.getUnit());
        double degree = angle.toDegree();
        return degree == this.value;
    }

    public Element setToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        element.setAttribute(XML_ATTRIBUTE_UNIT, this.unit);
        Text n_ValueText = element.getOwnerDocument().createTextNode(Double.toString(this.value));
        element.appendChild(n_ValueText);
        return element;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getValue() {
        return this.value;
    }

    public double toDegree() {
        if (ARCSECOND.equals(this.unit)) {
            this.value = this.value / 60.0 / 60.0;
            this.unit = DEGREE;
            return this.value;
        }
        if (ARCMINUTE.equals(this.unit)) {
            this.value /= 60.0;
            this.unit = DEGREE;
            return this.value;
        }
        if (RADIANT.equals(this.unit)) {
            this.value = this.value * 180.0 / Math.PI;
            this.unit = DEGREE;
            return this.value;
        }
        return this.value;
    }

    public double toArcMin() {
        if (ARCSECOND.equals(this.unit)) {
            this.value /= 60.0;
            this.unit = ARCMINUTE;
            return this.value;
        }
        if (DEGREE.equals(this.unit)) {
            this.value *= 60.0;
            this.unit = ARCMINUTE;
            return this.value;
        }
        if (RADIANT.equals(this.unit)) {
            this.value = this.toDegree() * 60.0;
            this.unit = ARCMINUTE;
            return this.value;
        }
        return this.value;
    }

    public double toArcSec() {
        if (DEGREE.equals(this.unit)) {
            this.value = this.value * 60.0 * 60.0;
            this.unit = ARCSECOND;
            return this.value;
        }
        if (ARCMINUTE.equals(this.unit)) {
            this.value *= 60.0;
            this.unit = ARCSECOND;
            return this.value;
        }
        if (RADIANT.equals(this.unit)) {
            this.value = this.toDegree() * 60.0 * 60.0;
            this.unit = ARCSECOND;
            return this.value;
        }
        return this.value;
    }

    public double toRadiant() {
        if (ARCSECOND.equals(this.unit)) {
            this.value = this.value / 180.0 * Math.PI;
            this.unit = DEGREE;
            this.value = this.toArcSec();
            this.unit = RADIANT;
            return this.value;
        }
        if (ARCMINUTE.equals(this.unit)) {
            this.value = this.value / 180.0 * Math.PI;
            this.unit = DEGREE;
            this.value = this.toArcMin();
            this.unit = RADIANT;
            return this.value;
        }
        if (DEGREE.equals(this.unit)) {
            this.value = this.value / 180.0 * Math.PI;
            this.unit = RADIANT;
            return this.value;
        }
        return this.value;
    }

    public static boolean isValidUnit(String unit) {
        return ARCMINUTE.equals(unit) || ARCSECOND.equals(unit) || DEGREE.equals(unit) || RADIANT.equals(unit);
    }
}

