/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.Angle;
import de.lehmannet.om.EquPositionReferenceFrame;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.DateConverter;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EquPosition
extends SchemaElement {
    public static final String XML_ELEMENT_POSITION = "position";
    public static final String XML_ELEMENT_RA = "ra";
    public static final String XML_ELEMENT_DEC = "dec";
    public static final String RA_HOUR = "h";
    public static final String RA_MIN = "m";
    public static final String RA_SEC = "s";
    public static final String DEC_DEG = "\u00b0";
    public static final String DEC_MIN = "'";
    public static final String DEC_SEC = "\"";
    private Angle ra = null;
    private Angle dec = null;
    private EquPositionReferenceFrame frame = null;

    public EquPosition(Node positionNode) throws SchemaException {
        Element position = (Element)positionNode;
        Angle ra = null;
        Angle dec = null;
        NodeList positionValues = null;
        positionValues = position.getElementsByTagName(XML_ELEMENT_RA);
        if (positionValues != null) {
            if (positionValues.getLength() == 1) {
                Node raElement = positionValues.item(0);
                ra = new Angle(raElement);
            } else if (positionValues.getLength() > 1) {
                throw new SchemaException("Position can have only one <ra> element. ");
            }
        }
        if ((positionValues = position.getElementsByTagName(XML_ELEMENT_DEC)) != null) {
            if (positionValues.getLength() == 1) {
                Node decElement = positionValues.item(0);
                dec = new Angle(decElement);
            } else if (positionValues.getLength() > 1) {
                throw new SchemaException("Position can have only one <dec> element. ");
            }
        }
        this.setDecAngle(dec);
        this.setRaAngle(ra);
    }

    public EquPosition(Angle ra, Angle dec) throws IllegalArgumentException {
        if (ra == null || dec == null) {
            throw new IllegalArgumentException("ra or dec value cannot be null. ");
        }
        if (ra.getValue() < 0.0) {
            throw new IllegalArgumentException("ra value cannot be negative. ");
        }
        this.ra = ra;
        this.dec = dec;
    }

    public EquPosition(String ra, String dec) throws IllegalArgumentException {
        if (ra == null || dec == null) {
            throw new IllegalArgumentException("ra or dec value cannot be null. ");
        }
        this.setRa(ra);
        this.setDec(dec);
    }

    public String getDisplayName() {
        return this.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" Right ascension: ");
        buffer.append(this.getRa());
        buffer.append(" Declination: ");
        buffer.append(this.getDec());
        if (this.frame != null) {
            buffer.append(this.frame);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EquPosition)) {
            return false;
        }
        EquPosition equPosition = (EquPosition)obj;
        if (!this.frame.equals(equPosition.getFrame())) {
            return false;
        }
        return this.ra.equals(equPosition.getRaAngle()) && this.dec.equals(equPosition.getDecAngle());
    }

    public static String getRaString(int hours, int min, int sec) {
        return DateConverter.setLeadingZero((int)hours) + RA_HOUR + DateConverter.setLeadingZero((int)min) + RA_MIN + DateConverter.setLeadingZero((int)sec) + RA_SEC;
    }

    public static String getRaString(int hours, int min, double sec) {
        return DateConverter.setLeadingZero((int)hours) + RA_HOUR + DateConverter.setLeadingZero((int)min) + RA_MIN + DateConverter.setLeadingZero((double)sec) + RA_SEC;
    }

    public static String getDecString(int deg, int min, int sec) {
        if (deg == 0 && (min < 0 || min == 0 && sec < 0)) {
            return "-" + DateConverter.setLeadingZero((int)deg) + DEC_DEG + DateConverter.setLeadingZero((int)Math.abs(min)) + DEC_MIN + DateConverter.setLeadingZero((int)Math.abs(sec)) + DEC_SEC;
        }
        return DateConverter.setLeadingZero((int)deg) + DEC_DEG + DateConverter.setLeadingZero((int)Math.abs(min)) + DEC_MIN + DateConverter.setLeadingZero((int)Math.abs(sec)) + DEC_SEC;
    }

    public static String getDecString(int deg, int min, double sec) {
        if (deg == 0 && (min < 0 || min == 0 && sec < 0.0)) {
            return "-" + DateConverter.setLeadingZero((int)deg) + DEC_DEG + DateConverter.setLeadingZero((int)Math.abs(min)) + DEC_MIN + DateConverter.setLeadingZero((double)Math.abs(sec)) + DEC_SEC;
        }
        return DateConverter.setLeadingZero((int)deg) + DEC_DEG + DateConverter.setLeadingZero((int)Math.abs(min)) + DEC_MIN + DateConverter.setLeadingZero((double)Math.abs(sec)) + DEC_SEC;
    }

    public Element addToXmlElement(Element parent) {
        if (parent == null) {
            return null;
        }
        Document ownerDoc = parent.getOwnerDocument();
        Element e_Position = ownerDoc.createElement(XML_ELEMENT_POSITION);
        if (this.frame != null) {
            e_Position = this.frame.addToXmlElement(e_Position);
        }
        Element e_Ra = ownerDoc.createElement(XML_ELEMENT_RA);
        e_Ra = this.ra.setToXmlElement(e_Ra);
        e_Position.appendChild(e_Ra);
        Element e_Dec = ownerDoc.createElement(XML_ELEMENT_DEC);
        e_Dec = this.dec.setToXmlElement(e_Dec);
        e_Position.appendChild(e_Dec);
        parent.appendChild(e_Position);
        return parent;
    }

    public Angle getDecAngle() {
        return this.dec;
    }

    public String getDec() {
        double degree = this.dec.toDegree();
        int deg = 0;
        deg = degree > 0.0 ? (int)Math.floor(degree) : (int)Math.ceil(degree);
        double rest = degree - (double)deg;
        double md = rest * 60.0;
        int min = 0;
        min = md > 0.0 ? (int)Math.floor(md) : (int)Math.ceil(md);
        double sd = (rest -= (double)min / 60.0) * 3600.0;
        int sec = (int)Math.round(sd);
        if (sec == 60) {
            if (++min >= 60) {
                ++deg;
                min = 0;
            }
            sec = 0;
        } else if (sec == -60) {
            if (--min >= 60) {
                --deg;
                min = 0;
            }
            sec = 0;
        }
        return EquPosition.getDecString(deg, min, sec);
    }

    public Angle getRaAngle() {
        return this.ra;
    }

    public String getRa() {
        double deg = this.ra.toDegree();
        int hours = (int)Math.floor(deg / 15.0);
        double rest = deg - (double)(hours * 15);
        double md = rest * 60.0 / 15.0;
        int min = (int)Math.floor(md);
        double sd = (rest -= (double)min / 60.0 * 15.0) * 3600.0 / 15.0;
        int sec = (int)Math.round(sd);
        return EquPosition.getRaString(hours, min, sec);
    }

    public double getRaDecimalHours() {
        String s = this.getRa();
        double ra = Integer.parseInt(s.substring(0, s.indexOf(RA_HOUR)));
        ra += (double)Integer.parseInt(s.substring(s.indexOf(RA_HOUR) + 1, s.indexOf(RA_MIN))) / 60.0;
        return ra += (double)Integer.parseInt(s.substring(s.indexOf(RA_MIN) + 1, s.indexOf(RA_SEC))) / 3600.0;
    }

    public void setDec(String dec) throws IllegalArgumentException {
        dec = dec.replace('+', ' ');
        dec = dec.replaceAll(" ", "");
        try {
            int deg = Integer.parseInt(dec.substring(0, dec.indexOf(DEC_DEG)));
            int min = Integer.parseInt(dec.substring(dec.indexOf(DEC_DEG) + 1, dec.indexOf(DEC_MIN)));
            double sec = Double.parseDouble(dec.substring(dec.indexOf(DEC_MIN) + 1, dec.indexOf(DEC_SEC)));
            double d = 0.0;
            d = dec.startsWith("-") ? (double)deg - (double)min / 60.0 - sec / 3600.0 : (double)deg + (double)min / 60.0 + sec / 3600.0;
            this.dec = new Angle(d, "deg");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("DEC string malformed. " + dec);
        }
        catch (StringIndexOutOfBoundsException siobe) {
            throw new IllegalArgumentException("DEC string malformed. " + dec);
        }
    }

    public void setRa(String ra) throws IllegalArgumentException {
        ra = ra.replaceAll(" ", "");
        try {
            int hour = Integer.parseInt(ra.substring(0, ra.indexOf(RA_HOUR)));
            int min = Integer.parseInt(ra.substring(ra.indexOf(RA_HOUR) + 1, ra.indexOf(RA_MIN)));
            double sec = Double.parseDouble(ra.substring(ra.indexOf(RA_MIN) + 1, ra.indexOf(RA_SEC)));
            double r = (double)(hour * 15) + (double)min / 60.0 * 15.0 + sec / 3600.0 * 15.0;
            this.ra = new Angle(r, "deg");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("RA string malformed. " + ra);
        }
        catch (StringIndexOutOfBoundsException siobe) {
            throw new IllegalArgumentException("RA string malformed. " + siobe);
        }
    }

    public void setDecAngle(Angle dec) throws IllegalArgumentException {
        if (dec == null) {
            throw new IllegalArgumentException("dec value cannot be null. ");
        }
        this.dec = dec;
    }

    public void setRaAngle(Angle ra) throws IllegalArgumentException {
        if (ra == null) {
            throw new IllegalArgumentException("ra value cannot be null. ");
        }
        if (ra.getValue() < 0.0) {
            throw new IllegalArgumentException("ra value cannot be negative. ");
        }
        this.ra = ra;
    }

    public EquPositionReferenceFrame getFrame() {
        return this.frame;
    }

    public void setFrame(EquPositionReferenceFrame frame) {
        this.frame = frame == null ? new EquPositionReferenceFrame("geocentric", "J2000.0") : frame;
    }
}

