/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.ILens;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Lens
extends SchemaElement
implements ILens {
    private String model = new String();
    private String vendor = null;
    private float factor = 1.0f;
    private boolean available = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lens(Node lens) throws SchemaException, IllegalArgumentException {
        if (lens == null) {
            throw new IllegalArgumentException("Parameter lens node cannot be NULL. ");
        }
        Element lensElement = (Element)lens;
        NodeList children = null;
        Element child = null;
        String ID = lensElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("Lens must have a ID. ");
        }
        super.setID(ID);
        children = lensElement.getElementsByTagName("model");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Lens must have exact one model name. ");
        }
        child = (Element)children.item(0);
        String model = "";
        if (child == null) {
            throw new SchemaException("Lens must have a model name. ");
        }
        if (child.getFirstChild() == null) throw new SchemaException("Lens cannot have an empty model name. ");
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te = 0; te < textElements.getLength(); ++te) {
                model = model + textElements.item(te).getNodeValue();
            }
            this.setModel(model);
        }
        child = null;
        children = lensElement.getElementsByTagName("factor");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Lens must have exact one focal length factor. ");
        }
        child = (Element)children.item(0);
        String factor = null;
        if (child == null) {
            throw new SchemaException("Lens must have a focal length factor. ");
        }
        factor = child.getFirstChild().getNodeValue();
        this.setFactor(FloatUtil.parseFloat((String)factor));
        NodeList list = lensElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = list.item(i);
            if (c.getNodeType() != 8 || !"Element no longer available".equals(c.getNodeValue())) continue;
            this.available = false;
            break;
        }
        child = null;
        children = lensElement.getElementsByTagName("vendor");
        String vendor = "";
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem while retrieving vendor from lens. ");
            NodeList textElements2 = child.getChildNodes();
            if (textElements2 == null || textElements2.getLength() <= 0) return;
            for (int te = 0; te < textElements2.getLength(); ++te) {
                vendor = vendor + textElements2.item(te).getNodeValue();
            }
            this.setVendor(vendor);
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Lens can have only one vendor. ");
        }
    }

    public Lens(String model, float factor) throws IllegalArgumentException {
        this.setModel(model);
        this.setFactor(factor);
    }

    public String getDisplayName() {
        String dn = this.getModel() + " " + this.getFactor();
        if (this.vendor != null && !"".equals(this.vendor.trim())) {
            dn = this.getVendor() + " " + dn;
        }
        return dn;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Lens Model: ");
        buffer.append(this.getModel());
        if (this.vendor != null) {
            buffer.append("\n");
            buffer.append("Vendor: ");
            buffer.append(this.getVendor());
        }
        buffer.append("\n");
        buffer.append("Focal length factor: ");
        buffer.append(this.getFactor());
        return buffer.toString();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailability(boolean available) {
        this.available = available;
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("lens");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Lens = ownerDoc.createElement("lens");
        e_Lens.setAttribute("id", super.getID());
        element.appendChild(e_Lens);
        if (!this.isAvailable()) {
            Comment comment = ownerDoc.createComment("Element no longer available");
            e_Lens.appendChild(comment);
        }
        Element e_Model = ownerDoc.createElement("model");
        CDATASection n_ModelText = ownerDoc.createCDATASection(this.model);
        e_Model.appendChild(n_ModelText);
        e_Lens.appendChild(e_Model);
        if (this.vendor != null) {
            Element e_Vendor = ownerDoc.createElement("vendor");
            CDATASection n_VendorText = ownerDoc.createCDATASection(this.vendor);
            e_Vendor.appendChild(n_VendorText);
            e_Lens.appendChild(e_Vendor);
        }
        Element e_factor = ownerDoc.createElement("factor");
        Text n_FocalLengthText = ownerDoc.createTextNode(Float.toString(this.factor));
        e_factor.appendChild(n_FocalLengthText);
        e_Lens.appendChild(e_factor);
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("lens");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Lenses = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("lenses");
            if (nodeList.getLength() == 0) {
                e_Lenses = ownerDoc.createElement("lenses");
                ownerDoc.getDocumentElement().appendChild(e_Lenses);
            } else {
                e_Lenses = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Lenses);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public float getFactor() {
        return this.factor;
    }

    public String getModel() {
        return this.model;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setFactor(float factor) throws IllegalArgumentException {
        if (Float.isNaN(factor)) {
            throw new IllegalArgumentException("Focal length factor cannot be Float.NaN. ");
        }
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Focal length factor must be > 0 ");
        }
        this.factor = factor;
    }

    public void setModel(String modelname) throws IllegalArgumentException {
        if (modelname == null) {
            throw new IllegalArgumentException("Lens modelname cannot be null. ");
        }
        this.model = modelname;
    }

    public void setVendor(String vendorname) {
        if (vendorname != null && "".equals(vendorname.trim())) {
            this.vendor = null;
            return;
        }
        this.vendor = vendorname;
    }
}

