/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.Angle;
import de.lehmannet.om.IScope;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Scope
extends SchemaElement
implements IScope {
    private static final String XML_XSI_TYPE_VALUE = "oal:scopeType";
    private static final String XML_XSI_FIXEDTYPE_VALUE = "oal:fixedMagnificationOpticsType";
    private String model = new String();
    private String type = null;
    private String vendor = null;
    private float aperture = Float.NaN;
    private float focalLength = Float.NaN;
    private float magnification = Float.NaN;
    private float lightGrasp = Float.NaN;
    private int orientation_Erect = -1;
    private int orientation_Truesided = -1;
    private Angle trueFieldOfView = null;
    private boolean available = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Scope(Node scope) throws SchemaException, IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope node cannot be NULL. ");
        }
        Element scopeElement = (Element)scope;
        Element child = null;
        NodeList children = null;
        String ID = scopeElement.getAttribute("id");
        if (ID != null && "".equals(ID.trim())) {
            throw new SchemaException("DeepSkyTarget must have a ID. ");
        }
        super.setID(ID);
        NodeList list = scopeElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node c = list.item(i);
            if (c.getNodeType() != 8 || !"Element no longer available".equals(c.getNodeValue())) continue;
            this.available = false;
            break;
        }
        child = null;
        children = scopeElement.getElementsByTagName("focalLength");
        String focalLength = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving focalLength from scope. ");
                focalLength = child.getFirstChild().getNodeValue();
                this.setFocalLength(FloatUtil.parseFloat((String)focalLength));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Scope can have only one focal length. ");
            }
        }
        child = null;
        children = scopeElement.getElementsByTagName("magnification");
        String magnification = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving magnification from scope. ");
                if (focalLength != null) {
                    throw new SchemaException("Scope can only have a focalLength entry OR a magnification entry! ");
                }
                magnification = child.getFirstChild().getNodeValue();
                this.setMagnification(FloatUtil.parseFloat((String)magnification));
                children = scopeElement.getElementsByTagName("trueField");
                if (children != null) {
                    if (children.getLength() == 1) {
                        child = (Element)children.item(0);
                        if (child == null) throw new SchemaException("Problem while retrieving true field of view from scope. ");
                        Angle trueField = new Angle(child);
                        Angle checkAngle = new Angle(trueField.getValue(), trueField.getUnit());
                        if (checkAngle.toArcSec() < 0.0) {
                            throw new SchemaException("Problem while retrieving true field of view from scope. Value cannot be nagative. ");
                        }
                        this.setTrueFieldOfView(trueField);
                    } else if (children.getLength() > 1) {
                        throw new SchemaException("Scope can have only one true field of view. ");
                    }
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Scope can have only one magnification. ");
            }
        }
        if ((children = scopeElement.getElementsByTagName("model")) == null || children.getLength() != 1) {
            throw new SchemaException("Scope must have exact one model name. ");
        }
        child = (Element)children.item(0);
        String model = "";
        if (child == null) {
            throw new SchemaException("Scope must have a model name. ");
        }
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te = 0; te < textElements.getLength(); ++te) {
                model = model + textElements.item(te).getNodeValue();
            }
            this.setModel(model);
        }
        child = null;
        children = scopeElement.getElementsByTagName("aperture");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Scope must have exact one aperture. ");
        }
        child = (Element)children.item(0);
        String aperture = null;
        if (child == null) {
            throw new SchemaException("Scope must have a aperture. ");
        }
        aperture = child.getFirstChild().getNodeValue();
        this.setAperture(FloatUtil.parseFloat((String)aperture));
        child = null;
        children = scopeElement.getElementsByTagName("type");
        String type = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving type from scope. ");
                NodeList textElements2 = child.getChildNodes();
                if (textElements2 != null && textElements2.getLength() > 0) {
                    for (int te = 0; te < textElements2.getLength(); ++te) {
                        type = type + textElements2.item(te).getNodeValue();
                    }
                    this.setType(type);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Scope can have only one type. ");
            }
        }
        child = null;
        children = scopeElement.getElementsByTagName("vendor");
        String vendor = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving vendor from scope. ");
                NodeList textElements3 = child.getChildNodes();
                if (textElements3 != null && textElements3.getLength() > 0) {
                    for (int te = 0; te < textElements3.getLength(); ++te) {
                        vendor = vendor + textElements3.item(te).getNodeValue();
                    }
                    this.setVendor(vendor);
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Scope can have only one vendor. ");
            }
        }
        child = null;
        children = scopeElement.getElementsByTagName("lightGrasp");
        String lightGrasp = null;
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child == null) throw new SchemaException("Problem while retrieving light grasp from scope. ");
                lightGrasp = child.getFirstChild().getNodeValue();
                this.setLightGrasp(FloatUtil.parseFloat((String)lightGrasp));
            } else if (children.getLength() > 1) {
                throw new SchemaException("Scope can have only one light grasp. ");
            }
        }
        child = null;
        children = scopeElement.getElementsByTagName("orientation");
        String ori_Erect = null;
        String ori_Truesided = null;
        if (children == null) return;
        if (children.getLength() == 1) {
            child = (Element)children.item(0);
            if (child == null) throw new SchemaException("Problem while retrieving orientation element from scope. ");
            ori_Erect = child.getAttribute("erect").trim().toLowerCase();
            ori_Truesided = child.getAttribute("truesided").trim().toLowerCase();
            this.setOrientation(new Boolean(ori_Erect), new Boolean(ori_Truesided));
            return;
        } else {
            if (children.getLength() <= 1) return;
            throw new SchemaException("Scope can have only one orientation. ");
        }
    }

    public Scope(String model, float aperture, float focalLength) throws IllegalArgumentException {
        this.setModel(model);
        this.setAperture(aperture);
        this.setFocalLength(focalLength);
    }

    public Scope(float aperture, float magnification, String model) throws IllegalArgumentException {
        this.setModel(model);
        this.setAperture(aperture);
        this.setMagnification(magnification);
    }

    public String getDisplayName() {
        String dn = this.getModel();
        if (this.vendor != null && !"".equals(this.vendor.trim())) {
            dn = this.getVendor() + " " + dn;
        }
        if (!Float.isNaN(this.aperture)) {
            DecimalFormat df = new DecimalFormat("0");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
            dn = dn + " " + df.format(this.aperture) + "mm";
        }
        return dn;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Scope: Model name=");
        buffer.append(this.model);
        buffer.append(" Aperture=");
        buffer.append(this.aperture);
        if (!Float.isNaN(this.focalLength)) {
            buffer.append(" focal length=");
            buffer.append(this.focalLength);
        }
        if (!Float.isNaN(this.magnification)) {
            buffer.append(" magnification=");
            buffer.append(this.magnification);
            if (this.trueFieldOfView != null) {
                buffer.append(" TrueFieldOfView=");
                buffer.append(this.trueFieldOfView);
            }
        }
        if (this.type != null) {
            buffer.append(" type=");
            buffer.append(this.type);
        }
        if (this.vendor != null) {
            buffer.append(" vendor=");
            buffer.append(this.vendor);
        }
        if (!Float.isNaN(this.lightGrasp)) {
            buffer.append(" light grasp=");
            buffer.append(this.lightGrasp);
        }
        if (this.orientation_Erect != -1 && this.orientation_Truesided != -1) {
            buffer.append(" Orientation=");
            switch (this.orientation_Erect) {
                case 1: {
                    buffer.append(" (Erected");
                    break;
                }
                case 0: {
                    buffer.append(" (Not Erected");
                }
            }
            switch (this.orientation_Truesided) {
                case 1: {
                    buffer.append(" Truesided)");
                    break;
                }
                case 0: {
                    buffer.append(" Not Truesided)");
                }
            }
        }
        return buffer.toString();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailability(boolean available) {
        this.available = available;
    }

    public Element addToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("scope");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Scope = ownerDoc.createElement("scope");
        e_Scope.setAttribute("id", super.getID());
        element.appendChild(e_Scope);
        if (!this.isAvailable()) {
            Comment comment = ownerDoc.createComment("Element no longer available");
            e_Scope.appendChild(comment);
        }
        Element e_Model = ownerDoc.createElement("model");
        CDATASection n_ModelText = ownerDoc.createCDATASection(this.model);
        e_Model.appendChild(n_ModelText);
        e_Scope.appendChild(e_Model);
        if (this.type != null) {
            Element e_Type = ownerDoc.createElement("type");
            CDATASection n_TypeText = ownerDoc.createCDATASection(this.type);
            e_Type.appendChild(n_TypeText);
            e_Scope.appendChild(e_Type);
        }
        if (this.vendor != null) {
            Element e_Vendor = ownerDoc.createElement("vendor");
            CDATASection n_VendorText = ownerDoc.createCDATASection(this.vendor);
            e_Vendor.appendChild(n_VendorText);
            e_Scope.appendChild(e_Vendor);
        }
        Element e_Aperture = ownerDoc.createElement("aperture");
        Text n_ApertureText = ownerDoc.createTextNode(Float.toString(this.aperture));
        e_Aperture.appendChild(n_ApertureText);
        e_Scope.appendChild(e_Aperture);
        if (!Float.isNaN(this.lightGrasp)) {
            Element e_LightGrasp = ownerDoc.createElement("lightGrasp");
            Text n_LightGraspText = ownerDoc.createTextNode(Float.toString(this.lightGrasp));
            e_LightGrasp.appendChild(n_LightGraspText);
            e_Scope.appendChild(e_LightGrasp);
        }
        if (this.orientation_Erect != -1 && this.orientation_Truesided != -1) {
            Element e_Orientation = ownerDoc.createElement("orientation");
            String erect = this.orientation_Erect == 1 ? "true" : "false";
            String truesided = this.orientation_Truesided == 1 ? "true" : "false";
            e_Orientation.setAttribute("erect", erect);
            e_Orientation.setAttribute("truesided", truesided);
            e_Scope.appendChild(e_Orientation);
        }
        if (!Float.isNaN(this.focalLength)) {
            Element e_FocalLength = ownerDoc.createElement("focalLength");
            Text n_FocalLengthText = ownerDoc.createTextNode(Float.toString(this.focalLength));
            e_FocalLength.appendChild(n_FocalLengthText);
            e_Scope.appendChild(e_FocalLength);
            e_Scope.setAttribute("xsi:type", XML_XSI_TYPE_VALUE);
        }
        if (!Float.isNaN(this.magnification)) {
            Element e_Magnification = ownerDoc.createElement("magnification");
            Text n_MagnificationText = ownerDoc.createTextNode(Float.toString(this.magnification));
            e_Magnification.appendChild(n_MagnificationText);
            e_Scope.appendChild(e_Magnification);
            if (this.trueFieldOfView != null) {
                Element e_TrueFieldOfView = ownerDoc.createElement("trueField");
                e_TrueFieldOfView = this.trueFieldOfView.setToXmlElement(e_TrueFieldOfView);
                e_Scope.appendChild(e_TrueFieldOfView);
            }
            e_Scope.setAttribute("xsi:type", XML_XSI_FIXEDTYPE_VALUE);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement("scope");
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Scopes = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("scopes");
            if (nodeList.getLength() == 0) {
                e_Scopes = ownerDoc.createElement("scopes");
                ownerDoc.getDocumentElement().appendChild(e_Scopes);
            } else {
                e_Scopes = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Scopes);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element) {
        return this.addAsLinkToXmlElement(element, false);
    }

    public float getAperture() {
        return this.aperture;
    }

    public float getFocalLength() {
        return this.focalLength;
    }

    public float getLightGrasp() {
        return this.lightGrasp;
    }

    public Angle getTrueFieldOfView() {
        return this.trueFieldOfView;
    }

    public boolean isOrientationErected() throws IllegalStateException {
        if (this.orientation_Erect == -1) {
            throw new IllegalStateException("Orientation was never set. ");
        }
        return this.orientation_Erect == 1;
    }

    public boolean isOrientationTruesided() throws IllegalStateException {
        if (this.orientation_Truesided == -1) {
            throw new IllegalStateException("Orientation was never set. ");
        }
        return this.orientation_Truesided == 1;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public String getModel() {
        return this.model;
    }

    public String getType() {
        if (this.type != null) {
            if ("A".equals(this.type)) {
                return "Naked eye";
            }
            if ("B".equals(this.type)) {
                return "Binoculars";
            }
            if ("N".equals(this.type)) {
                return "Newton";
            }
            if ("R".equals(this.type)) {
                return "Refractor";
            }
            if ("C".equals(this.type)) {
                return "Cassegrain";
            }
            if ("S".equals(this.type)) {
                return "Schmidt-Cassegrain";
            }
            if ("K".equals(this.type)) {
                return "Kutter";
            }
            if ("M".equals(this.type)) {
                return "Maksutov";
            }
        }
        return this.type;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setAperture(float aperture) throws IllegalArgumentException {
        if (Float.isNaN(aperture)) {
            throw new IllegalArgumentException("Aperture cannot be Float.NaN. ");
        }
        if ((double)aperture <= 0.0) {
            throw new IllegalArgumentException("Aperture cannot be <= 0.0 ");
        }
        this.aperture = aperture;
    }

    public void setFocalLength(float focalLength) throws IllegalArgumentException {
        if (Float.isNaN(focalLength) && Float.isNaN(this.magnification)) {
            throw new IllegalArgumentException("Focal length cannot be Float.NaN while magnification is also Float.NaN. ");
        }
        if ((double)focalLength <= 0.0) {
            throw new IllegalArgumentException("Focal length cannot be <= 0.0 ");
        }
        this.magnification = Float.NaN;
        this.trueFieldOfView = null;
        this.focalLength = focalLength;
    }

    public boolean setLightGrasp(float lightGrasp) {
        if ((double)lightGrasp < 0.0 || (double)lightGrasp > 1.0) {
            return false;
        }
        this.lightGrasp = lightGrasp;
        return true;
    }

    public void setMagnification(float magnification) throws IllegalArgumentException {
        if (Float.isNaN(magnification) && Float.isNaN(this.focalLength)) {
            throw new IllegalArgumentException("Magnification cannot be Float.NaN while focal length is also Float.NaN. ");
        }
        this.focalLength = Float.NaN;
        this.magnification = magnification;
    }

    public void setTrueFieldOfView(Angle tfov) throws IllegalArgumentException {
        if (!Float.isNaN(this.focalLength)) {
            throw new IllegalArgumentException("Focal length is set. True field of view can only be set, if magnification is set. ");
        }
        this.trueFieldOfView = tfov;
    }

    public void setModel(String model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("Model name cannot be null. ");
        }
        this.model = model;
    }

    public void setType(String type) {
        if (type != null && "".equals(type.trim())) {
            this.type = null;
            return;
        }
        this.type = type;
    }

    public void setVendor(String vendor) {
        if (vendor != null && "".equals(vendor.trim())) {
            this.vendor = null;
            return;
        }
        this.vendor = vendor;
    }

    public void setOrientation(boolean errected, boolean truesided) {
        this.orientation_Erect = errected ? 1 : 0;
        this.orientation_Truesided = truesided ? 1 : 0;
    }
}

