/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SurfaceBrightness {
    public static final String MAGS_SQR_ARC_SEC = "mags-per-squarearcsec";
    public static final String MAGS_SQR_ARC_MIN = "mags-per-squarearcmin";
    public static final String XML_ATTRIBUTE_UNIT = "unit";
    private float value = Float.NaN;
    private String unit = "mags-per-squarearcsec";

    public SurfaceBrightness(Node sfNode) throws SchemaException {
        if (sfNode == null) {
            throw new SchemaException("Surface Brightness node cannot be NULL ");
        }
        Element sf = (Element)sfNode;
        String unit = sf.getAttribute(XML_ATTRIBUTE_UNIT).trim();
        if (unit != null) {
            if (!unit.equals(MAGS_SQR_ARC_MIN) && !unit.equals(MAGS_SQR_ARC_SEC)) {
                throw new SchemaException("Surface Brightness unit is unknown. ");
            }
        } else {
            throw new SchemaException("Problem while retrieving Surface Brightness unit. ");
        }
        this.value = FloatUtil.parseFloat((String)sf.getFirstChild().getNodeValue());
        this.unit = unit;
    }

    public SurfaceBrightness(float value, String unit) throws IllegalArgumentException {
        if (Float.isNaN(value) || unit == null) {
            throw new IllegalArgumentException("Unable to create new SurfaceBrightness instance with given parameters.\n\tValue" + value + "\n\tUnit:" + unit);
        }
        if (!MAGS_SQR_ARC_MIN.equals(unit.trim()) && !MAGS_SQR_ARC_SEC.equals(unit.trim())) {
            throw new IllegalArgumentException("Unable to create new SurfaceBrightness instance with given unit: " + unit);
        }
        this.unit = unit.trim();
        this.value = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.value);
        buffer.append(" ");
        buffer.append(this.unit);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SurfaceBrightness)) {
            return false;
        }
        SurfaceBrightness foreign = (SurfaceBrightness)obj;
        float foreignMagsPerSqrArcSec = foreign.getValueAs(MAGS_SQR_ARC_SEC);
        float thisMagsPerSqrArcSec = this.value;
        if (!MAGS_SQR_ARC_SEC.equals(this.unit)) {
            thisMagsPerSqrArcSec = this.getValueAs(MAGS_SQR_ARC_SEC);
        }
        return thisMagsPerSqrArcSec == foreignMagsPerSqrArcSec;
    }

    public Element setToXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        element.setAttribute(XML_ATTRIBUTE_UNIT, this.unit);
        Text n_ValueText = element.getOwnerDocument().createTextNode(Float.toString(this.value));
        element.appendChild(n_ValueText);
        return element;
    }

    public String getUnit() {
        return this.unit;
    }

    public float getValue() {
        return this.value;
    }

    public float getValueAs(String unit) {
        if (unit == null) {
            return Float.NaN;
        }
        if (unit == this.unit) {
            return this.getValue();
        }
        float result = Float.NaN;
        if (MAGS_SQR_ARC_MIN.equals(unit)) {
            result = this.value - 8.875f;
        } else if (MAGS_SQR_ARC_SEC.equals(unit)) {
            result = this.value + 8.875f;
        }
        return result;
    }

    public static boolean isValidUnit(String unit) {
        return MAGS_SQR_ARC_MIN.equals(unit) || MAGS_SQR_ARC_SEC.equals(unit);
    }
}

