/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.bild;

import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.IllegalDimensionException;
import de.andreasroerig.bild.SigmaClipper;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsReader;
import de.andreasroerig.match.Trans;
import de.andreasroerig.tiff.TiffOutputStream;
import de.andreasroerig.tiff.TiffReader;
import de.andreasroerig.util.SLogger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class BWBild
extends Bild {
    private int[][] data;

    public BWBild() {
        this.setType(2);
        this.photometric = 2;
        this.theStars = null;
        this.st = null;
        this.sampPerPix = 1;
        this.bigEnd = true;
    }

    public BWBild(int len, int width) {
        this();
        this.data = new int[len][width];
        this.len = len;
        this.width = width;
    }

    public BWBild(BWBild aBild) {
        this();
        this.data = new int[aBild.len][aBild.width];
        this.len = aBild.len;
        this.width = aBild.width;
        this.bitsPerSamp = aBild.bitsPerSamp;
        this.bigEnd = aBild.bigEnd;
        this.sampPerPix = aBild.sampPerPix;
        this.type = aBild.type;
        int i = 0;
        while (i < this.len) {
            int j = 0;
            while (j < this.width) {
                this.data[i][j] = aBild.data[i][j];
                ++j;
            }
            ++i;
        }
        this.fname = aBild.getFname();
        this.calcStats();
    }

    public BWBild(TiffReader tr) {
        super(tr);
        this.photometric = 1;
        this.theStars = null;
        this.st = null;
    }

    public void getDataFromTiffReader(TiffReader tr) {
        this.data = tr.getData();
    }

    protected void destroyData() {
        this.data = null;
    }

    private BWBild cpyBildParam() {
        BWBild resImg = new BWBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.compression = this.compression;
        resImg.photometric = this.photometric;
        resImg.type = this.type;
        return resImg;
    }

    protected double calcBrightnes(int x, int y) {
        double erg = 0.0;
        try {
            try {
                erg = this.data[y][x];
            }
            catch (Exception e) {
                SLogger.debug("Exception: calcBrightness, x=" + x + ", y=" + y);
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return erg;
    }

    protected Bild doBlend(Bild[] bilder, int[] frameIndices, double[] weight) {
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        BWBild resImg = this.cpyBildParam();
        BWBild[] tmp = this.cpyBildArray(bilder);
        double sumWeight = this.calcSumWeight(weight, frameIndices.length);
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                double val = 0.0;
                double tempSumWeight = sumWeight;
                int i = 0;
                while (i < frameIndices.length) {
                    double tval = tmp[frameIndices[i]].data[l][w];
                    if (ignoreBlackBorder && tval <= 0.0) {
                        tempSumWeight -= weight[i];
                    } else {
                        val += tval * weight[i];
                    }
                    ++i;
                }
                resImg.data[l][w] = (int)(val / tempSumWeight);
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        return resImg;
    }

    public Bild doSigmaCombine(Bild[] bilder, int[] frameIndices) throws IllegalDimensionException {
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        double sigma = this.theParams.getCombineSigma();
        BWBild resImg = this.cpyBildParam();
        BWBild[] tmp = this.cpyBildArray(bilder);
        int[] tmparray = new int[frameIndices.length];
        int i = 0;
        while (i < frameIndices.length) {
            SLogger.debug("frameInices[" + i + "]=" + frameIndices[i]);
            if (tmp[frameIndices[i]].len != this.len || tmp[frameIndices[i]].width != this.width) {
                throw new IllegalDimensionException(tmp[frameIndices[i]].getFname());
            }
            if (tmp[frameIndices[i]].isRGB()) {
                throw new IllegalDimensionException("Images have different types!");
            }
            ++i;
        }
        SigmaClipper sc = new SigmaClipper(sigma, ignoreBlackBorder);
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                i = 0;
                while (i < frameIndices.length) {
                    tmparray[i] = tmp[frameIndices[i]].data[l][w];
                    ++i;
                }
                resImg.data[l][w] = sc.calcSigmaClip(tmparray);
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        sc.printStats();
        return resImg;
    }

    public Bild medianCombine(Bild[] bilder, int[] frameIndices) throws IllegalDimensionException {
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        int n = bilder.length;
        BWBild[] tmp = new BWBild[n];
        int i = 0;
        while (i < n) {
            tmp[i] = (BWBild)bilder[i];
            ++i;
        }
        SLogger.debug("calc Median of images...");
        boolean oddIndices = frameIndices.length / 2 * 2 != frameIndices.length;
        int medIndex = frameIndices.length / 2;
        if (frameIndices.length == 2) {
            medIndex = 0;
        }
        BWBild resImg = this.cpyBildParam();
        int[] thedata = new int[frameIndices.length];
        double sumWeight = 0.0;
        i = 0;
        while (i < frameIndices.length) {
            SLogger.debug("frameInices[" + i + "]=" + frameIndices[i]);
            if (bilder[frameIndices[i]].len != this.len || bilder[frameIndices[i]].width != this.width) {
                throw new IllegalDimensionException(bilder[frameIndices[i]].getFname());
            }
            if (bilder[frameIndices[i]].isRGB()) {
                throw new IllegalDimensionException("Images have different types!");
            }
            ++i;
        }
        int l = 0;
        while (l < this.len) {
            SLogger.print(".");
            int w = 0;
            while (w < this.width) {
                int tfi = frameIndices.length;
                int j = 0;
                i = 0;
                while (i < tfi) {
                    int tval;
                    thedata[i] = tval = tmp[frameIndices[i]].data[l][w];
                    if (!ignoreBlackBorder || tval > 0) {
                        ++j;
                    }
                    ++i;
                }
                if (j == 0) {
                    j = frameIndices.length;
                }
                Arrays.sort(thedata);
                oddIndices = j / 2 * 2 != j;
                medIndex = j / 2;
                medIndex = frameIndices.length - medIndex - 1;
                if (j == 2) {
                    medIndex = frameIndices.length - 2;
                }
                if (j == 1) {
                    medIndex = frameIndices.length - 1;
                }
                resImg.data[l][w] = oddIndices ? thedata[medIndex] : (thedata[medIndex] + thedata[medIndex + 1]) / 2;
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        return resImg;
    }

    private BWBild[] cpyBildArray(Bild[] bilder) {
        int n = bilder.length;
        BWBild[] tmp = new BWBild[n];
        int i = 0;
        while (i < n) {
            tmp[i] = (BWBild)bilder[i];
            ++i;
        }
        return tmp;
    }

    public void readFromTiff(String fname) throws IOException {
    }

    protected void writeTiffStrip(TiffOutputStream ras) throws IOException {
        int[] theBytes = new int[3];
        int y = 0;
        while (y < this.len) {
            int x = 0;
            while (x < this.width) {
                if (this.bitsPerSamp == 16) {
                    theBytes = this.getByteArray(this.data[y][x]);
                    ras.write(theBytes[0]);
                    ras.write(theBytes[1]);
                } else if (this.bitsPerSamp == 8) {
                    ras.write(this.data[y][x]);
                }
                ++x;
            }
            this.sleep(0);
            SLogger.print(".");
            ++y;
        }
        SLogger.println("#");
    }

    public BufferedImage getBufferedImage(int black, int white, int zoom) {
        int rgb;
        int td;
        int jz;
        int j;
        int iz;
        int i;
        this.zoom = zoom;
        this.screenWidth = this.width / zoom;
        this.screenLen = this.len / zoom;
        BufferedImage bi = new BufferedImage(this.screenWidth, this.screenLen, 1);
        double mult = white - black != 0 ? 255.0 / (double)(white - black) : 255.0;
        if (this.bitsPerSamp == 8) {
            i = 0;
            while (i < this.screenLen) {
                iz = i * zoom;
                j = 0;
                while (j < this.screenWidth) {
                    jz = j * zoom;
                    td = (int)((double)(this.data[iz][jz] - black) * mult);
                    td = td > 0 ? td : 0;
                    td = td < 256 ? td : 255;
                    rgb = td * 65536 + td * 256 + td;
                    bi.setRGB(j, i, rgb);
                    ++j;
                }
                ++i;
            }
        }
        if (this.bitsPerSamp == 16) {
            i = 0;
            while (i < this.screenLen) {
                iz = i * zoom;
                j = 0;
                while (j < this.screenWidth) {
                    jz = j * zoom;
                    td = (int)((double)(this.data[iz][jz] - black * 256) * mult) / 256;
                    td = td > 0 ? td : 0;
                    td = td < 256 ? td : 255;
                    rgb = td * 65536 + td * 256 + td;
                    bi.setRGB(j, i, rgb);
                    ++j;
                }
                ++i;
            }
        }
        return bi;
    }

    public BufferedImage getBufferedImage(int black, int white) {
        if (this.width > 1024 || this.len > 800) {
            this.zoom = 2;
        }
        if (this.width > 1200 || this.len > 1000) {
            this.zoom = 3;
        }
        if (this.width > 2200 || this.len > 2000) {
            this.zoom = 4;
        }
        return this.getBufferedImage(black, white, this.zoom);
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(0, 255);
    }

    public Bild rotate(int nw, int nh, boolean left) {
        BWBild resImg = new BWBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.bigEnd = this.bigEnd;
        resImg.type = this.type;
        int y = 0;
        while (y < nh) {
            int x = 0;
            while (x < nw) {
                int ix;
                int iy;
                if (left) {
                    iy = x;
                    ix = nh - y - 1;
                } else {
                    iy = nw - x - 1;
                    ix = y;
                }
                resImg.data[y][x] = this.data[iy][ix];
                ++x;
            }
            this.sleep(0);
            SLogger.print(".");
            ++y;
        }
        resImg.setFname("rotatedImg");
        this.calcStats();
        return resImg;
    }

    public Bild subtract(Bild sub) throws IllegalDimensionException {
        BWBild bw = (BWBild)sub;
        BWBild resImg = new BWBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.type = this.type;
        this.checkDimensions(this, sub);
        int y = 0;
        while (y < this.len) {
            int x = 0;
            while (x < this.width) {
                resImg.data[y][x] = this.data[y][x] - bw.data[y][x] >= 0 ? this.data[y][x] - bw.data[y][x] : 0;
                ++x;
            }
            ++y;
        }
        resImg.calcStats();
        return resImg;
    }

    public void toBW() {
    }

    public Bild doFlat(Bild flat) {
        int maxval = 256;
        BWBild myFlat = (BWBild)flat;
        BWBild resImg = new BWBild(this.len, this.width);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.compression = this.compression;
        resImg.photometric = this.photometric;
        resImg.type = this.type;
        flat.calcStats();
        if (this.bitsPerSamp == 16) {
            maxval = 65535;
        }
        int l = 0;
        while (l < this.len) {
            SLogger.print("-");
            int w = 0;
            while (w < this.width) {
                int val = (int)Math.round(flat.avgBrightness * (double)this.data[l][w] / (double)myFlat.data[l][w]);
                resImg.data[l][w] = val <= maxval ? val : maxval;
                ++w;
            }
            ++l;
        }
        SLogger.println("#");
        return resImg;
    }

    public void blendFiles(File[] files) throws IllegalDimensionException, IOException {
        int numfiles = files.length;
        SLogger.debug("blending Files...");
        FitsReader[] fr = new FitsReader[numfiles];
        int[][] rows = new int[numfiles][];
        try {
            int i = 0;
            while (i < numfiles) {
                fr[i] = new FitsReader(files[i].getAbsolutePath());
                if (i == 0) {
                    this.width = fr[i].getNoColumns();
                    this.len = fr[i].getNoRows();
                    this.data = new int[this.len][this.width];
                    this.bitsPerSamp = 16;
                    this.sampPerPix = 1;
                } else if (this.width != fr[i].getNoColumns() || this.len != fr[i].getNoRows()) {
                    throw new IllegalDimensionException(fr[i].getFname());
                }
                ++i;
            }
            int j = 0;
            while (j < this.len) {
                SLogger.print(".");
                i = 0;
                while (i < numfiles) {
                    rows[i] = fr[i].getRow(j);
                    ++i;
                }
                int k = 0;
                while (k < this.width) {
                    double val = 0.0;
                    i = 0;
                    while (i < numfiles) {
                        val += (double)rows[i][k];
                        ++i;
                    }
                    this.data[j][k] = (int)(val / (double)numfiles);
                    ++k;
                }
                ++j;
            }
            this.calcStats();
            this.setFname("BlendedFiles.fit");
            SLogger.println("#");
            SLogger.debug("blending Files finished!");
        }
        catch (FitsException e) {
            SLogger.debug("blendFiles Exception: " + e);
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            SLogger.debug("blendFiles Exception: " + e);
            throw e;
        }
    }

    public void sigmaCombineFiles(File[] files) throws IllegalDimensionException, IOException {
        int numfiles = files.length;
        double sigma = this.theParams.getCombineSigma();
        boolean ignoreBlackBorder = this.theParams.getIgnoreBlackBorder();
        int[] thedata = new int[numfiles];
        SLogger.debug("blending Files...");
        FitsReader[] fr = new FitsReader[numfiles];
        int[][] rows = new int[numfiles][];
        try {
            int i = 0;
            while (i < numfiles) {
                fr[i] = new FitsReader(files[i].getAbsolutePath());
                if (i == 0) {
                    this.width = fr[i].getNoColumns();
                    this.len = fr[i].getNoRows();
                    this.data = new int[this.len][this.width];
                    this.bitsPerSamp = 16;
                    this.sampPerPix = 1;
                } else if (this.width != fr[i].getNoColumns() || this.len != fr[i].getNoRows()) {
                    throw new IllegalDimensionException(fr[i].getFname());
                }
                ++i;
            }
            SigmaClipper sc = new SigmaClipper(sigma, ignoreBlackBorder);
            int j = 0;
            while (j < this.len) {
                SLogger.print(".");
                i = 0;
                while (i < numfiles) {
                    rows[i] = fr[i].getRow(j);
                    ++i;
                }
                int k = 0;
                while (k < this.width) {
                    i = 0;
                    while (i < numfiles) {
                        thedata[i] = rows[i][k];
                        ++i;
                    }
                    this.data[j][k] = sc.calcSigmaClip(thedata);
                    ++k;
                }
                ++j;
            }
            sc.printStats();
            this.calcStats();
            this.setFname("SigmaCombinedFiles.fit");
            SLogger.println("#");
            SLogger.debug("sigma combining Files finished!");
        }
        catch (FitsException e) {
            SLogger.debug("sigmaCombineFiles Exception: " + e);
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            SLogger.debug("sigmaCombineFiles Exception: " + e);
            throw e;
        }
    }

    public void medianCombineFiles(File[] files) throws IOException, IllegalDimensionException {
        int numfiles = files.length;
        SLogger.debug("median Combine Files...");
        boolean oddIndices = numfiles / 2 * 2 != numfiles;
        int medIndex = numfiles / 2;
        if (numfiles == 2) {
            medIndex = 0;
        }
        int[] values = new int[numfiles];
        FitsReader[] fr = new FitsReader[numfiles];
        int[][] rows = new int[numfiles][];
        try {
            int i = 0;
            while (i < numfiles) {
                fr[i] = new FitsReader(files[i].getAbsolutePath());
                if (i == 0) {
                    this.width = fr[i].getNoColumns();
                    this.len = fr[i].getNoRows();
                    this.data = new int[this.len][this.width];
                    this.bitsPerSamp = 16;
                    this.sampPerPix = 1;
                } else if (this.width != fr[i].getNoColumns() || this.len != fr[i].getNoRows()) {
                    throw new IllegalDimensionException(fr[i].getFname());
                }
                ++i;
            }
            int j = 0;
            while (j < this.len) {
                SLogger.print(".");
                i = 0;
                while (i < numfiles) {
                    rows[i] = fr[i].getRow(j);
                    ++i;
                }
                int k = 0;
                while (k < this.width) {
                    i = 0;
                    while (i < numfiles) {
                        values[i] = rows[i][k];
                        ++i;
                    }
                    Arrays.sort(values);
                    this.data[j][k] = oddIndices ? values[medIndex] : (values[medIndex] + values[medIndex + 1]) / 2;
                    ++k;
                }
                ++j;
            }
            this.calcStats();
            this.setFname("medianCombinedFiles.fit");
            SLogger.println("#");
            SLogger.debug("median Combine Files finished!");
        }
        catch (FitsException e) {
            SLogger.debug("medianCombineFiles Exception: " + e);
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            SLogger.debug("medianCombineFiles Exception: " + e);
            throw e;
        }
        rows = null;
        fr = null;
        values = null;
        System.gc();
    }

    public Bild transform(Trans t, int nw, int nh) {
        SLogger.debug("transformation start");
        long t1 = System.currentTimeMillis();
        BWBild resImg = new BWBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.bigEnd = this.bigEnd;
        resImg.type = this.type;
        int y = 0;
        while (y < nh) {
            int x = 0;
            while (x < nw) {
                double cx = t.calcX(x, y);
                double cy = t.calcY(x, y);
                int ix = (int)cx;
                int iy = (int)cy;
                if (ix >= 0 && iy >= 0 && ix < this.width && iy < this.len) {
                    resImg.data[y][x] = this.data[iy][ix];
                }
                ++x;
            }
            SLogger.print(".");
            ++y;
        }
        long t2 = System.currentTimeMillis();
        long tt = t2 - t1;
        SLogger.debug("");
        SLogger.debug("transformation end, time elapsed=" + tt);
        return resImg;
    }

    public Bild transformInterpol(Trans t, int nw, int nh) {
        SLogger.debug("transformation start");
        long t1 = System.currentTimeMillis();
        BWBild resImg = new BWBild(nh, nw);
        resImg.bitsPerSamp = this.bitsPerSamp;
        resImg.sampPerPix = this.sampPerPix;
        resImg.bigEnd = this.bigEnd;
        resImg.type = this.type;
        int y = 0;
        while (y < nh) {
            int x = 0;
            while (x < nw) {
                double cx = t.calcX(x, y);
                double cy = t.calcY(x, y);
                int ix = (int)cx;
                int iy = (int)cy;
                double dx = cx - (double)ix;
                double dy = cy - (double)iy;
                double value = 0.0;
                int m = -1;
                while (m < 3) {
                    int ixPlusM = ix + m;
                    double mdx = (double)m - dx;
                    double frmdx = this.fr(mdx);
                    int n = -1;
                    while (n < 3) {
                        int iyn = iy + n;
                        double ndy = (double)n - dy;
                        if (ixPlusM >= 0 && iyn >= 0 && ixPlusM < this.width && iyn < this.len) {
                            double frndy = this.fr(ndy);
                            double frmdxfrndy = frmdx * frndy;
                            value += (double)this.data[iyn][ixPlusM] * frmdxfrndy;
                        }
                        ++n;
                    }
                    ++m;
                }
                resImg.data[y][x] = (int)Math.rint(value);
                ++x;
            }
            SLogger.print(".");
            ++y;
        }
        long t2 = System.currentTimeMillis();
        long tt = t2 - t1;
        SLogger.debug("");
        SLogger.debug("transformation end, time elapsed=" + tt);
        return resImg;
    }

    public void readFromFits(String fname) throws IOException {
        this.fname = fname;
        this.type = 2;
        try {
            FitsReader fr = new FitsReader(fname);
            this.data = fr.getData();
            this.width = fr.getNoColumns();
            this.len = fr.getNoRows();
            this.bitsPerSamp = 16;
            this.sampPerPix = 1;
        }
        catch (FitsException e) {
            SLogger.debug("RGBBild.readFromTiff() FitsException! " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            SLogger.debug("RGBBild.readFromTiff() IOException! " + e.getMessage());
            throw e;
        }
        this.calcStats();
    }

    public int[][] getData() {
        return this.data;
    }

    public void setData(int[][] data) {
        this.data = data;
    }
}

