/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.bild;

import de.andreasroerig.bild.IllegalDimensionException;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsFile;
import de.andreasroerig.fits.FitsHDUnit;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import de.andreasroerig.fits.FitsMatrix;
import de.andreasroerig.gui.GuiHelper;
import de.andreasroerig.match.Star;
import de.andreasroerig.match.StarTriangle;
import de.andreasroerig.match.Trans;
import de.andreasroerig.tiff.TiffOutputStream;
import de.andreasroerig.tiff.TiffReader;
import de.andreasroerig.util.RegParams;
import de.andreasroerig.util.SLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JInternalFrame;

public abstract class Bild {
    public static final int TYPE_TIFF_RGB = 0;
    public static final int TYPE_TIFF_GREY = 1;
    public static final int TYPE_FITS = 2;
    protected int type;
    protected String fname;
    protected int width;
    protected int len;
    protected int screenWidth;
    protected int screenLen;
    protected int zoom = 1;
    protected int bitsPerSamp = 16;
    protected int compression;
    protected int photometric;
    protected int rowsPerStrip;
    protected int sampPerPix;
    protected int bytesPerRow;
    protected boolean bigEnd;
    protected double minBrighnessRatio;
    protected double maxBrighnessRatio;
    protected double maxBrightness;
    protected double minBrightness;
    protected double avgBrightness;
    protected double avgFWHM;
    protected Star[] starArray;
    protected Hashtable theStars;
    protected int starCount = 0;
    protected JInternalFrame theFrame;
    protected RegParams theParams = RegParams.instance();
    protected Vector matches = new Vector(20);
    protected StarTriangle st;

    public abstract void blendFiles(File[] var1) throws IOException, IllegalDimensionException;

    protected abstract double calcBrightnes(int var1, int var2);

    protected abstract void destroyData();

    protected abstract Bild doBlend(Bild[] var1, int[] var2, double[] var3);

    public abstract Bild doSigmaCombine(Bild[] var1, int[] var2) throws IllegalDimensionException;

    public abstract Bild doFlat(Bild var1);

    public abstract BufferedImage getBufferedImage();

    public abstract BufferedImage getBufferedImage(int var1, int var2);

    public abstract BufferedImage getBufferedImage(int var1, int var2, int var3);

    public abstract void getDataFromTiffReader(TiffReader var1);

    public abstract Bild medianCombine(Bild[] var1, int[] var2) throws IllegalDimensionException;

    public abstract void medianCombineFiles(File[] var1) throws IOException, IllegalDimensionException;

    public abstract void readFromFits(String var1) throws IOException;

    public abstract void readFromTiff(String var1) throws IOException;

    public abstract Bild rotate(int var1, int var2, boolean var3);

    public abstract void sigmaCombineFiles(File[] var1) throws IOException, IllegalDimensionException;

    public abstract Bild subtract(Bild var1) throws IllegalDimensionException;

    public abstract void toBW();

    protected abstract void writeTiffStrip(TiffOutputStream var1) throws IOException;

    public abstract Bild transform(Trans var1, int var2, int var3);

    public abstract Bild transformInterpol(Trans var1, int var2, int var3);

    public Bild() {
    }

    public Bild(TiffReader tr) {
        this();
        this.fname = tr.getFname();
        if (tr.getImgType() == 0) {
            this.type = 0;
        }
        if (tr.getImgType() == 1) {
            this.type = 1;
        }
        this.width = tr.getWidth();
        this.len = tr.getLen();
        this.bitsPerSamp = tr.getBitsPerSamp();
        this.sampPerPix = tr.getSampPerPix();
        this.getDataFromTiffReader(tr);
        this.calcStats();
    }

    public void drawMatches(int xoff, int yoff, Graphics g) {
        g.setColor(Color.pink);
        int i = 0;
        while (i < this.matches.size()) {
            StarTriangle st = (StarTriangle)this.matches.get(i);
            if (st.isVerified()) {
                g.setColor(Color.cyan);
            } else {
                g.setColor(Color.orange);
            }
            this.drawTriangle(st, xoff, yoff, g);
            ++i;
        }
    }

    protected double calcSumWeight(double[] weight, int n) {
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += weight[i];
            ++i;
        }
        return sum;
    }

    public Bild blend(Bild[] bilder, int[] frameIndices, double[] weight) throws IllegalDimensionException {
        boolean bRGB = this.isRGB();
        int i = 0;
        while (i < frameIndices.length) {
            if (this.width != bilder[frameIndices[i]].getWidth() || this.len != bilder[frameIndices[i]].getLen()) {
                throw new IllegalDimensionException(bilder[frameIndices[i]].getFname());
            }
            if (bRGB != bilder[frameIndices[i]].isRGB()) {
                throw new IllegalDimensionException("Images have different types!");
            }
            ++i;
        }
        Bild resImg = this.doBlend(bilder, frameIndices, weight);
        return resImg;
    }

    public Bild sigmaCombine(Bild[] bilder, int[] frameIndices) throws IllegalDimensionException {
        boolean bRGB = this.isRGB();
        int i = 0;
        while (i < frameIndices.length) {
            if (this.width != bilder[frameIndices[i]].getWidth() || this.len != bilder[frameIndices[i]].getLen()) {
                throw new IllegalDimensionException(bilder[frameIndices[i]].getFname());
            }
            if (bRGB != bilder[frameIndices[i]].isRGB()) {
                throw new IllegalDimensionException("Images have different types!");
            }
            ++i;
        }
        Bild resImg = this.doSigmaCombine(bilder, frameIndices);
        return resImg;
    }

    public void addMatch(StarTriangle t) {
        int i = 0;
        while (i < this.matches.size()) {
            StarTriangle aT = (StarTriangle)this.matches.elementAt(i);
            if (t.getAd() <= aT.getAd()) break;
            ++i;
        }
        this.matches.insertElementAt(new StarTriangle(t), i);
    }

    public Hashtable getMatchStarIndices() {
        Hashtable<Integer, Integer> ht = new Hashtable<Integer, Integer>();
        int n = this.matches.size();
        int i = 0;
        while (i < n) {
            StarTriangle t = this.getMatch(i);
            Star s = t.getS1();
            ht.put(new Integer(s.getIndex()), new Integer(s.getIndex()));
            s = t.getS2();
            ht.put(new Integer(s.getIndex()), new Integer(s.getIndex()));
            s = t.getS3();
            ht.put(new Integer(s.getIndex()), new Integer(s.getIndex()));
            ++i;
        }
        return ht;
    }

    public StarTriangle getMatch(int idx) {
        return (StarTriangle)this.matches.elementAt(idx);
    }

    public StarTriangle getFirstVerifiedMatch() {
        int i = 0;
        while (i < this.matches.size()) {
            StarTriangle st = this.getMatch(i);
            if (st.isVerified()) {
                return st;
            }
            ++i;
        }
        return null;
    }

    public int getNumMatches() {
        return this.matches.size();
    }

    public void clearAll() {
        this.clearMatches();
        this.clearTheStars();
    }

    public void clearTheStars() {
        if (this.theStars != null) {
            this.theStars.clear();
        }
        this.theStars = null;
        this.starArray = null;
        this.starCount = 0;
    }

    public void clearMatches() {
        this.matches.removeAllElements();
        this.matches = new Vector(20);
    }

    public void removeInvalidMatches() {
        int i = 0;
        SLogger.debug("removing invalid matches...");
        while (i < this.matches.size()) {
            if (!this.getMatch(i).isVerified()) {
                this.matches.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    protected void drawTriangle(StarTriangle st, int xoff, int yoff, Graphics g) {
        Color c = g.getColor();
        g.setColor(Color.red);
        this.drawCircle(xoff + st.getS1().getX() / this.zoom, yoff + st.getS1().getY() / this.zoom, (int)st.getS1().getFwhm() * 2 / this.zoom + 1, g);
        g.setColor(c);
        this.drawCircle(xoff + st.getS2().getX() / this.zoom, yoff + st.getS2().getY() / this.zoom, (int)st.getS2().getFwhm() * 2 / this.zoom + 1, g);
        this.drawCircle(xoff + st.getS3().getX() / this.zoom, yoff + st.getS3().getY() / this.zoom, (int)st.getS3().getFwhm() * 2 / this.zoom + 1, g);
        g.drawLine(xoff + st.getS1().getX() / this.zoom, yoff + st.getS1().getY() / this.zoom, xoff + st.getS2().getX() / this.zoom, yoff + st.getS2().getY() / this.zoom);
        g.drawLine(xoff + st.getS1().getX() / this.zoom, yoff + st.getS1().getY() / this.zoom, xoff + st.getS3().getX() / this.zoom, yoff + st.getS3().getY() / this.zoom);
        g.drawLine(xoff + st.getS2().getX() / this.zoom, yoff + st.getS2().getY() / this.zoom, xoff + st.getS3().getX() / this.zoom, yoff + st.getS3().getY() / this.zoom);
    }

    public void drawTheTriangle(int xoff, int yoff, Graphics g) {
        if (this.st != null) {
            g.setColor(Color.green);
            this.drawTriangle(this.st, xoff, yoff, g);
        }
    }

    protected void drawCircle(int x, int y, int r, Graphics g) {
        if (r == 0) {
            r = 2;
        }
        g.drawOval(x -= r / 2, y -= r / 2, r, r);
    }

    public void printStarArray() {
        int i = 0;
        while (i < this.starCount) {
            SLogger.debug("B=" + this.starArray[i].getBright() + ", FWHM=" + this.starArray[i].getFwhm() + ", OD=" + this.starArray[i].getOriginDistance() + ", CD=" + this.starArray[i].getCenterDistance());
            ++i;
        }
        SLogger.debug("Anzahl Sterne im array: " + this.starCount);
    }

    public void sortStarArray(int sortCriteria) {
        Star myStar = new Star();
        myStar.setSortCriteria(sortCriteria);
        Arrays.sort(this.starArray, myStar);
    }

    public void findStars() {
        Star myStar;
        double maxBright = 0.0;
        double sumfwhm = 0.0;
        this.clearTheStars();
        this.theStars = new Hashtable();
        this.minBrighnessRatio = this.theParams.getMinBrighnessRatio();
        this.maxBrighnessRatio = this.theParams.getMaxBrighnessRatio();
        int fwhmFactor = this.theParams.getFwhmFactor();
        this.starCount = 0;
        this.avgFWHM = 0.0;
        boolean mbYPos = false;
        boolean mbXPos = false;
        double lowerBrightThreshold = this.maxBrightness * this.minBrighnessRatio;
        double upperBrightThreshold = this.maxBrightness * this.maxBrighnessRatio;
        int i = 0;
        while (i < this.len) {
            int j = 0;
            while (j < this.width) {
                double curBright = this.calcBrightnes(j, i);
                if (curBright > lowerBrightThreshold && curBright < upperBrightThreshold && (myStar = this.findLocalStar(j, i)) != null) {
                    this.theStars.put(myStar.getPos(), myStar);
                    ++this.starCount;
                    sumfwhm += myStar.getFwhm();
                }
                ++j;
            }
            ++i;
        }
        this.avgFWHM = sumfwhm / (double)this.starCount;
        SLogger.debug("Anzahl Sterne: " + this.starCount);
        SLogger.debug("Durchn. FWHM: " + this.avgFWHM);
        double fwhmThreshold = (double)fwhmFactor * this.avgFWHM;
        Enumeration en = this.theStars.elements();
        i = 0;
        while (en.hasMoreElements()) {
            myStar = (Star)en.nextElement();
            if (myStar.getFwhm() < fwhmThreshold && myStar.getFwhm() > 0.0) {
                ++i;
                continue;
            }
            this.theStars.remove(myStar.getPos());
        }
        this.starCount = i;
        this.starArray = new Star[this.starCount];
        en = this.theStars.elements();
        i = 0;
        double cx = (double)this.width / 2.0;
        double cy = (double)this.len / 2.0;
        while (en.hasMoreElements()) {
            myStar = (Star)en.nextElement();
            if (!(myStar.getFwhm() < fwhmThreshold) || !(myStar.getFwhm() > 0.0)) continue;
            double aQuadrat = Math.pow((double)myStar.getX() - cx, 2.0);
            double bQuadrat = Math.pow((double)myStar.getY() - cy, 2.0);
            double distance = Math.sqrt(aQuadrat + bQuadrat);
            myStar.setCenterDistance(distance);
            this.starArray[i] = myStar;
            ++i;
        }
        this.starCount = i;
        myStar = new Star();
    }

    protected Star findLocalStar(int x, int y) {
        double maxBright = this.avgBrightness;
        double fwhm = 1.0;
        int centXPos = 0;
        int centYPos = 0;
        Star aStar = null;
        boolean invalid = false;
        double centdXPos = 0.0;
        double centdYPos = 0.0;
        int radius = this.theParams.getRadius();
        double upperBrightThreshold = this.maxBrightness * this.maxBrighnessRatio;
        try {
            int[] mbXPos = new int[4 * radius * radius];
            int[] mbYPos = new int[4 * radius * radius];
            int poscount = 0;
            if (y - radius > 0 && y + radius < this.len - 1 && x - radius > 0 && x + radius < this.width - 1) {
                double curBright;
                int j;
                int i = y - radius;
                while (i < y + radius) {
                    j = x - radius;
                    while (j < x + radius) {
                        curBright = this.calcBrightnes(j, i);
                        if (curBright > maxBright) {
                            maxBright = curBright;
                            poscount = 0;
                            mbXPos[poscount] = j;
                            mbYPos[poscount] = i;
                            ++poscount;
                        } else if (curBright == maxBright && maxBright > 0.0) {
                            mbXPos[poscount] = j;
                            mbYPos[poscount] = i;
                            ++poscount;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (maxBright < upperBrightThreshold) {
                    i = 0;
                    while (i < poscount) {
                        centXPos += mbXPos[i];
                        centYPos += mbYPos[i];
                        ++i;
                    }
                    if (poscount > 1) {
                        centXPos = Math.round(centXPos / poscount);
                        centYPos = Math.round(centYPos / poscount);
                    }
                    if (centYPos - radius > 0 && centYPos + radius < this.len - 1 && centXPos - radius > 0 && centXPos + radius < this.width - 1) {
                        int tempfwhm = 0;
                        i = centYPos;
                        while (i < centYPos + radius) {
                            curBright = this.calcBrightnes(centXPos, i);
                            if (curBright < maxBright / 1.5) {
                                tempfwhm = i - centYPos;
                                break;
                            }
                            ++i;
                        }
                        int ymax = centYPos + tempfwhm;
                        fwhm += (double)tempfwhm;
                        tempfwhm = 0;
                        i = centYPos;
                        while (i > centYPos - radius) {
                            curBright = this.calcBrightnes(centXPos, i);
                            if (curBright < maxBright / 1.5) {
                                tempfwhm = centYPos - i;
                                break;
                            }
                            --i;
                        }
                        int ymin = centYPos - tempfwhm;
                        fwhm += (double)tempfwhm;
                        tempfwhm = 0;
                        i = centXPos;
                        while (i > centXPos - radius) {
                            curBright = this.calcBrightnes(i, centYPos);
                            if (curBright < maxBright / 1.5) {
                                tempfwhm = centXPos - i;
                                break;
                            }
                            --i;
                        }
                        int xmin = centXPos - tempfwhm;
                        fwhm += (double)tempfwhm;
                        tempfwhm = 0;
                        i = centXPos;
                        while (i < centXPos + radius) {
                            curBright = this.calcBrightnes(i, centYPos);
                            if (curBright < maxBright / 1.5) {
                                tempfwhm = i - centXPos;
                                break;
                            }
                            ++i;
                        }
                        int xmax = centXPos + tempfwhm;
                        fwhm += (double)tempfwhm;
                        centXPos = (int)Math.round((double)(xmin + xmax) / 2.0);
                        centYPos = (int)Math.round((double)(ymin + ymax) / 2.0);
                        centdXPos = (double)(xmin + xmax) / 2.0;
                        centdYPos = (double)(ymin + ymax) / 2.0;
                        maxBright = maxBright * (fwhm /= 2.0) * fwhm;
                        i = centXPos - radius;
                        while (i < centXPos + radius) {
                            j = centYPos - radius;
                            while (j < centYPos + radius) {
                                aStar = (Star)this.theStars.get(new Dimension(i, j));
                                if (aStar != null) {
                                    if (aStar.getBright() >= maxBright) {
                                        invalid = true;
                                        aStar = null;
                                        break;
                                    }
                                    this.theStars.remove(new Dimension(i, j));
                                    --this.starCount;
                                    aStar = null;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    } else {
                        invalid = true;
                        aStar = null;
                    }
                    if (aStar == null && !invalid) {
                        aStar = new Star(centXPos, centYPos, fwhm, maxBright);
                        aStar.setDx(centdXPos);
                        aStar.setDy(centdYPos);
                    }
                } else {
                    aStar = null;
                }
            } else {
                aStar = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aStar;
    }

    public void drawStars(int xoff, int yoff, Graphics g) {
        if (this.theStars != null) {
            Enumeration e = this.theStars.keys();
            while (e.hasMoreElements()) {
                Dimension d = (Dimension)e.nextElement();
                Star s = (Star)this.theStars.get(d);
                Double db = new Double(s.getFwhm());
                int r = db.intValue();
                this.drawCircle(xoff + d.width / this.zoom, yoff + d.height / this.zoom, r * 2 / this.zoom, g);
            }
        }
    }

    public void checkDimensions(Bild b1, Bild b2) throws IllegalDimensionException {
        if (b1.width != b2.width || b1.len != b2.len) {
            throw new IllegalDimensionException(String.valueOf(b1.getFname()) + " | " + b2.getFname());
        }
    }

    public void calcStats() {
        this.maxBrightness = 0.0;
        this.minBrightness = 65536.0;
        double sumBright = 0.0;
        int i = 0;
        while (i < this.len) {
            int j = 0;
            while (j < this.width) {
                double curBright = this.calcBrightnes(j, i);
                if (curBright > this.maxBrightness) {
                    this.maxBrightness = curBright;
                }
                if (curBright < this.minBrightness) {
                    this.minBrightness = curBright;
                }
                sumBright += curBright;
                ++j;
            }
            ++i;
        }
        this.avgBrightness = sumBright / (double)(this.len * this.width);
        SLogger.debug("MinVal = " + this.minBrightness);
        SLogger.debug("MaxVal = " + this.maxBrightness);
        SLogger.debug("AvgVal = " + this.avgBrightness);
    }

    public void saveStarArray() {
        try {
            FileWriter fw = new FileWriter(String.valueOf(this.getFname()) + ".txt");
            int i = 0;
            while (i < this.starCount) {
                fw.write(i + "\t\t" + this.starArray[i].getPos().getHeight() + "\t\t" + this.starArray[i].getPos().getWidth());
                String s = "" + this.starArray[i].getBright();
                s = s.substring(0, s.indexOf(".") + 3 < s.length() ? s.indexOf(".") + 3 : s.indexOf(".") + 2);
                fw.write("\t\t" + s + "\n");
                ++i;
            }
            fw.close();
            SLogger.debug("Anzahl Sterne im array: " + this.starCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeAsTiff(String fname) throws IOException {
        this.fname = fname;
        byte[] bar = new byte[255];
        SLogger.debug("Bild.writeAsTiff() Start! fname=" + fname);
        TiffOutputStream tos = new TiffOutputStream(fname);
        this.writeTiffHeader(tos);
        this.writeIfd(tos);
        this.writeTiffStrip(tos);
        tos.close();
        SLogger.debug("Bild.writeAsTiff() beendet! fname=" + fname);
    }

    protected void writeTiffHeader(TiffOutputStream ras) throws IOException {
        byte[] bar = new byte[5];
        int[] theBytes = new int[5];
        ras.writeByte(73);
        ras.writeByte(73);
        ras.writeByte(42);
        ras.writeByte(0);
        theBytes = this.getByteArray(8L);
        int i = 0;
        while (i < 4) {
            ras.write(theBytes[i]);
            ++i;
        }
    }

    protected long writeIfd(TiffOutputStream ras) throws IOException {
        int[] theBytes = new int[5];
        long offset = 8L;
        theBytes = this.getByteArray(12);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(257);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray((long)this.len);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(256);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray((long)this.width);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(277);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray((long)this.sampPerPix);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(278);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray((long)this.len);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(279);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(4);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray((long)(this.len * this.width) * 3L * (long)this.bitsPerSamp);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(282);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(5);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(100L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(283);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(5);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(108L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(296);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(259);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(262);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray((long)this.photometric);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(273);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(4);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(1L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(200L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        theBytes = this.getByteArray(258);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        theBytes = this.getByteArray(3);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        if (this.type == 0) {
            theBytes = this.getByteArray(3L);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
            ras.write(theBytes[2]);
            ras.write(theBytes[3]);
            theBytes = this.getByteArray(ras.getFilePointer() + 8L);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
            ras.write(theBytes[2]);
            ras.write(theBytes[3]);
        }
        if (this.type == 1) {
            theBytes = this.getByteArray(1L);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
            ras.write(theBytes[2]);
            ras.write(theBytes[3]);
            theBytes = this.getByteArray((long)this.bitsPerSamp);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
            ras.write(theBytes[2]);
            ras.write(theBytes[3]);
        }
        theBytes = this.getByteArray(0L);
        ras.write(theBytes[0]);
        ras.write(theBytes[1]);
        ras.write(theBytes[2]);
        ras.write(theBytes[3]);
        if (this.type == 0) {
            theBytes = this.getByteArray(this.bitsPerSamp);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
            theBytes = this.getByteArray(this.bitsPerSamp);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
            theBytes = this.getByteArray(this.bitsPerSamp);
            ras.write(theBytes[0]);
            ras.write(theBytes[1]);
        }
        ras.seek(200L);
        return ras.getFilePointer();
    }

    protected double fr(double x) {
        double t1 = x + 2.0;
        t1 = t1 > 0.0 ? t1 * t1 * t1 : 0.0;
        double t2 = x + 1.0;
        t2 = t2 > 0.0 ? t2 * t2 * t2 * 4.0 : 0.0;
        double t3 = x > 0.0 ? x * x * x * 6.0 : 0.0;
        double t4 = x - 1.0;
        t4 = t4 > 0.0 ? t4 * t4 * t4 * 4.0 : 0.0;
        double result = (t1 - t2 + t3 - t4) / 6.0;
        return result;
    }

    protected double fp(double x) {
        return x > 0.0 ? x : 0.0;
    }

    public StarTriangle getSt() {
        return this.st;
    }

    public void setSt(StarTriangle st) {
        try {
            this.st = st;
            this.theFrame.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        SLogger.debug("Bild finalize() called.");
        this.clearAll();
        this.destroyData();
        super.finalize();
    }

    public int calcInt16(int[] bytes) {
        if (this.bigEnd) {
            return bytes[0] * 256 + bytes[1];
        }
        return bytes[1] * 256 + bytes[0];
    }

    public long calcInt32(int[] bytes) {
        if (this.bigEnd) {
            return bytes[0] * 0x1000000 + bytes[1] * 65536 + bytes[2] * 256 + bytes[3];
        }
        return bytes[3] * 0x1000000 + bytes[2] * 65536 + bytes[1] * 256 + bytes[0];
    }

    public int[] getByteArray(long val) {
        int tmp;
        int[] bar = new int[4];
        bar[3] = tmp = (int)(val / 0x1000000L);
        val -= (long)(tmp * 0x1000000);
        bar[2] = tmp = (int)(val / 65536L);
        val -= (long)(tmp * 65536);
        bar[1] = tmp = (int)(val / 256L);
        bar[0] = (int)(val - (long)(tmp * 256));
        return bar;
    }

    public int[] getByteArray(int val) {
        int tmp;
        int[] bar = new int[2];
        bar[1] = tmp = val / 256;
        bar[0] = val - tmp * 256;
        return bar;
    }

    public void writeAsFits(String fname) {
        String extension = ".fit";
        int[] naxis = new int[]{this.width, this.len};
        int nax = naxis[0] * naxis[1];
        short[] data = new short[nax];
        int n = 0;
        int i = 0;
        while (i < this.len) {
            int j = 0;
            while (j < this.width) {
                data[n] = (short)(this.calcBrightnes(j, i) + -32768.0);
                ++n;
                ++j;
            }
            ++i;
        }
        FitsHDUnit hdu0 = null;
        try {
            FitsMatrix mtx0 = new FitsMatrix(16, naxis);
            mtx0.setShortValues(0, data);
            double zero = Math.abs(Short.MIN_VALUE);
            FitsHeader hdr0 = mtx0.getHeader();
            hdr0.addKeyword(new FitsKeyword("BSCALE", 1.0, "BSCALE value"));
            hdr0.addKeyword(new FitsKeyword("BZERO", zero, "BZERO value"));
            hdr0.addKeyword(new FitsKeyword("DATE", new Date(), "Date of writing"));
            hdu0 = new FitsHDUnit(hdr0, mtx0);
        }
        catch (FitsException e) {
            SLogger.debug("Error: cannot create HDU0;" + e);
            System.exit(1);
        }
        FitsFile file = new FitsFile();
        file.addHDUnit(hdu0);
        int noHDU = file.getNoHDUnits();
        SLogger.debug("FITS file has " + noHDU + " HDUnits");
        if (!GuiHelper.isFitsFileExtension(fname)) {
            fname = String.valueOf(fname) + extension;
        }
        try {
            file.writeFile(fname);
        }
        catch (FitsException e) {
            SLogger.debug("Error: FITS problem in writing >" + fname + "<");
        }
        catch (IOException e) {
            SLogger.debug("Error: cannot write file >" + fname + "<");
        }
        SLogger.debug("Bild.writeAsFits(" + fname + ") beendet!");
    }

    public boolean isRGB() {
        return this.type == 0;
    }

    public double getAvgBrightness() {
        return this.avgBrightness;
    }

    public void setAvgBrightness(double avgBrightness) {
        this.avgBrightness = avgBrightness;
    }

    public double getAvgFWHM() {
        return this.avgFWHM;
    }

    public void setAvgFWHM(double avgFWHM) {
        this.avgFWHM = avgFWHM;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public double getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setMaxBrightness(double maxBrightness) {
        this.maxBrightness = maxBrightness;
    }

    public double getMinBrightness() {
        return this.minBrightness;
    }

    public void setMinBrightness(double minBrightness) {
        this.minBrightness = minBrightness;
    }

    public int getScreenLen() {
        return this.screenLen;
    }

    public void setScreenLen(int screenLen) {
        this.screenLen = screenLen;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public Star[] getStarArray() {
        return this.starArray;
    }

    public void setStarArray(Star[] starArray) {
        this.starArray = starArray;
    }

    public int getStarCount() {
        return this.starCount;
    }

    public void setStarCount(int starCount) {
        this.starCount = starCount;
    }

    public JInternalFrame getTheFrame() {
        return this.theFrame;
    }

    public void setTheFrame(JInternalFrame theFrame) {
        this.theFrame = theFrame;
    }

    public RegParams getTheParams() {
        return this.theParams;
    }

    public void setTheParams(RegParams theParams) {
        this.theParams = theParams;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public int getBitsPerSamp() {
        return this.bitsPerSamp;
    }

    public void setBitsPerSamp(int bitsPerSamp) {
        this.bitsPerSamp = bitsPerSamp;
    }
}

