/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class FitsKeyword {
    public static final int NONE = 0;
    public static final int COMMENT = 1;
    public static final int STRING = 2;
    public static final int BOOLEAN = 3;
    public static final int INTEGER = 4;
    public static final int REAL = 5;
    public static final int DATE = 6;
    private final byte NULL = 0;
    private final byte SPACE = (byte)32;
    private final byte COMMA = (byte)44;
    private final byte QUOTE = (byte)39;
    private final byte SLASH = (byte)47;
    private final byte EQUAL = (byte)61;
    private final byte MINUS = (byte)45;
    private final byte UNDERSCORE = (byte)95;
    private final byte A = (byte)65;
    private final byte Z = (byte)90;
    private String name;
    private int type = 0;
    private String kwCard;
    private boolean validCard = false;
    private Object value;
    private String comment;
    private boolean valueTruncated = false;
    private static final SimpleDateFormat ISOLONG = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat ISOSHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FITSDATE = new SimpleDateFormat("dd/MM/yy");
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");

    public FitsKeyword(byte[] card) throws FitsException {
        int idx = 0;
        int idx_last = 0;
        int idx_comm_first = 0;
        if (card == null || card.length < 80) {
            byte[] pc = new byte[80];
            int n = 0;
            while (n < card.length) {
                pc[n] = card[n];
                ++n;
            }
            while (n < 80) {
                pc[n++] = 32;
            }
            card = pc;
        }
        if (card[0] != 32 && card[0] != 45 && card[0] != 95 && (card[0] < 65 || 90 < card[0])) {
            throw new FitsException("Illegal character", 2);
        }
        this.kwCard = new String(card, 0, 80);
        this.validCard = true;
        this.name = this.kwCard.substring(0, 8);
        String valueField = null;
        this.comment = null;
        if (this.name.startsWith("END     ")) {
            throw new FitsException("END card", 3);
        }
        if (this.name.startsWith("HISTORY ") || this.name.startsWith("COMMENT ") || this.name.startsWith("        ")) {
            this.type = 1;
            idx_comm_first = 8;
        } else if (this.name.startsWith("HIERARCH")) {
            StringBuffer hkw = new StringBuffer(80);
            boolean found = false;
            int last = 0;
            idx = 8;
            while (idx < 80 && card[idx] != 61) {
                if (card[idx] != 32) {
                    try {
                        if (last == 32 && found) {
                            hkw.append('.');
                        }
                        found = true;
                        hkw.append((char)card[idx]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                last = card[idx++];
            }
            if (80 <= idx) {
                throw new FitsException("No equal-sign in HIERARCH keyword", 2);
            }
            this.name = hkw.toString();
        } else if (card[8] == 61) {
            idx = 8;
        } else {
            this.type = 1;
            idx_comm_first = 8;
        }
        this.name = this.name.trim().toUpperCase();
        if (card[idx] == 61) {
            block37: {
                ++idx;
                while (idx < 80 && card[idx] == 32) {
                    ++idx;
                }
                if (idx < 80 && card[idx] == 39) {
                    idx_last = ++idx;
                    while (idx_last < 79 && (card[idx_last] != 39 || card[idx_last] == 39 && card[idx_last + 1] == 39)) {
                        if (card[idx_last] == 39) {
                            ++idx_last;
                        }
                        ++idx_last;
                    }
                    int n1 = idx;
                    int n2 = idx;
                    boolean last_not_quote = true;
                    while (n1 < idx_last) {
                        card[n2] = card[n1];
                        if (card[n1] == 39) {
                            boolean bl = last_not_quote = !last_not_quote;
                        }
                        if (last_not_quote) {
                            ++n2;
                        }
                        ++n1;
                    }
                    valueField = n1 == n2 ? this.kwCard.substring(idx, n2) : new String(card, idx, n2 - idx);
                    this.type = 2;
                    n1 = this.name.lastIndexOf(46) + 1;
                    if (this.name.regionMatches(n1, "DATE", 0, 4)) {
                        SimpleDateFormat dateFormat = FITSDATE;
                        if (valueField.indexOf(45) > 0) {
                            dateFormat = valueField.indexOf(84) > 0 ? ISOLONG : ISOSHORT;
                        }
                        dateFormat.setTimeZone(TIMEZONE);
                        this.value = dateFormat.parse(valueField, new ParsePosition(0));
                        this.type = 6;
                    } else {
                        this.value = valueField.trim();
                        this.type = 2;
                    }
                } else {
                    idx_last = idx;
                    while (idx_last < 80 && card[idx_last] != 32 && card[idx_last] != 47 && card[idx_last] != 44) {
                        ++idx_last;
                    }
                    valueField = this.kwCard.substring(idx, idx_last);
                    try {
                        if (valueField.indexOf(46) >= 0) {
                            this.value = new Double(valueField);
                            this.type = 5;
                            break block37;
                        }
                        this.value = new Integer(valueField);
                        this.type = 4;
                    }
                    catch (NumberFormatException e) {
                        this.value = new Boolean(valueField.regionMatches(true, 0, "T", 0, 1));
                        this.type = 3;
                    }
                }
            }
            while (idx_last < 80 && card[idx_last] != 47) {
                ++idx_last;
            }
            if (idx_last < 80 && card[idx_last] == 47) {
                idx_comm_first = idx_last + 1;
            }
        }
        if (idx_comm_first > 0) {
            this.comment = this.kwCard.substring(idx_comm_first, 80);
            this.comment = this.comment.trim();
        } else {
            this.comment = new String("");
        }
    }

    public FitsKeyword(String card) throws FitsException {
        this(card.getBytes());
    }

    public FitsKeyword(String name, String comment) {
        this.setName(name);
        this.comment = comment;
        this.type = 1;
        this.validCard = false;
    }

    public FitsKeyword(String name, String value, String comment) {
        this.setName(name);
        this.value = value;
        this.comment = comment;
        this.type = 2;
        this.validCard = false;
    }

    public FitsKeyword(String name, boolean value, String comment) {
        this.setName(name);
        this.value = new Boolean(value);
        this.comment = comment;
        this.type = 3;
        this.validCard = false;
    }

    public FitsKeyword(String name, int value, String comment) {
        this.setName(name);
        this.value = new Integer(value);
        this.comment = comment;
        this.type = 4;
        this.validCard = false;
    }

    public FitsKeyword(String name, double value, String comment) {
        this.setName(name);
        this.value = new Double(value);
        this.comment = comment;
        this.type = 5;
        this.validCard = false;
    }

    public FitsKeyword(String name, Date value, String comment) {
        this.setName(name);
        this.value = value;
        this.comment = comment;
        this.type = 6;
        this.validCard = false;
    }

    public final boolean getBool() {
        if (this.type == 3) {
            return (Boolean)this.value;
        }
        if (this.type == 4) {
            return (Integer)this.value != 0;
        }
        if (this.type == 5) {
            return ((Double)this.value).intValue() != 0;
        }
        return false;
    }

    public final int getInt() {
        if (this.type == 4) {
            return (Integer)this.value;
        }
        if (this.type == 5) {
            return ((Double)this.value).intValue();
        }
        return 0;
    }

    public final double getReal() {
        if (this.type == 5) {
            return (Double)this.value;
        }
        if (this.type == 4) {
            return ((Integer)this.value).doubleValue();
        }
        return 0.0;
    }

    public final Date getDate() {
        if (this.value == null) {
            return null;
        }
        if (this.type == 6) {
            return (Date)this.value;
        }
        if (this.type == 2) {
            String str = (String)this.value;
            SimpleDateFormat dateFormat = FITSDATE;
            if (str.indexOf(45) > 0) {
                dateFormat = str.indexOf(84) > 0 ? ISOLONG : ISOSHORT;
            }
            dateFormat.setTimeZone(TIMEZONE);
            return dateFormat.parse(str, new ParsePosition(0));
        }
        return null;
    }

    public final String getString() {
        if (this.value == null) {
            return null;
        }
        if (this.type == 6) {
            SimpleDateFormat dateFormat = ISOLONG;
            dateFormat.setTimeZone(TIMEZONE);
            return dateFormat.format((Date)this.value, new StringBuffer(), new FieldPosition(0)).toString();
        }
        return this.value.toString();
    }

    public final void setValue(String value) {
        this.value = value;
        this.type = 2;
        this.validCard = false;
    }

    public final void setValue(boolean value) {
        this.value = new Boolean(value);
        this.type = 3;
        this.validCard = false;
    }

    public final void setValue(int value) {
        this.value = new Integer(value);
        this.type = 4;
        this.validCard = false;
    }

    public final void setValue(double value) {
        this.value = new Double(value);
        this.type = 5;
        this.validCard = false;
    }

    public final void setValue(Date value) {
        this.value = value;
        this.type = 6;
        this.validCard = false;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block26: {
            if (this.validCard) {
                return this.kwCard;
            }
            card = new StringBuffer(80);
            if (this.name.length() < 9 && this.name.indexOf(46) < 0) {
                card.append(this.name);
                idx = card.length();
                while (idx++ < 8) {
                    card.append(" ");
                }
            } else {
                card.append("HIERARCH ");
                stok = new StringTokenizer(this.name, ".");
                while (stok.hasMoreTokens()) {
                    card.append(String.valueOf(stok.nextToken()) + " ");
                }
            }
            val = "'        '";
            switch (this.type) {
                case 2: {
                    try {
                        sbuf = new StringBuffer((String)this.value);
                        if (((String)this.value).indexOf(39) >= 0) {
                            ch = ((String)this.value).toCharArray();
                            sbuf = new StringBuffer(80);
                            n = 0;
                            while (n < ch.length) {
                                sbuf.append(ch[n]);
                                if (ch[n] == '\'') {
                                    sbuf.append('\'');
                                }
                                ++n;
                            }
                        }
                        while (sbuf.length() < 8) {
                            sbuf.append(" ");
                        }
                        sbuf.insert(0, '\'');
                        sbuf.append('\'');
                        val = sbuf.toString();
                    }
                    catch (Exception sbuf) {}
                    break;
                }
                case 4: {
                    val = ((Integer)this.value).toString();
                    break;
                }
                case 5: {
                    val = ((Double)this.value).toString();
                    break;
                }
                case 3: {
                    if (((Boolean)this.value).booleanValue()) {
                        val = "T";
                        break;
                    }
                    val = "F";
                    break;
                }
                case 6: {
                    dateFormat = FitsKeyword.ISOLONG;
                    dateFormat.setTimeZone(FitsKeyword.TIMEZONE);
                    df = new StringBuffer("'" + dateFormat.format((Date)this.value, new StringBuffer(), new FieldPosition(0)) + "'");
                    val = df.toString();
                    break;
                }
                case 1: {
                    card.append(this.comment);
                }
            }
            if (this.type != 1) {
                card.append("= ");
                idx = val.length();
                if (card.length() < 11 && this.type != 2) {
                    while (idx++ < 20) {
                        card.append(" ");
                    }
                }
                card.append(val);
                this.valueTruncated = false;
                idx = card.length();
                if (80 < idx) {
                    card.setCharAt(79, '\'');
                    this.valueTruncated = true;
                }
                while (idx++ < 30) {
                    card.append(" ");
                }
                card.append(" / " + this.comment);
            }
            if (80 >= (idx = card.length())) ** GOTO lbl97
            card.setLength(80);
            break block26;
lbl-1000:
            // 1 sources

            {
                card.append(" ");
lbl97:
                // 2 sources

                ** while (idx++ < 80)
            }
        }
        return card.toString();
    }

    public boolean isValueTruncated() {
        return this.valueTruncated;
    }

    public boolean isEmpty() {
        return this.name.length() < 1 && this.comment.length() < 1 && this.value == null;
    }

    public boolean isModified() {
        return !this.validCard;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name.toUpperCase();
    }

    public int getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment == null ? "" : comment;
    }
}

