/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import java.util.StringTokenizer;

public class FitsTform {
    private char dataType = '\u0000';
    private String format;
    private char eFormat = '\u0000';
    private int repeat = 1;
    private int width = 0;
    private int decimals = 0;
    private int exponent = 0;
    private String additional = "";

    public FitsTform(String form) throws FitsException {
        int idx;
        char ch;
        String tok = "";
        this.format = form.toUpperCase();
        StringTokenizer stok = new StringTokenizer(this.format, "LXBIJAFEDCMP.OZNSG", true);
        if (stok.hasMoreTokens()) {
            tok = stok.nextToken();
            if (Character.isDigit(tok.charAt(0))) {
                try {
                    this.repeat = Integer.valueOf(tok);
                }
                catch (NumberFormatException e) {
                    throw new FitsException("Wrong TFORM format", 4);
                }
                if (stok.hasMoreTokens()) {
                    tok = stok.nextToken();
                }
            }
            if (Character.isLetter(ch = tok.charAt(0))) {
                this.dataType = ch;
            } else {
                throw new FitsException("Wrong TFORM format", 4);
            }
        }
        if ((idx = this.format.indexOf(this.dataType) + 1) < this.format.length()) {
            this.additional = this.format.substring(idx);
        }
        if (this.dataType != 'P') {
            while (stok.hasMoreTokens()) {
                tok = stok.nextToken();
                ch = tok.charAt(0);
                if (Character.isDigit(ch)) break;
                if (this.eFormat != '\u0000') continue;
                this.eFormat = ch;
            }
            if (Character.isDigit(tok.charAt(0))) {
                try {
                    this.width = Integer.valueOf(tok);
                }
                catch (NumberFormatException e) {
                    throw new FitsException("Wrong TFORM format", 4);
                }
            } else {
                switch (this.dataType) {
                    case 'A': 
                    case 'B': 
                    case 'L': {
                        this.width = 1;
                        break;
                    }
                    case 'X': {
                        this.width = this.repeat > 0 ? (this.repeat - 1) % 8 + 1 : 0;
                        break;
                    }
                    case 'I': {
                        this.width = 2;
                        break;
                    }
                    case 'E': 
                    case 'J': {
                        this.width = 4;
                        break;
                    }
                    case 'C': 
                    case 'D': 
                    case 'P': {
                        this.width = 8;
                        break;
                    }
                    case 'M': {
                        this.width = 16;
                        break;
                    }
                    default: {
                        throw new FitsException("Wrong TFORM format", 4);
                    }
                }
            }
            if (stok.hasMoreTokens()) {
                tok = stok.nextToken();
                if (tok.charAt(0) == '.') {
                    if (stok.hasMoreTokens()) {
                        tok = stok.nextToken();
                    }
                    try {
                        this.decimals = Integer.valueOf(tok);
                    }
                    catch (NumberFormatException e) {
                        throw new FitsException("Wrong TFORM format", 4);
                    }
                } else {
                    throw new FitsException("Wrong TFORM format", 4);
                }
                if (stok.hasMoreTokens()) {
                    tok = stok.nextToken();
                    if (tok.charAt(0) == 'E') {
                        if (stok.hasMoreTokens()) {
                            tok = stok.nextToken();
                        }
                        try {
                            this.decimals = Integer.valueOf(tok);
                        }
                        catch (NumberFormatException e) {
                            throw new FitsException("Wrong TFORM format", 4);
                        }
                    } else {
                        throw new FitsException("Wrong TFORM format", 4);
                    }
                }
            }
        }
    }

    public String getFormat() {
        return this.format;
    }

    public char getDataType() {
        return this.dataType;
    }

    public char getEFormat() {
        return this.eFormat;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getExponent() {
        return this.exponent;
    }

    public String getAdditional() {
        return this.additional;
    }
}

