/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import de.andreasroerig.bild.RGBBild;
import de.andreasroerig.gui.GuiHelper;
import de.andreasroerig.gui.ImageFrame;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class MultChannelsDialog
extends JDialog
implements ActionListener,
ChangeListener,
InternalFrameListener {
    private JSlider jslRed;
    private JSlider jslGreen;
    private JSlider jslBlue;
    private TextField tfRed;
    private TextField tfGreen;
    private TextField tfBlue;
    private JFrame theOwner;
    private Button btnPreview;
    private RGBBild tmpBild;
    private RGBBild originalBild;
    private ImageFrame theFrame;
    private double fktRed;
    private double fktGreen;
    private double fktBlue;
    private double maxFkt;
    private double minFkt;
    private boolean okPressed;
    private boolean previewPressed = false;

    public MultChannelsDialog(JFrame owner, RGBBild original, ImageFrame tmpfr) {
        super(owner, "Multiply Channels", true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
        Point p = GuiHelper.getFrameCenter(owner);
        this.setBounds(p.x - 150, p.y - 150, 300, 300);
        this.theOwner = owner;
        this.fktBlue = 1.0;
        this.fktGreen = 1.0;
        this.fktRed = 1.0;
        this.maxFkt = 5.0;
        this.minFkt = 0.0;
        Panel center = new Panel();
        Panel east = new Panel();
        Panel west = new Panel();
        center.setLayout(new GridLayout(3, 1));
        east.setLayout(new GridLayout(3, 1));
        west.setLayout(new GridLayout(3, 1));
        this.jslRed = new JSlider();
        this.jslGreen = new JSlider();
        this.jslBlue = new JSlider();
        this.jslRed.setMajorTickSpacing(10);
        this.jslGreen.setMajorTickSpacing(10);
        this.jslBlue.setMajorTickSpacing(10);
        this.jslRed.setMinorTickSpacing(1);
        this.jslGreen.setMinorTickSpacing(1);
        this.jslBlue.setMinorTickSpacing(1);
        this.jslRed.setPaintTicks(true);
        this.jslGreen.setPaintTicks(true);
        this.jslBlue.setPaintTicks(true);
        this.tfRed = new TextField(5);
        this.tfRed.setText("" + this.fktRed);
        this.tfGreen = new TextField(5);
        this.tfGreen.setText("" + this.fktGreen);
        this.tfBlue = new TextField(5);
        this.tfBlue.setText("" + this.fktBlue);
        west.add(new Label("Red"));
        center.add(this.jslRed);
        east.add(this.tfRed);
        west.add(new Label("Green"));
        center.add(this.jslGreen);
        east.add(this.tfGreen);
        west.add(new Label("Blue"));
        center.add(this.jslBlue);
        east.add(this.tfBlue);
        Panel south = new Panel();
        Button btnOk = new Button("Ok");
        Button btnCancel = new Button("Cancel");
        south.add(btnOk);
        south.add(btnCancel);
        Panel north = new Panel();
        this.btnPreview = new Button("Preview");
        north.add(this.btnPreview);
        this.getContentPane().add((Component)west, "West");
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)east, "East");
        this.getContentPane().add((Component)south, "South");
        this.getContentPane().add((Component)north, "North");
        btnOk.addActionListener(this);
        btnCancel.addActionListener(this);
        this.btnPreview.addActionListener(this);
        this.jslRed.setValue(20);
        this.jslGreen.setValue(20);
        this.jslBlue.setValue(20);
        this.jslRed.addChangeListener(this);
        this.jslGreen.addChangeListener(this);
        this.jslBlue.addChangeListener(this);
        this.pack();
        this.originalBild = original;
        this.tmpBild = (RGBBild)tmpfr.getTheBild();
        this.theFrame = tmpfr;
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equalsIgnoreCase("Ok")) {
            System.out.println("OK gedrueckt!");
            this.okPressed = true;
            if (!this.previewPressed) {
                this.preview_Action();
            }
            this.setVisible(false);
            this.dispose();
        }
        if (event.getActionCommand().equalsIgnoreCase("Preview")) {
            System.out.println("Preview gedrueckt!");
            this.preview_Action();
        }
        if (event.getActionCommand().equalsIgnoreCase("Cancel")) {
            this.okPressed = false;
            System.out.println("Cancel gedrueckt!");
            this.setVisible(false);
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent event) {
        int iVal;
        if (event.getSource() == this.jslRed) {
            iVal = this.jslRed.getValue();
            this.fktRed = (this.maxFkt - this.minFkt) / 100.0 * (double)iVal;
            System.out.println("Red changed! " + this.fktRed);
            this.tfRed.setText("" + this.fktRed);
        }
        if (event.getSource() == this.jslGreen) {
            iVal = this.jslGreen.getValue();
            this.fktGreen = (this.maxFkt - this.minFkt) / 100.0 * (double)iVal;
            System.out.println("Green changed! " + this.fktGreen);
            this.tfGreen.setText("" + this.fktGreen);
        }
        if (event.getSource() == this.jslBlue) {
            iVal = this.jslBlue.getValue();
            this.fktBlue = (this.maxFkt - this.minFkt) / 100.0 * (double)iVal;
            System.out.println("Blue changed! " + this.fktBlue);
            this.tfBlue.setText("" + this.fktBlue);
        }
    }

    private void preview_Action() {
        String tmp = this.tfRed.getText();
        this.fktRed = Double.parseDouble(tmp);
        tmp = this.tfGreen.getText();
        this.fktGreen = Double.parseDouble(tmp);
        tmp = this.tfBlue.getText();
        this.fktBlue = Double.parseDouble(tmp);
        this.tmpBild.chnlMultiplikation(this.originalBild, this.fktRed, this.fktGreen, this.fktBlue);
        this.theFrame.refreshImage(this.theFrame.getBlackPt(), this.theFrame.getWhitePt());
        this.previewPressed = true;
    }

    public void internalFrameClosed(InternalFrameEvent event) {
        System.out.println("windowClosed() " + event.getInternalFrame().getName());
    }

    public void internalFrameClosing(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        System.out.println("windowClosing() " + winName);
    }

    public void internalFrameOpened(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        System.out.println("windowOpened() " + winName);
    }

    public void internalFrameDeactivated(InternalFrameEvent event) {
        System.out.println("windowDeactivated()");
    }

    public void internalFrameDeiconified(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        System.out.println("windowDeiconified() " + winName);
    }

    public void internalFrameIconified(InternalFrameEvent event) {
        System.out.println("windowIconified()");
    }

    public void internalFrameActivated(InternalFrameEvent event) {
        String winName = event.getInternalFrame().getName();
        System.out.println("windowActivated() " + winName);
    }

    public boolean getOkPressed() {
        return this.okPressed;
    }
}

