/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import de.andreasroerig.gui.GuiHelper;
import de.andreasroerig.gui.MsgBox;
import de.andreasroerig.gui.SpringUtilities;
import de.andreasroerig.util.RegParams;
import de.andreasroerig.util.SLogger;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import regim.FrameVector;

public class RegisterDialog
extends JDialog
implements ActionListener {
    private JComboBox master;
    private JList theList;
    private int masterIdx;
    private int[] regIdx;
    private JCheckBox scale1;
    private JCheckBox bicubicInterpol;
    private JComboBox cMaxNumstars;
    private JComboBox cTransformMode;
    private JComboBox cStarMinBrightness;
    private JComboBox cStarMaxBrightness;
    private RegParams theParams;

    public RegisterDialog(Frame owner, FrameVector fv) {
        super(owner, "Register", true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.theParams = RegParams.instance();
        Point p = GuiHelper.getFrameCenter(owner);
        this.setBounds(p.x - 200, p.y - 150, 400, 300);
        this.move(20, 20);
        String[] names = new String[fv.size()];
        int i = 0;
        while (i < fv.size()) {
            names[i] = fv.getFrameAt(i).getName();
            ++i;
        }
        this.buildGUI(names);
        this.pack();
        this.setVisible(true);
    }

    public RegisterDialog(Frame owner, File[] files, int numFrames) {
        super(owner, "Register", true);
        this.theParams = RegParams.instance();
        String[] names = new String[numFrames];
        int i = 0;
        while (i < numFrames) {
            names[i] = files[i].getName();
            ++i;
        }
        this.buildGUI(names);
        this.theList.setEnabled(false);
        this.pack();
        this.setVisible(true);
    }

    private void buildGUI(String[] names) {
        JPanel north = new JPanel();
        north.setLayout(new GridLayout(1, 4, 15, 15));
        JPanel n1 = new JPanel();
        JPanel n2 = new JPanel();
        JLabel l1 = new JLabel("Master Frame:");
        l1.setHorizontalAlignment(2);
        n1.add(l1);
        north.add(n1);
        this.master = new JComboBox<String>(names);
        this.master.setMaximumRowCount(25);
        n2.add(this.master);
        north.add(n2);
        JPanel n3 = new JPanel();
        JPanel n4 = new JPanel();
        JLabel l2 = new JLabel("Images to register:");
        int listlen = names.length <= 25 ? names.length + 1 : 25;
        this.theList = new JList<String>(names);
        this.theList.setVisibleRowCount(listlen);
        n3.add(l2);
        north.add(n3);
        n4.setLayout(new BoxLayout(n4, 0));
        n4.add(this.theList);
        north.add(n4);
        JPanel center = new JPanel();
        center.setLayout(new SpringLayout());
        JLabel l3 = new JLabel("Number of stars:");
        this.cMaxNumstars = new JComboBox();
        this.cMaxNumstars.addItem("50");
        this.cMaxNumstars.addItem("75");
        this.cMaxNumstars.addItem("100");
        this.cMaxNumstars.addItem("150");
        this.cMaxNumstars.addItem("300");
        this.cMaxNumstars.setSelectedItem("" + this.theParams.getMaxNumStars());
        center.add(l3);
        center.add(this.cMaxNumstars);
        JLabel l4 = new JLabel("Transform mode:");
        this.cTransformMode = new JComboBox();
        this.cTransformMode.addItem("Linear");
        this.cTransformMode.setSelectedItem("Linear");
        center.add(l4);
        center.add(this.cTransformMode);
        JLabel l5 = new JLabel("Star min. brightness:");
        this.cStarMinBrightness = new JComboBox();
        this.cStarMinBrightness.addItem("0.0125");
        this.cStarMinBrightness.addItem("0.025");
        this.cStarMinBrightness.addItem("0.05");
        this.cStarMinBrightness.addItem("0.1");
        this.cStarMinBrightness.addItem("0.2");
        this.cStarMinBrightness.addItem("0.3");
        this.cStarMinBrightness.addItem("0.4");
        this.cStarMinBrightness.addItem("0.5");
        this.cStarMinBrightness.addItem("0.6");
        this.cStarMinBrightness.addItem("0.7");
        this.cStarMinBrightness.addItem("0.8");
        this.cStarMinBrightness.addItem("0.9");
        center.add(l5);
        this.cStarMinBrightness.setSelectedItem("" + this.theParams.getMinBrighnessRatio());
        center.add(this.cStarMinBrightness);
        this.scale1 = new JCheckBox("Same scale", this.theParams.getSameScale());
        center.add(this.scale1);
        center.add(new JLabel(""));
        JLabel lsbmx = new JLabel("Star max. brightness:");
        center.add(lsbmx);
        this.cStarMaxBrightness = new JComboBox();
        this.cStarMaxBrightness.addItem("0.5");
        this.cStarMaxBrightness.addItem("0.6");
        this.cStarMaxBrightness.addItem("0.7");
        this.cStarMaxBrightness.addItem("0.8");
        this.cStarMaxBrightness.addItem("0.9");
        this.cStarMaxBrightness.addItem("1.0");
        this.cStarMaxBrightness.setSelectedItem("" + this.theParams.getMaxBrighnessRatio());
        center.add(this.cStarMaxBrightness);
        this.bicubicInterpol = new JCheckBox("bicubic Interpolation", this.theParams.getBicubicInterpol());
        center.add(this.bicubicInterpol);
        center.add(new JLabel(""));
        SpringUtilities.makeCompactGrid(center, 3, 4, 3, 3, 9, 7);
        JPanel south = new JPanel();
        JButton btnOk = new JButton("Register");
        JButton btnCancel = new JButton("Cancel");
        south.add(btnOk);
        south.add(btnCancel);
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)south, "South");
        btnOk.addActionListener(this);
        btnCancel.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equalsIgnoreCase("Register")) {
            SLogger.debug("OK gedrueckt!");
            this.masterIdx = this.master.getSelectedIndex();
            this.regIdx = this.theList.getSelectedIndices();
            if (this.theList.isEnabled() && (this.regIdx == null || this.regIdx.length == 0)) {
                new MsgBox(this, "Attention", "You must select at least one image to register", true);
                return;
            }
            SLogger.debug("masterIdx=" + this.masterIdx);
            int n = Integer.parseInt((String)this.cMaxNumstars.getSelectedItem());
            this.theParams.setMaxNumStars(n);
            n = this.cTransformMode.getSelectedIndex();
            this.theParams.setTransformMode(n);
            double min = Double.parseDouble((String)this.cStarMinBrightness.getSelectedItem());
            double max = Double.parseDouble((String)this.cStarMaxBrightness.getSelectedItem());
            if (min >= max) {
                new MsgBox(this, "Attention", "Max brightness must be greater than min brightness", true);
                return;
            }
            this.theParams.setMinBrighnessRatio(min);
            this.theParams.setMaxBrighnessRatio(max);
            this.theParams.setSameScale(this.scale1.isSelected());
            this.theParams.setBicubicInterpol(this.bicubicInterpol.isSelected());
        }
        if (event.getActionCommand().equalsIgnoreCase("Cancel")) {
            SLogger.debug("Cancel gedrueckt!");
            this.regIdx = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    public int getMasterIdx() {
        return this.masterIdx;
    }

    public int[] getRegIdx() {
        return this.regIdx;
    }
}

