/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Utils;
import java.awt.Color;
import java.io.Serializable;

public class Gene
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 700L;
    private double _length = 0.0;
    private double _theta = 0.0;
    private Color _color;

    public Gene() {
    }

    public Gene(double length, double theta, Color color) {
        this._length = length;
        this._theta = theta;
        this._color = color;
    }

    public void randomizeColor() {
        int ac_prob;
        int max_prob = Utils.RED_PROB + Utils.GREEN_PROB + Utils.BLUE_PROB + Utils.CYAN_PROB + Utils.WHITE_PROB + Utils.GRAY_PROB + Utils.YELLOW_PROB;
        int prob = Utils.random.nextInt(max_prob);
        if (prob < (ac_prob = Utils.RED_PROB)) {
            this._color = Color.RED;
            return;
        }
        if (prob < (ac_prob += Utils.GREEN_PROB)) {
            this._color = Color.GREEN;
            return;
        }
        if (prob < (ac_prob += Utils.BLUE_PROB)) {
            this._color = Color.BLUE;
            return;
        }
        if (prob < (ac_prob += Utils.CYAN_PROB)) {
            this._color = Color.CYAN;
            return;
        }
        if (prob < (ac_prob += Utils.WHITE_PROB)) {
            this._color = Color.WHITE;
            return;
        }
        if (prob < (ac_prob += Utils.GRAY_PROB)) {
            this._color = Color.GRAY;
            return;
        }
        this._color = Color.YELLOW;
    }

    public void randomizeLength() {
        this._length = 2.0 + Utils.random.nextDouble() * 16.0;
    }

    public void randomizeTheta() {
        this._theta = Utils.random.nextDouble() * 2.0 * Math.PI;
    }

    public void randomize() {
        this.randomizeLength();
        this.randomizeTheta();
        this.randomizeColor();
    }

    public Object clone() {
        Gene newGen = null;
        try {
            newGen = (Gene)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newGen;
    }

    public double getLength() {
        return this._length;
    }

    public double getTheta() {
        return this._theta;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void setLength(double length) {
        this._length = length;
    }

    public void setTheta(double theta) {
        this._theta = theta;
    }
}

