/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class InvertingSchmittElm
extends CircuitElm {
    double slewRate;
    double lowerTrigger;
    double upperTrigger;
    boolean state;
    Polygon gatePoly;
    Polygon symbolPoly;
    Point pcircle;
    double dlt;
    double dut;

    public InvertingSchmittElm(int n, int n2) {
        super(n, n2);
        this.noDiagonal = true;
        this.slewRate = 0.5;
        this.state = false;
        this.lowerTrigger = 1.66;
        this.upperTrigger = 3.33;
    }

    public InvertingSchmittElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.noDiagonal = true;
        try {
            this.slewRate = new Double(stringTokenizer.nextToken());
            this.lowerTrigger = new Double(stringTokenizer.nextToken());
            this.upperTrigger = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.slewRate = 0.5;
            this.lowerTrigger = 1.66;
            this.upperTrigger = 3.33;
        }
    }

    String dump() {
        return super.dump() + " " + this.slewRate + " " + this.lowerTrigger + " " + this.upperTrigger;
    }

    int getDumpType() {
        return 183;
    }

    void draw(Graphics graphics) {
        this.drawPosts(graphics);
        this.draw2Leads(graphics);
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        InvertingSchmittElm.drawThickPolygon(graphics, this.gatePoly);
        InvertingSchmittElm.drawThickPolygon(graphics, this.symbolPoly);
        InvertingSchmittElm.drawThickCircle(graphics, this.pcircle.x, this.pcircle.y, 3);
        this.curcount = this.updateDotCount(this.current, this.curcount);
        this.drawDots(graphics, this.lead2, this.point2, this.curcount);
    }

    void setPoints() {
        super.setPoints();
        int n = 16;
        int n2 = 16;
        if ((double)n2 > this.dn / 2.0) {
            n2 = (int)(this.dn / 2.0);
        }
        this.lead1 = this.interpPoint(this.point1, this.point2, 0.5 - (double)n2 / this.dn);
        this.lead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 + 2) / this.dn);
        this.pcircle = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 2) / this.dn);
        Point[] pointArray = this.newPointArray(3);
        Point[] pointArray2 = this.newPointArray(6);
        Point point = new Point(0, 0);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, n);
        pointArray[2] = this.interpPoint(this.point1, this.point2, 0.5 + (double)(n2 - 5) / this.dn);
        this.interpPoint2(this.lead1, this.lead2, pointArray2[5], pointArray2[4], 0.2, n / 4);
        this.interpPoint2(this.lead1, this.lead2, pointArray2[1], pointArray2[2], 0.35, n / 4);
        this.interpPoint2(this.lead1, this.lead2, pointArray2[0], point, 0.1, n / 4);
        this.interpPoint2(this.lead1, this.lead2, point, pointArray2[3], 0.45, n / 4);
        this.gatePoly = this.createPolygon(pointArray);
        this.symbolPoly = this.createPolygon(pointArray2);
        this.setBbox(this.point1, this.point2, n);
    }

    int getVoltageSourceCount() {
        return 1;
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[1], this.voltSource);
    }

    void doStep() {
        double d;
        double d2 = this.volts[1];
        if (this.state) {
            if (this.volts[0] > this.upperTrigger) {
                this.state = false;
                d = 0.0;
            } else {
                d = 5.0;
            }
        } else if (this.volts[0] < this.lowerTrigger) {
            this.state = true;
            d = 5.0;
        } else {
            d = 0.0;
        }
        double d3 = this.slewRate * InvertingSchmittElm.sim.timeStep * 1.0E9;
        d = Math.max(Math.min(d2 + d3, d), d2 - d3);
        sim.updateVoltageSource(0, this.nodes[1], this.voltSource, d);
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "InvertingSchmitt";
        stringArray[1] = "Vi = " + InvertingSchmittElm.getVoltageText(this.volts[0]);
        stringArray[2] = "Vo = " + InvertingSchmittElm.getVoltageText(this.volts[1]);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            this.dlt = this.lowerTrigger;
            return new EditInfo("Lower threshold (V)", this.lowerTrigger, 0.01, 5.0);
        }
        if (n == 1) {
            this.dut = this.upperTrigger;
            return new EditInfo("Upper threshold (V)", this.upperTrigger, 0.01, 5.0);
        }
        if (n == 2) {
            return new EditInfo("Slew Rate (V/ns)", this.slewRate, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.dlt = editInfo.value;
        }
        if (n == 1) {
            this.dut = editInfo.value;
        }
        if (n == 2) {
            this.slewRate = editInfo.value;
        }
        if (this.dlt > this.dut) {
            this.upperTrigger = this.dlt;
            this.lowerTrigger = this.dut;
        } else {
            this.upperTrigger = this.dut;
            this.lowerTrigger = this.dlt;
        }
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    boolean hasGroundConnection(int n) {
        return n == 1;
    }
}

