/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.util.StringTokenizer;

class MonostableElm
extends ChipElm {
    private boolean prevInputValue = false;
    private boolean retriggerable = false;
    private boolean triggered = false;
    private double lastRisingEdge = 0.0;
    private double delay = 0.01;

    public MonostableElm(int n, int n2) {
        super(n, n2);
    }

    public MonostableElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.retriggerable = new Boolean(stringTokenizer.nextToken());
        this.delay = new Double(stringTokenizer.nextToken());
    }

    String getChipName() {
        return "Monostable";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(0, 2, "");
        this.pins[0].clock = true;
        this.pins[1] = new ChipElm.Pin(0, 3, "Q");
        this.pins[1].output = true;
        this.pins[2] = new ChipElm.Pin(1, 3, "Q");
        this.pins[2].output = true;
        this.pins[2].lineOver = true;
    }

    int getPostCount() {
        return 3;
    }

    int getVoltageSourceCount() {
        return 2;
    }

    void execute() {
        if (this.pins[0].value && this.prevInputValue != this.pins[0].value && (this.retriggerable || !this.triggered)) {
            this.lastRisingEdge = MonostableElm.sim.t;
            this.pins[1].value = true;
            this.pins[2].value = false;
            this.triggered = true;
        }
        if (this.triggered && MonostableElm.sim.t > this.lastRisingEdge + this.delay) {
            this.pins[1].value = false;
            this.pins[2].value = true;
            this.triggered = false;
        }
        this.prevInputValue = this.pins[0].value;
    }

    String dump() {
        return super.dump() + " " + this.retriggerable + " " + this.delay;
    }

    int getDumpType() {
        return 194;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Retriggerable", this.retriggerable);
            return editInfo;
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("Period (s)", this.delay, 0.001, 0.1);
            return editInfo;
        }
        return super.getEditInfo(n);
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 2) {
            this.retriggerable = editInfo.checkbox.getState();
        }
        if (n == 3) {
            this.delay = editInfo.value;
        }
        super.setEditValue(n, editInfo);
    }
}

