/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class SCRElm
extends CircuitElm {
    final int anode = 0;
    final int cnode = 1;
    final int gnode = 2;
    final int inode = 3;
    Diode diode;
    double ia;
    double ic;
    double ig;
    double curcount_a;
    double curcount_c;
    double curcount_g;
    double lastvac;
    double lastvag;
    double cresistance;
    double triggerI;
    double holdingI;
    final int hs = 8;
    Polygon poly;
    Point[] cathode;
    Point[] gate;
    double aresistance;

    public SCRElm(int n, int n2) {
        super(n, n2);
        this.setDefaults();
        this.setup();
    }

    public SCRElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.setDefaults();
        try {
            this.lastvac = new Double(stringTokenizer.nextToken());
            this.lastvag = new Double(stringTokenizer.nextToken());
            this.volts[0] = 0.0;
            this.volts[1] = -this.lastvac;
            this.volts[2] = -this.lastvag;
            this.triggerI = new Double(stringTokenizer.nextToken());
            this.holdingI = new Double(stringTokenizer.nextToken());
            this.cresistance = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setup();
    }

    void setDefaults() {
        this.cresistance = 50.0;
        this.holdingI = 0.0082;
        this.triggerI = 0.01;
    }

    void setup() {
        this.diode = new Diode(sim);
        this.diode.setup(0.8, 0.0);
    }

    boolean nonLinear() {
        return true;
    }

    void reset() {
        this.volts[2] = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.diode.reset();
        this.curcount_g = 0.0;
        this.curcount_c = 0.0;
        this.curcount_a = 0.0;
        this.lastvac = 0.0;
        this.lastvag = 0.0;
    }

    int getDumpType() {
        return 177;
    }

    String dump() {
        return super.dump() + " " + (this.volts[0] - this.volts[1]) + " " + (this.volts[0] - this.volts[2]) + " " + this.triggerI + " " + this.holdingI + " " + this.cresistance;
    }

    void setPoints() {
        super.setPoints();
        int n = 0;
        if (SCRElm.abs(this.dx) > SCRElm.abs(this.dy)) {
            n = -SCRElm.sign(this.dx) * SCRElm.sign(this.dy);
            this.point2.y = this.point1.y;
        } else {
            n = SCRElm.sign(this.dy) * SCRElm.sign(this.dx);
            this.point2.x = this.point1.x;
        }
        if (n == 0) {
            n = 1;
        }
        this.calcLeads(16);
        this.cathode = this.newPointArray(2);
        Point[] pointArray = this.newPointArray(2);
        this.interpPoint2(this.lead1, this.lead2, pointArray[0], pointArray[1], 0.0, 8.0);
        this.interpPoint2(this.lead1, this.lead2, this.cathode[0], this.cathode[1], 1.0, 8.0);
        this.poly = this.createPolygon(pointArray[0], pointArray[1], this.lead2);
        this.gate = this.newPointArray(2);
        double d = (this.dn - 16.0) / 2.0;
        int n2 = SCRElm.sim.gridSize;
        n2 = (int)((double)n2 + d % (double)SCRElm.sim.gridSize);
        if (d < (double)n2) {
            this.x2 = this.x;
            this.y2 = this.y;
            return;
        }
        this.interpPoint(this.lead2, this.point2, this.gate[0], (double)n2 / d, n2 * n);
        this.interpPoint(this.lead2, this.point2, this.gate[1], (double)n2 / d, SCRElm.sim.gridSize * 2 * n);
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 8.0);
        this.adjustBbox(this.gate[0], this.gate[1]);
        double d = this.volts[0];
        double d2 = this.volts[1];
        this.draw2Leads(graphics);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, d);
        graphics.fillPolygon(this.poly);
        this.setVoltageColor(graphics, d2);
        SCRElm.drawThickLine(graphics, this.cathode[0], this.cathode[1]);
        SCRElm.drawThickLine(graphics, this.lead2, this.gate[0]);
        SCRElm.drawThickLine(graphics, this.gate[0], this.gate[1]);
        this.curcount_a = this.updateDotCount(this.ia, this.curcount_a);
        this.curcount_c = this.updateDotCount(this.ic, this.curcount_c);
        this.curcount_g = this.updateDotCount(this.ig, this.curcount_g);
        if (SCRElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.lead2, this.curcount_a);
            this.drawDots(graphics, this.point2, this.lead2, this.curcount_c);
            this.drawDots(graphics, this.gate[1], this.gate[0], this.curcount_g);
            this.drawDots(graphics, this.gate[0], this.lead2, this.curcount_g + SCRElm.distance(this.gate[1], this.gate[0]));
        }
        this.drawPosts(graphics);
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 1 ? this.point2 : this.gate[1]);
    }

    int getPostCount() {
        return 3;
    }

    int getInternalNodeCount() {
        return 1;
    }

    double getPower() {
        return (this.volts[0] - this.volts[2]) * this.ia + (this.volts[1] - this.volts[2]) * this.ic;
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
        sim.stampNonLinear(this.nodes[2]);
        sim.stampNonLinear(this.nodes[3]);
        sim.stampResistor(this.nodes[2], this.nodes[1], this.cresistance);
        this.diode.stamp(this.nodes[3], this.nodes[2]);
    }

    void doStep() {
        double d = this.volts[0] - this.volts[1];
        double d2 = this.volts[0] - this.volts[2];
        if (Math.abs(d - this.lastvac) > 0.01 || Math.abs(d2 - this.lastvag) > 0.01) {
            SCRElm.sim.converged = false;
        }
        this.lastvac = d;
        this.lastvag = d2;
        this.diode.doStep(this.volts[3] - this.volts[2]);
        double d3 = 1.0 / this.triggerI;
        double d4 = 1.0 / this.holdingI - d3;
        this.aresistance = -d3 * this.ic + this.ia * d4 > 1.0 ? 0.0105 : 1000000.0;
        sim.stampResistor(this.nodes[0], this.nodes[3], this.aresistance);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "SCR";
        double d = this.volts[0] - this.volts[1];
        double d2 = this.volts[0] - this.volts[2];
        double d3 = this.volts[2] - this.volts[1];
        stringArray[1] = "Ia = " + SCRElm.getCurrentText(this.ia);
        stringArray[2] = "Ig = " + SCRElm.getCurrentText(this.ig);
        stringArray[3] = "Vac = " + SCRElm.getVoltageText(d);
        stringArray[4] = "Vag = " + SCRElm.getVoltageText(d2);
        stringArray[5] = "Vgc = " + SCRElm.getVoltageText(d3);
    }

    void calculateCurrent() {
        this.ic = (this.volts[1] - this.volts[2]) / this.cresistance;
        this.ia = (this.volts[0] - this.volts[3]) / this.aresistance;
        this.ig = -this.ic - this.ia;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Trigger Current (A)", this.triggerI, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Holding Current (A)", this.holdingI, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Gate-Cathode Resistance (ohms)", this.cresistance, 0.0, 0.0);
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0 && editInfo.value > 0.0) {
            this.triggerI = editInfo.value;
        }
        if (n == 1 && editInfo.value > 0.0) {
            this.holdingI = editInfo.value;
        }
        if (n == 2 && editInfo.value > 0.0) {
            this.cresistance = editInfo.value;
        }
    }
}

