/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class SRAMElm
extends ChipElm {
    short[] data = new short[256];

    public SRAMElm(int n, int n2) {
        super(n, n2);
        for (int n3 = 0; n3 < 256; n3 = (int)((short)(n3 + 1))) {
            this.data[n3] = 0;
        }
    }

    public SRAMElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        for (int n6 = 0; n6 < 256; n6 = (int)((short)(n6 + 1))) {
            this.data[n6] = 0;
        }
    }

    String getChipName() {
        return "SRAM";
    }

    void setupPins() {
        this.sizeX = 4;
        this.sizeY = 9;
        this.pins = new ChipElm.Pin[19];
        this.pins[0] = new ChipElm.Pin(0, 2, "A7");
        this.pins[1] = new ChipElm.Pin(1, 2, "A6");
        this.pins[2] = new ChipElm.Pin(2, 2, "A5");
        this.pins[3] = new ChipElm.Pin(3, 2, "A4");
        this.pins[4] = new ChipElm.Pin(4, 2, "A3");
        this.pins[5] = new ChipElm.Pin(5, 2, "A2");
        this.pins[6] = new ChipElm.Pin(6, 2, "A1");
        this.pins[7] = new ChipElm.Pin(7, 2, "A0");
        this.pins[8] = new ChipElm.Pin(8, 2, "R");
        this.pins[9] = new ChipElm.Pin(8, 3, "W");
        this.pins[10] = new ChipElm.Pin(0, 3, "D7");
        this.pins[11] = new ChipElm.Pin(1, 3, "D6");
        this.pins[12] = new ChipElm.Pin(2, 3, "D5");
        this.pins[13] = new ChipElm.Pin(3, 3, "D4");
        this.pins[14] = new ChipElm.Pin(4, 3, "D3");
        this.pins[15] = new ChipElm.Pin(5, 3, "D2");
        this.pins[16] = new ChipElm.Pin(6, 3, "D1");
        this.pins[17] = new ChipElm.Pin(7, 3, "D0");
        this.pins[10].output = true;
        this.pins[11].output = true;
        this.pins[12].output = true;
        this.pins[13].output = true;
        this.pins[14].output = true;
        this.pins[15].output = true;
        this.pins[16].output = true;
        this.pins[17].output = true;
    }

    int getPostCount() {
        return 18;
    }

    int getVoltageSourceCount() {
        return 8;
    }

    void execute() {
        int n = 0;
        if (this.pins[8].value || this.pins[9].value) {
            if (this.pins[0].value) {
                n = (short)(n + 128);
            }
            if (this.pins[1].value) {
                n = (short)(n + 64);
            }
            if (this.pins[2].value) {
                n = (short)(n + 32);
            }
            if (this.pins[3].value) {
                n = (short)(n + 16);
            }
            if (this.pins[4].value) {
                n = (short)(n + 8);
            }
            if (this.pins[5].value) {
                n = (short)(n + 4);
            }
            if (this.pins[6].value) {
                n = (short)(n + 2);
            }
            if (this.pins[7].value) {
                n = (short)(n + 1);
            }
            if (this.pins[8].value) {
                this.pins[10].value = (this.data[n] & 0x80) > 0;
                this.pins[11].value = (this.data[n] & 0x40) > 0;
                this.pins[12].value = (this.data[n] & 0x20) > 0;
                this.pins[13].value = (this.data[n] & 0x10) > 0;
                this.pins[14].value = (this.data[n] & 8) > 0;
                this.pins[15].value = (this.data[n] & 4) > 0;
                this.pins[16].value = (this.data[n] & 2) > 0;
                this.pins[17].value = (this.data[n] & 1) > 0;
            } else {
                this.data[n] = 0;
                if (this.pins[10].value) {
                    int n2 = n;
                    this.data[n2] = (short)(this.data[n2] + 128);
                }
                if (this.pins[11].value) {
                    int n3 = n;
                    this.data[n3] = (short)(this.data[n3] + 64);
                }
                if (this.pins[12].value) {
                    int n4 = n;
                    this.data[n4] = (short)(this.data[n4] + 32);
                }
                if (this.pins[13].value) {
                    int n5 = n;
                    this.data[n5] = (short)(this.data[n5] + 16);
                }
                if (this.pins[14].value) {
                    int n6 = n;
                    this.data[n6] = (short)(this.data[n6] + 8);
                }
                if (this.pins[15].value) {
                    int n7 = n;
                    this.data[n7] = (short)(this.data[n7] + 4);
                }
                if (this.pins[16].value) {
                    int n8 = n;
                    this.data[n8] = (short)(this.data[n8] + 2);
                }
                if (this.pins[17].value) {
                    int n9 = n;
                    this.data[n9] = (short)(this.data[n9] + 1);
                }
            }
        }
    }

    void doStep() {
        ChipElm.Pin pin;
        int n;
        for (n = 0; n != this.getPostCount(); ++n) {
            pin = this.pins[n];
            if (pin.output && this.pins[9].value) {
                boolean bl = pin.value = this.volts[n] > 2.5;
            }
            if (pin.output) continue;
            pin.value = this.volts[n] > 2.5;
        }
        this.execute();
        for (n = 0; n != this.getPostCount(); ++n) {
            pin = this.pins[n];
            if (!pin.output || this.pins[9].value) continue;
            sim.updateVoltageSource(0, this.nodes[n], pin.voltSource, pin.value ? 5.0 : 0.0);
        }
    }

    int getDumpType() {
        return 204;
    }
}

