/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class SevenSegDecoderElm
extends ChipElm {
    private static final boolean[][] symbols = new boolean[][]{{true, true, true, true, true, true, false}, {false, true, true, false, false, false, false}, {true, true, false, true, true, false, true}, {true, true, true, true, false, false, true}, {false, true, true, false, false, true, true}, {true, false, true, true, false, true, true}, {true, false, true, true, true, true, true}, {true, true, true, false, false, false, false}, {true, true, true, true, true, true, true}, {true, true, true, false, false, true, true}, {true, true, true, false, true, true, true}, {false, false, true, true, true, true, true}, {true, false, false, true, true, true, false}, {false, true, true, true, true, false, true}, {true, false, false, true, true, true, true}, {true, false, false, false, true, true, true}};

    boolean hasReset() {
        return false;
    }

    public SevenSegDecoderElm(int n, int n2) {
        super(n, n2);
    }

    public SevenSegDecoderElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "Seven Segment LED Decoder";
    }

    void setupPins() {
        this.sizeX = 3;
        this.sizeY = 7;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[7] = new ChipElm.Pin(0, 2, "I3");
        this.pins[8] = new ChipElm.Pin(1, 2, "I2");
        this.pins[9] = new ChipElm.Pin(2, 2, "I1");
        this.pins[10] = new ChipElm.Pin(3, 2, "I0");
        this.pins[0] = new ChipElm.Pin(0, 3, "a");
        this.pins[0].output = true;
        this.pins[1] = new ChipElm.Pin(1, 3, "b");
        this.pins[1].output = true;
        this.pins[2] = new ChipElm.Pin(2, 3, "c");
        this.pins[2].output = true;
        this.pins[3] = new ChipElm.Pin(3, 3, "d");
        this.pins[3].output = true;
        this.pins[4] = new ChipElm.Pin(4, 3, "e");
        this.pins[4].output = true;
        this.pins[5] = new ChipElm.Pin(5, 3, "f");
        this.pins[5].output = true;
        this.pins[6] = new ChipElm.Pin(6, 3, "g");
        this.pins[6].output = true;
    }

    int getPostCount() {
        return 11;
    }

    int getVoltageSourceCount() {
        return 7;
    }

    void execute() {
        int n = 0;
        if (this.pins[7].value) {
            n += 8;
        }
        if (this.pins[8].value) {
            n += 4;
        }
        if (this.pins[9].value) {
            n += 2;
        }
        if (this.pins[10].value) {
            ++n;
        }
        for (int i = 0; i < 7; ++i) {
            this.pins[i].value = symbols[n][i];
        }
    }

    int getDumpType() {
        return 197;
    }
}

