/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.StringTokenizer;

class TransistorElm
extends CircuitElm {
    int pnp;
    double beta;
    double fgain;
    double gmin;
    final int FLAG_FLIP = 1;
    double ic;
    double ie;
    double ib;
    double curcount_c;
    double curcount_e;
    double curcount_b;
    Polygon rectPoly;
    Polygon arrowPoly;
    Point[] rect;
    Point[] coll;
    Point[] emit;
    Point base;
    static final double leakage = 1.0E-13;
    static final double vt = 0.025;
    static final double vdcoef = 40.0;
    static final double rgain = 0.5;
    double vcrit;
    double lastvbc;
    double lastvbe;

    TransistorElm(int n, int n2, boolean bl) {
        super(n, n2);
        this.pnp = bl ? -1 : 1;
        this.beta = 100.0;
        this.setup();
    }

    public TransistorElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.pnp = new Integer(stringTokenizer.nextToken());
        this.beta = 100.0;
        try {
            this.lastvbe = new Double(stringTokenizer.nextToken());
            this.lastvbc = new Double(stringTokenizer.nextToken());
            this.volts[0] = 0.0;
            this.volts[1] = -this.lastvbe;
            this.volts[2] = -this.lastvbc;
            this.beta = new Double(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setup();
    }

    void setup() {
        this.vcrit = 0.025 * Math.log(0.025 / (Math.sqrt(2.0) * 1.0E-13));
        this.fgain = this.beta / (this.beta + 1.0);
        this.noDiagonal = true;
    }

    boolean nonLinear() {
        return true;
    }

    void reset() {
        this.volts[2] = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.curcount_b = 0.0;
        this.curcount_e = 0.0;
        this.curcount_c = 0.0;
        this.lastvbe = 0.0;
        this.lastvbc = 0.0;
    }

    int getDumpType() {
        return 116;
    }

    String dump() {
        return super.dump() + " " + this.pnp + " " + (this.volts[0] - this.volts[1]) + " " + (this.volts[0] - this.volts[2]) + " " + this.beta;
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 16.0);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, this.volts[1]);
        TransistorElm.drawThickLine(graphics, this.coll[0], this.coll[1]);
        this.setVoltageColor(graphics, this.volts[2]);
        TransistorElm.drawThickLine(graphics, this.emit[0], this.emit[1]);
        graphics.setColor(lightGrayColor);
        graphics.fillPolygon(this.arrowPoly);
        this.setVoltageColor(graphics, this.volts[0]);
        if (TransistorElm.sim.powerCheckItem.getState()) {
            graphics.setColor(Color.gray);
        }
        TransistorElm.drawThickLine(graphics, this.point1, this.base);
        this.curcount_b = this.updateDotCount(-this.ib, this.curcount_b);
        this.drawDots(graphics, this.base, this.point1, this.curcount_b);
        this.curcount_c = this.updateDotCount(-this.ic, this.curcount_c);
        this.drawDots(graphics, this.coll[1], this.coll[0], this.curcount_c);
        this.curcount_e = this.updateDotCount(-this.ie, this.curcount_e);
        this.drawDots(graphics, this.emit[1], this.emit[0], this.curcount_e);
        this.setVoltageColor(graphics, this.volts[0]);
        this.setPowerColor(graphics, true);
        graphics.fillPolygon(this.rectPoly);
        if ((this.needsHighlight() || TransistorElm.sim.dragElm == this) && this.dy == 0) {
            graphics.setColor(Color.white);
            graphics.setFont(unitsFont);
            int n = TransistorElm.sign(this.dx);
            graphics.drawString("B", this.base.x - 10 * n, this.base.y - 5);
            graphics.drawString("C", this.coll[0].x - 3 + 9 * n, this.coll[0].y + 4);
            graphics.drawString("E", this.emit[0].x - 3 + 9 * n, this.emit[0].y + 4);
        }
        this.drawPosts(graphics);
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 1 ? this.coll[0] : this.emit[0]);
    }

    int getPostCount() {
        return 3;
    }

    double getPower() {
        return (this.volts[0] - this.volts[2]) * this.ib + (this.volts[1] - this.volts[2]) * this.ic;
    }

    void setPoints() {
        super.setPoints();
        int n = 16;
        if ((this.flags & 1) != 0) {
            this.dsign = -this.dsign;
        }
        int n2 = n * this.dsign * this.pnp;
        this.coll = this.newPointArray(2);
        this.emit = this.newPointArray(2);
        this.interpPoint2(this.point1, this.point2, this.coll[0], this.emit[0], 1.0, n2);
        this.rect = this.newPointArray(4);
        this.interpPoint2(this.point1, this.point2, this.rect[0], this.rect[1], 1.0 - 16.0 / this.dn, n);
        this.interpPoint2(this.point1, this.point2, this.rect[2], this.rect[3], 1.0 - 13.0 / this.dn, n);
        this.interpPoint2(this.point1, this.point2, this.coll[1], this.emit[1], 1.0 - 13.0 / this.dn, 6 * this.dsign * this.pnp);
        this.base = new Point();
        this.interpPoint(this.point1, this.point2, this.base, 1.0 - 16.0 / this.dn);
        this.rectPoly = this.createPolygon(this.rect[0], this.rect[2], this.rect[3], this.rect[1]);
        if (this.pnp == 1) {
            this.arrowPoly = this.calcArrow(this.emit[1], this.emit[0], 8.0, 4.0);
        } else {
            Point point = this.interpPoint(this.point1, this.point2, 1.0 - 11.0 / this.dn, (double)(-5 * this.dsign * this.pnp));
            this.arrowPoly = this.calcArrow(this.emit[0], point, 8.0, 4.0);
        }
    }

    double limitStep(double d, double d2) {
        double d3 = d;
        if (d > this.vcrit && Math.abs(d - d2) > 0.05) {
            double d4;
            d = d2 > 0.0 ? ((d4 = 1.0 + (d - d2) / 0.025) > 0.0 ? d2 + 0.025 * Math.log(d4) : this.vcrit) : 0.025 * Math.log(d / 0.025);
            TransistorElm.sim.converged = false;
        }
        return d;
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
        sim.stampNonLinear(this.nodes[2]);
    }

    void doStep() {
        double d = this.volts[0] - this.volts[1];
        double d2 = this.volts[0] - this.volts[2];
        if (Math.abs(d - this.lastvbc) > 0.01 || Math.abs(d2 - this.lastvbe) > 0.01) {
            TransistorElm.sim.converged = false;
        }
        this.gmin = 0.0;
        if (TransistorElm.sim.subIterations > 100) {
            this.gmin = Math.exp(-9.0 * Math.log(10.0) * (1.0 - (double)TransistorElm.sim.subIterations / 3000.0));
            if (this.gmin > 0.1) {
                this.gmin = 0.1;
            }
        }
        d = (double)this.pnp * this.limitStep((double)this.pnp * d, (double)this.pnp * this.lastvbc);
        d2 = (double)this.pnp * this.limitStep((double)this.pnp * d2, (double)this.pnp * this.lastvbe);
        this.lastvbc = d;
        this.lastvbe = d2;
        double d3 = 40.0 * (double)this.pnp;
        double d4 = Math.exp(d * d3);
        double d5 = Math.exp(d2 * d3);
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        this.ie = (double)this.pnp * 1.0E-13 * (-(d5 - 1.0) + 0.5 * (d4 - 1.0));
        this.ic = (double)this.pnp * 1.0E-13 * (this.fgain * (d5 - 1.0) - (d4 - 1.0));
        this.ib = -(this.ie + this.ic);
        double d6 = -4.0E-12 * d5;
        double d7 = 2.0E-12 * d4;
        double d8 = -d6 * this.fgain;
        double d9 = -d7 * 2.0;
        sim.stampMatrix(this.nodes[0], this.nodes[0], -d6 - d7 - d8 - d9 + this.gmin * 2.0);
        sim.stampMatrix(this.nodes[0], this.nodes[1], d7 + d9 - this.gmin);
        sim.stampMatrix(this.nodes[0], this.nodes[2], d6 + d8 - this.gmin);
        sim.stampMatrix(this.nodes[1], this.nodes[0], d8 + d9 - this.gmin);
        sim.stampMatrix(this.nodes[1], this.nodes[1], -d9 + this.gmin);
        sim.stampMatrix(this.nodes[1], this.nodes[2], -d8);
        sim.stampMatrix(this.nodes[2], this.nodes[0], d6 + d7 - this.gmin);
        sim.stampMatrix(this.nodes[2], this.nodes[1], -d7);
        sim.stampMatrix(this.nodes[2], this.nodes[2], -d6 + this.gmin);
        sim.stampRightSide(this.nodes[0], -this.ib - (d7 + d9) * d - (d6 + d8) * d2);
        sim.stampRightSide(this.nodes[1], -this.ic + d8 * d2 + d9 * d);
        sim.stampRightSide(this.nodes[2], -this.ie + d6 * d2 + d7 * d);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "transistor (" + (this.pnp == -1 ? "PNP)" : "NPN)") + " beta=" + showFormat.format(this.beta);
        double d = this.volts[0] - this.volts[1];
        double d2 = this.volts[0] - this.volts[2];
        double d3 = this.volts[1] - this.volts[2];
        stringArray[1] = d * (double)this.pnp > 0.2 ? (d2 * (double)this.pnp > 0.2 ? "saturation" : "reverse active") : (d2 * (double)this.pnp > 0.2 ? "fwd active" : "cutoff");
        stringArray[2] = "Ic = " + TransistorElm.getCurrentText(this.ic);
        stringArray[3] = "Ib = " + TransistorElm.getCurrentText(this.ib);
        stringArray[4] = "Vbe = " + TransistorElm.getVoltageText(d2);
        stringArray[5] = "Vbc = " + TransistorElm.getVoltageText(d);
        stringArray[6] = "Vce = " + TransistorElm.getVoltageText(d3);
    }

    double getScopeValue(int n) {
        switch (n) {
            case 1: {
                return this.ib;
            }
            case 2: {
                return this.ic;
            }
            case 3: {
                return this.ie;
            }
            case 4: {
                return this.volts[0] - this.volts[2];
            }
            case 5: {
                return this.volts[0] - this.volts[1];
            }
            case 6: {
                return this.volts[1] - this.volts[2];
            }
        }
        return 0.0;
    }

    String getScopeUnits(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return "A";
            }
        }
        return "V";
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Beta/hFE", this.beta, 10.0, 1000.0).setDimensionless();
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Swap E/C", (this.flags & 1) != 0);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.beta = editInfo.value;
            this.setup();
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
            this.setPoints();
        }
    }

    boolean canViewInScope() {
        return true;
    }
}

