/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fatcalc.ui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import net.sourceforge.fatcalc.Config;
import net.sourceforge.fatcalc.core.FatCalculator;
import net.sourceforge.fatcalc.core.FatMethod;
import net.sourceforge.fatcalc.core.SkinFold;
import net.sourceforge.fatcalc.ui.AboutDialog;
import net.sourceforge.fatcalc.ui.PreferencesDialog;

public final class MainFrame
extends JFrame {
    private JButton aboutButton;
    private JFormattedTextField ageField;
    private JLabel ageLabel;
    private JButton calculateButton;
    private JButton copyButton;
    private JLabel dummyLabel;
    private JMenuItem editCalculateMenuItem;
    private JMenuItem editCopyMenuItem;
    private JMenu editMenu;
    private JMenuItem editResetMenuItem;
    private JPopupMenu.Separator editSeparator1;
    private JButton exitButton;
    private JLabel fatDescriptionLabel;
    private JLabel fatLabel;
    private JTextField fatTextField;
    private JLabel fatUnitLabel;
    private JTextField fatWeightTextField;
    private JCheckBox femaleCheckBox;
    private JMenuItem fileExitMenuItem;
    private JMenu fileMenu;
    private JMenuItem filePreferencesMenuItem;
    private JMenuItem filePrintMenuItem;
    private JMenuItem fileSaveMenuItem;
    private JPopupMenu.Separator fileSeparator1;
    private JPopupMenu.Separator fileSeparator2;
    private JLabel foldLabel;
    private JScrollPane foldsScrollPane;
    private JTable foldsTable;
    private JMenuItem helpAboutMenuItem;
    private JButton helpButton;
    private JMenuItem helpHelpMenuItem;
    private JMenu helpMenu;
    private JPanel jPanel1;
    private JTextField levelTextField;
    private JMenuBar menuBar;
    private JComboBox methodCombo;
    private JLabel methodDescriptionLabel;
    private JPanel methodPanel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton preferencesButton;
    private JButton printButton;
    private JButton resetButton;
    private JPanel resultPanel;
    private JScrollPane resultScrollPane;
    private JTextArea resultText;
    private JButton saveButton;
    private JLabel statusLabel;
    private JToolBar toolBar;
    private JToolBar.Separator toolBarSeparator1;
    private JToolBar.Separator toolBarSeparator2;
    private JToolBar.Separator toolBarSeparator3;
    private JToolBar.Separator toolBarSeparator4;
    private JToolBar.Separator toolBarSeparator5;
    private JLabel unitsLabel;
    private JPanel userPanel;
    private JFormattedTextField weightField;
    private JLabel weightLabel;
    private FatCalculator calculator = new FatCalculator();
    public static final double INCH_COEFF = 25.4;
    public static final double POUND_COEFF = 0.45359237;
    private final ResourceBundle bundle = ResourceBundle.getBundle("net/sourceforge/fatcalc/ui/resources/MainFrame");

    public MainFrame() {
        if (this.getLocation().x == 0 && this.getLocation().y == 0) {
            this.setLocationByPlatform(true);
        }
        this.initComponents();
        this.setTitle(this.getTitle() + " " + "1.1.1.32");
        URL url = ClassLoader.getSystemResource("net/sourceforge/fatcalc/ui/resources/calc.png");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image icon = kit.createImage(url);
        this.setIconImage(icon);
        for (FatMethod method : FatMethod.values()) {
            this.methodCombo.addItem(method.getName());
        }
        this.setUnitSystem(Config.getGlobal().isImperial());
        this.nameField.setText(Config.getGlobal().getUserName());
        this.ageField.setText(Config.getGlobal().getUserAge());
        this.weightField.setText(Config.getGlobal().getUserWeight());
        try {
            this.ageField.commitEdit();
            this.weightField.commitEdit();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        this.femaleCheckBox.setSelected(Config.getGlobal().isUserFemale());
        this.doMethodUpdate();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.exitButton = new JButton();
        this.toolBarSeparator1 = new JToolBar.Separator();
        this.preferencesButton = new JButton();
        this.toolBarSeparator2 = new JToolBar.Separator();
        this.saveButton = new JButton();
        this.printButton = new JButton();
        this.toolBarSeparator3 = new JToolBar.Separator();
        this.resetButton = new JButton();
        this.copyButton = new JButton();
        this.toolBarSeparator4 = new JToolBar.Separator();
        this.calculateButton = new JButton();
        this.toolBarSeparator5 = new JToolBar.Separator();
        this.helpButton = new JButton();
        this.aboutButton = new JButton();
        this.statusLabel = new JLabel();
        this.userPanel = new JPanel();
        this.weightField = new JFormattedTextField();
        this.weightLabel = new JLabel();
        this.ageField = new JFormattedTextField();
        this.ageLabel = new JLabel();
        this.femaleCheckBox = new JCheckBox();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.methodPanel = new JPanel();
        this.methodCombo = new JComboBox();
        this.methodDescriptionLabel = new JLabel();
        this.unitsLabel = new JLabel();
        this.resultPanel = new JPanel();
        this.resultScrollPane = new JScrollPane();
        this.resultText = new JTextArea();
        this.fatLabel = new JLabel();
        this.fatTextField = new JTextField();
        this.fatWeightTextField = new JTextField();
        this.dummyLabel = new JLabel();
        this.fatUnitLabel = new JLabel();
        this.fatDescriptionLabel = new JLabel();
        this.levelTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.foldsScrollPane = new JScrollPane();
        this.foldsTable = new JTable();
        this.foldLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileSaveMenuItem = new JMenuItem();
        this.filePrintMenuItem = new JMenuItem();
        this.fileSeparator1 = new JPopupMenu.Separator();
        this.filePreferencesMenuItem = new JMenuItem();
        this.fileSeparator2 = new JPopupMenu.Separator();
        this.fileExitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editResetMenuItem = new JMenuItem();
        this.editCopyMenuItem = new JMenuItem();
        this.editSeparator1 = new JPopupMenu.Separator();
        this.editCalculateMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpHelpMenuItem = new JMenuItem();
        this.helpAboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle(this.bundle.getString("FATCALC"));
        this.setIconImages(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }
        });
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.exitButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/exit.png")));
        this.exitButton.setToolTipText(this.bundle.getString("EXIT_PROGRAM"));
        this.exitButton.setFocusable(false);
        this.exitButton.setHorizontalTextPosition(0);
        this.exitButton.setVerticalTextPosition(3);
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exitButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.exitButton);
        this.toolBar.add(this.toolBarSeparator1);
        this.preferencesButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/configure.png")));
        this.preferencesButton.setToolTipText(this.bundle.getString("SHOW_PREFERENCES"));
        this.preferencesButton.setFocusable(false);
        this.preferencesButton.setHorizontalTextPosition(0);
        this.preferencesButton.setVerticalTextPosition(3);
        this.preferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.preferencesButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.preferencesButton);
        this.toolBar.add(this.toolBarSeparator2);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/filesave.png")));
        this.saveButton.setToolTipText(this.bundle.getString("SAVE_RESULTS"));
        this.saveButton.setFocusable(false);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setVerticalTextPosition(3);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.saveButton);
        this.printButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/fileprint.png")));
        this.printButton.setToolTipText(this.bundle.getString("PRINT_RESULTS"));
        this.printButton.setFocusable(false);
        this.printButton.setHorizontalTextPosition(0);
        this.printButton.setVerticalTextPosition(3);
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.printButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.printButton);
        this.toolBar.add(this.toolBarSeparator3);
        this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/editclear.png")));
        this.resetButton.setToolTipText(this.bundle.getString("CLEAR_ALL_FIELDS"));
        this.resetButton.setFocusable(false);
        this.resetButton.setHorizontalTextPosition(0);
        this.resetButton.setVerticalTextPosition(3);
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.resetButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.resetButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/editcopy.png")));
        this.copyButton.setToolTipText(this.bundle.getString("COPY_TO_CLIPBOARD"));
        this.copyButton.setFocusable(false);
        this.copyButton.setHorizontalTextPosition(0);
        this.copyButton.setVerticalTextPosition(3);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.copyButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.copyButton);
        this.toolBar.add(this.toolBarSeparator4);
        this.calculateButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/runit.png")));
        this.calculateButton.setToolTipText(this.bundle.getString("CALCULATE_FAT"));
        this.calculateButton.setFocusable(false);
        this.calculateButton.setHorizontalTextPosition(0);
        this.calculateButton.setVerticalTextPosition(3);
        this.calculateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.calculateButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.calculateButton);
        this.toolBar.add(this.toolBarSeparator5);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/help.png")));
        this.helpButton.setToolTipText(this.bundle.getString("SHOW_HELP"));
        this.helpButton.setFocusable(false);
        this.helpButton.setHorizontalTextPosition(0);
        this.helpButton.setVerticalTextPosition(3);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.helpButton);
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/info.png")));
        this.aboutButton.setToolTipText(this.bundle.getString("DISPLAY_ABOUT"));
        this.aboutButton.setFocusable(false);
        this.aboutButton.setHorizontalTextPosition(0);
        this.aboutButton.setVerticalTextPosition(3);
        this.aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.aboutButton);
        this.statusLabel.setToolTipText(this.bundle.getString("STATUS_BAR"));
        this.statusLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.userPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "User"));
        this.weightField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter()));
        this.weightField.setToolTipText(this.bundle.getString("YOUR_WEIGHT"));
        this.weightLabel.setLabelFor(this.weightField);
        this.weightLabel.setText(this.bundle.getString("WEIGHT"));
        this.ageField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.ageField.setToolTipText(this.bundle.getString("AGE_HINT"));
        this.ageLabel.setLabelFor(this.ageField);
        this.ageLabel.setText(this.bundle.getString("AGE"));
        this.femaleCheckBox.setText(this.bundle.getString("FEMALE"));
        this.femaleCheckBox.setToolTipText(this.bundle.getString("FEMALE_HINT"));
        this.femaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.femaleCheckBoxActionPerformed(evt);
            }
        });
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(this.bundle.getString("NAME"));
        this.nameField.setToolTipText(this.bundle.getString("NAME_HINT"));
        GroupLayout userPanelLayout = new GroupLayout(this.userPanel);
        this.userPanel.setLayout(userPanelLayout);
        userPanelLayout.setHorizontalGroup(userPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, userPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameLabel, -1, 43, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -2, 144, -2).addGap(32, 32, 32).addComponent(this.ageLabel, -1, 34, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ageField, -2, 32, -2).addGap(32, 32, 32).addComponent(this.weightLabel, -1, 50, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weightField, -2, 28, -2).addGap(46, 46, 46).addComponent(this.femaleCheckBox).addContainerGap()));
        userPanelLayout.setVerticalGroup(userPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userPanelLayout.createSequentialGroup().addContainerGap().addGroup(userPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ageLabel).addComponent(this.weightLabel).addComponent(this.nameLabel).addComponent(this.femaleCheckBox).addComponent(this.nameField, -2, -1, -2).addComponent(this.ageField, -2, -1, -2).addComponent(this.weightField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.methodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Method"));
        this.methodCombo.setToolTipText(this.bundle.getString("METHOD_HINT"));
        this.methodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.methodComboActionPerformed(evt);
            }
        });
        this.methodDescriptionLabel.setText(" ");
        this.methodDescriptionLabel.setToolTipText(this.bundle.getString("METHOD_DESC_HINT"));
        GroupLayout methodPanelLayout = new GroupLayout(this.methodPanel);
        this.methodPanel.setLayout(methodPanelLayout);
        methodPanelLayout.setHorizontalGroup(methodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(methodPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.methodCombo, -2, 161, -2).addGap(18, 18, 18).addComponent(this.methodDescriptionLabel, -1, 329, Short.MAX_VALUE).addContainerGap()));
        methodPanelLayout.setVerticalGroup(methodPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(methodPanelLayout.createSequentialGroup().addContainerGap().addGroup(methodPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.methodCombo, -2, -1, -2).addComponent(this.methodDescriptionLabel)).addContainerGap()));
        this.unitsLabel.setToolTipText(this.bundle.getString("UNITS_SYSTEM_HINT"));
        this.unitsLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.resultPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Results"));
        this.resultText.setColumns(20);
        this.resultText.setEditable(false);
        this.resultText.setFont(new Font("Monospaced", 0, 12));
        this.resultText.setToolTipText(this.bundle.getString("CALCULATION_RESULTS"));
        this.resultScrollPane.setViewportView(this.resultText);
        this.fatLabel.setText(this.bundle.getString("FAT_LABEL"));
        this.fatTextField.setEditable(false);
        this.fatTextField.setText(" ");
        this.fatTextField.setToolTipText(this.bundle.getString("FAT_PERCENTAGE"));
        this.fatWeightTextField.setEditable(false);
        this.fatWeightTextField.setText(" ");
        this.fatWeightTextField.setToolTipText(this.bundle.getString("FAT_WEIGHT"));
        this.dummyLabel.setText("%");
        this.fatUnitLabel.setText(" ");
        this.fatDescriptionLabel.setText(this.bundle.getString("FAT_LEVEL"));
        this.fatDescriptionLabel.setToolTipText(this.bundle.getString("FAT_LEVEL"));
        this.levelTextField.setEditable(false);
        this.levelTextField.setToolTipText(this.bundle.getString("FAT_LEVEL_HINT"));
        GroupLayout resultPanelLayout = new GroupLayout(this.resultPanel);
        this.resultPanel.setLayout(resultPanelLayout);
        resultPanelLayout.setHorizontalGroup(resultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, resultPanelLayout.createSequentialGroup().addContainerGap().addGroup(resultPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultScrollPane, GroupLayout.Alignment.LEADING, -1, 508, Short.MAX_VALUE).addGroup(resultPanelLayout.createSequentialGroup().addComponent(this.fatLabel).addGap(10, 10, 10).addComponent(this.fatTextField, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fatWeightTextField, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fatUnitLabel, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE).addComponent(this.fatDescriptionLabel, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.levelTextField, -2, 183, -2))).addContainerGap()));
        resultPanelLayout.linkSize(0, this.fatTextField, this.fatWeightTextField);
        resultPanelLayout.setVerticalGroup(resultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(resultPanelLayout.createSequentialGroup().addGroup(resultPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fatTextField, -2, -1, -2).addComponent(this.fatLabel).addComponent(this.dummyLabel).addComponent(this.fatWeightTextField, -2, -1, -2).addComponent(this.fatUnitLabel).addComponent(this.levelTextField, -2, -1, -2).addComponent(this.fatDescriptionLabel, -2, 0, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resultScrollPane, -1, 83, Short.MAX_VALUE).addContainerGap()));
        resultPanelLayout.linkSize(1, this.fatDescriptionLabel, this.fatLabel);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Folds"));
        this.foldsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Fold", "1", "2", "3", "Average"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class, Double.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, true, true, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.foldsTable.setToolTipText(this.bundle.getString("FOLDS_TABLE_HINT"));
        this.foldsTable.setNextFocusableComponent(this.methodCombo);
        this.foldsTable.setSelectionMode(0);
        this.foldsTable.getTableHeader().setReorderingAllowed(false);
        this.foldsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.foldsTableMouseClicked(evt);
            }
        });
        this.foldsTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MainFrame.this.foldsTablePropertyChange(evt);
            }
        });
        this.foldsTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainFrame.this.foldsTableKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                MainFrame.this.foldsTableKeyReleased(evt);
            }
        });
        this.foldsScrollPane.setViewportView(this.foldsTable);
        this.foldLabel.setText(" ");
        this.foldLabel.setToolTipText(this.bundle.getString("FOLD_HINT"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.foldsScrollPane, -1, 508, Short.MAX_VALUE).addComponent(this.foldLabel, -1, 508, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.foldsScrollPane, -1, 177, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.foldLabel).addGap(11, 11, 11)));
        this.fileMenu.setText(this.bundle.getString("FILE"));
        this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSaveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/filesave.png")));
        this.fileSaveMenuItem.setText(this.bundle.getString("SAVE"));
        this.fileSaveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileSaveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveMenuItem);
        this.filePrintMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.filePrintMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/fileprint.png")));
        this.filePrintMenuItem.setText(this.bundle.getString("PRINT"));
        this.filePrintMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.filePrintMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.filePrintMenuItem);
        this.fileMenu.add(this.fileSeparator1);
        this.filePreferencesMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.filePreferencesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/configure.png")));
        this.filePreferencesMenuItem.setText(this.bundle.getString("PREFERENCES"));
        this.filePreferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.filePreferencesMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.filePreferencesMenuItem);
        this.fileMenu.add(this.fileSeparator2);
        this.fileExitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.fileExitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/exit.png")));
        this.fileExitMenuItem.setText(this.bundle.getString("EXIT"));
        this.fileExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileExitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileExitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(this.bundle.getString("EDIT"));
        this.editResetMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.editResetMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/editclear.png")));
        this.editResetMenuItem.setText(this.bundle.getString("RESET"));
        this.editResetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.editResetMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editResetMenuItem);
        this.editCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.editCopyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/editcopy.png")));
        this.editCopyMenuItem.setText(this.bundle.getString("COPY"));
        this.editCopyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.editCopyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editCopyMenuItem);
        this.editMenu.add(this.editSeparator1);
        this.editCalculateMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.editCalculateMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/runit.png")));
        this.editCalculateMenuItem.setText(this.bundle.getString("CALCULATE"));
        this.editCalculateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.editCalculateMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editCalculateMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText(this.bundle.getString("HELP"));
        this.helpHelpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpHelpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/help.png")));
        this.helpHelpMenuItem.setText(this.bundle.getString("HELP"));
        this.helpHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpHelpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpHelpMenuItem);
        this.helpAboutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/info.png")));
        this.helpAboutMenuItem.setText(this.bundle.getString("ABOUT"));
        this.helpAboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpAboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpAboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 560, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusLabel, -1, 444, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unitsLabel, -2, 110, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.userPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.methodPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.resultPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.methodPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.unitsLabel).addComponent(this.statusLabel, -2, 24, -2))));
        layout.linkSize(1, this.statusLabel, this.unitsLabel);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doExit();
    }

    private void helpAboutMenuItemActionPerformed(ActionEvent evt) {
        this.doAbout();
    }

    private void fileExitMenuItemActionPerformed(ActionEvent evt) {
        this.doExit();
    }

    private void filePreferencesMenuItemActionPerformed(ActionEvent evt) {
        this.doPreferences();
    }

    private void methodComboActionPerformed(ActionEvent evt) {
        this.doMethodUpdate();
    }

    private void femaleCheckBoxActionPerformed(ActionEvent evt) {
        this.doMethodUpdate();
    }

    private void foldsTablePropertyChange(PropertyChangeEvent evt) {
        this.doTableUpdate();
    }

    private void editResetMenuItemActionPerformed(ActionEvent evt) {
        this.doReset();
    }

    private void editCalculateMenuItemActionPerformed(ActionEvent evt) {
        this.doCalculate();
    }

    private void editCopyMenuItemActionPerformed(ActionEvent evt) {
        this.doCopy();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        this.doExit();
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        this.doAbout();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.doHelp();
    }

    private void helpHelpMenuItemActionPerformed(ActionEvent evt) {
        this.doHelp();
    }

    private void preferencesButtonActionPerformed(ActionEvent evt) {
        this.doPreferences();
    }

    private void fileSaveMenuItemActionPerformed(ActionEvent evt) {
        this.doSave();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.doSave();
    }

    private void filePrintMenuItemActionPerformed(ActionEvent evt) {
        this.doPrint();
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        this.doPrint();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.doReset();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        this.doCopy();
    }

    private void calculateButtonActionPerformed(ActionEvent evt) {
        this.doCalculate();
    }

    private void foldsTableKeyPressed(KeyEvent evt) {
        this.updateFoldDescription();
    }

    private void foldsTableMouseClicked(MouseEvent evt) {
        this.updateFoldDescription();
    }

    private void foldsTableKeyReleased(KeyEvent evt) {
        this.updateFoldDescription();
    }

    public void doMethodUpdate() {
        System.out.println("doMethodUpdate()");
        this.calculator.setMethod(this.getActiveFatMethod());
        FatMethod method = this.getActiveFatMethod();
        if (method.isFemale()) {
            this.femaleCheckBox.setEnabled(true);
        } else {
            this.femaleCheckBox.setEnabled(false);
            this.femaleCheckBox.setSelected(false);
        }
        DefaultTableModel model = (DefaultTableModel)this.foldsTable.getModel();
        model.setRowCount(0);
        for (SkinFold fold : method.getFolds(this.femaleCheckBox.isSelected())) {
            Double foldValue = null;
            if (!Double.isNaN(this.calculator.getFold(fold))) {
                foldValue = this.calculator.getFold(fold);
            }
            model.addRow(new Object[]{fold.getName(), foldValue, null, null, null});
        }
        this.methodDescriptionLabel.setText(this.getActiveFatMethod().getDescription());
    }

    private void doTableUpdate() {
        System.out.println("doTableUpdate()");
        for (int i = 0; i < this.foldsTable.getModel().getRowCount(); ++i) {
            double sum = 0.0;
            double count = 0.0;
            for (int j = 1; j < this.foldsTable.getModel().getColumnCount() - 1; ++j) {
                if (this.foldsTable.getModel().getValueAt(i, j) == null) continue;
                sum += Double.parseDouble(this.foldsTable.getValueAt(i, j).toString());
                count += 1.0;
            }
            SkinFold fold = this.getActiveFatMethod().getFolds(this.femaleCheckBox.isSelected())[i];
            if (count == 0.0) {
                this.foldsTable.getModel().setValueAt(null, i, 4);
                this.calculator.setFold(fold, Double.NaN);
                continue;
            }
            this.foldsTable.getModel().setValueAt(sum / count, i, 4);
            if (Config.getGlobal().isImperial()) {
                this.calculator.setFold(fold, sum / count * 25.4);
                continue;
            }
            this.calculator.setFold(fold, sum / count);
        }
    }

    private void setStatus(String message, boolean error) {
        this.statusLabel.setText(message);
        if (message == null) {
            this.statusLabel.setIcon(null);
            return;
        }
        if (error) {
            this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/error.png")));
        } else {
            this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/ok.png")));
        }
    }

    private void setUnitSystem(boolean imperial) {
        if (imperial) {
            this.unitsLabel.setText(this.bundle.getString("IMPERIAL"));
        } else {
            this.unitsLabel.setText(this.bundle.getString("METRIC"));
        }
    }

    private String getLengthUnit() {
        if (Config.getGlobal().isImperial()) {
            return this.bundle.getString("IN");
        }
        return this.bundle.getString("MM");
    }

    private String getWeightUnit() {
        if (Config.getGlobal().isImperial()) {
            return this.bundle.getString("PD");
        }
        return this.bundle.getString("KG");
    }

    public FatMethod getActiveFatMethod() {
        return FatMethod.values()[this.methodCombo.getSelectedIndex()];
    }

    private boolean resultAvailable() {
        return this.resultText.getText() != null && !this.resultText.getText().equals("");
    }

    private void updateFoldDescription() {
        this.foldLabel.setText(this.getActiveFatMethod().getFolds(this.femaleCheckBox.isSelected())[this.foldsTable.getSelectedRow()].getDescription());
    }

    private void doExit() {
        System.out.println("doExit()");
        Config.getGlobal().setWindowPosition(this.getLocation());
        Config.getGlobal().setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
        Config.getGlobal().setUserName(this.nameField.getText());
        Config.getGlobal().setUserAge(this.ageField.getText());
        Config.getGlobal().setUserWeight(this.weightField.getText());
        Config.getGlobal().setUserFemale(this.femaleCheckBox.isSelected());
        Config.getGlobal().save();
        System.exit(0);
    }

    private void doPreferences() {
        System.out.println("doPreferences()");
        PreferencesDialog preferences = new PreferencesDialog((Frame)this, true);
        preferences.setLocationRelativeTo(this);
        preferences.setResizable(false);
        preferences.setVisible(true);
        if (preferences.isOk()) {
            this.setUnitSystem(Config.getGlobal().isImperial());
            this.doTableUpdate();
            this.setStatus(String.format(this.bundle.getString("PREFERENCES_SAVED_TO"), Config.getGlobal().getConfigName()), false);
        }
    }

    private void doSave() {
        System.out.println("doSave()");
        if (!this.resultAvailable()) {
            this.setStatus(this.bundle.getString("NOTHING_TO_SAVE"), true);
            return;
        }
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(this.bundle.getString("TEXT_FILES"), "txt", "text");
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        int result = chooser.showOpenDialog(this);
        if (result != 0) {
            return;
        }
        String filename = chooser.getSelectedFile().getPath();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write(this.resultText.getText());
            writer.close();
            this.setStatus(String.format(this.bundle.getString("RESULTS_SAVED_TO"), filename), false);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            this.setStatus(String.format(this.bundle.getString("CANT_SAVE_TO"), filename), true);
        }
    }

    private void doPrint() {
        System.out.println("doPrint()");
        if (!this.resultAvailable()) {
            this.setStatus(this.bundle.getString("NOTHING_TO_PRINT"), true);
            return;
        }
        try {
            this.resultText.print();
            this.setStatus(this.bundle.getString("PRINT_DONE"), false);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            this.setStatus(this.bundle.getString("PRINT_FAILED"), true);
        }
    }

    private void doReset() {
        System.out.println("doReset()");
        for (int i = 0; i < this.foldsTable.getModel().getRowCount(); ++i) {
            for (int j = 1; j < this.foldsTable.getModel().getColumnCount(); ++j) {
                this.foldsTable.getModel().setValueAt(null, i, j);
            }
        }
        this.calculator.reset();
        this.nameField.setText(null);
        this.ageField.setText(null);
        this.weightField.setText(null);
        this.resultText.setText(null);
        this.fatTextField.setText(null);
        this.fatWeightTextField.setText(null);
        this.levelTextField.setText(null);
        this.setStatus(this.bundle.getString("RESET_OK"), false);
    }

    private void doCopy() {
        System.out.println("doCopy()");
        if (!this.resultAvailable()) {
            this.setStatus(this.bundle.getString("NOTHING_TO_COPY"), true);
            return;
        }
        StringSelection selection = new StringSelection(this.resultText.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
        this.setStatus(this.bundle.getString("RESULTS_COPIED"), false);
    }

    private void doCalculate() {
        double lengthCoeff;
        SkinFold[] folds;
        System.out.println("doCalculate()");
        if (this.weightField.getValue() == null) {
            this.setStatus(this.bundle.getString("SPECIFY_WEIGHT"), true);
            this.weightField.requestFocus();
            return;
        }
        if (this.getActiveFatMethod().isAgeNeeded() && this.ageField.getValue() == null) {
            this.setStatus(this.bundle.getString("SPECIFY_AGE"), true);
            this.ageField.requestFocus();
            return;
        }
        for (SkinFold fold : folds = this.getActiveFatMethod().getFolds(this.femaleCheckBox.isSelected())) {
            if (!Double.isNaN(this.calculator.getFold(fold)) && this.calculator.getFold(fold) != 0.0) continue;
            this.setStatus(String.format(this.bundle.getString("SET_FOLD"), fold.getName()), true);
            this.foldsTable.requestFocus();
            return;
        }
        if (Config.getGlobal().isImperial()) {
            this.calculator.setWeight(Double.parseDouble(this.weightField.getText()) * 0.45359237);
        } else {
            this.calculator.setWeight(Double.parseDouble(this.weightField.getText()));
        }
        this.calculator.setAge(Integer.parseInt(this.ageField.getText()));
        this.calculator.setFemale(this.femaleCheckBox.isSelected());
        double result = this.calculator.calculate();
        if (Double.isNaN(result)) {
            this.setStatus(this.bundle.getString("CALCULATE_FAILED"), true);
            return;
        }
        double weightCoeff = 0.0;
        if (Config.getGlobal().isImperial()) {
            weightCoeff = 2.2046226218487757;
            lengthCoeff = 0.03937007874015748;
        } else {
            weightCoeff = 1.0;
            lengthCoeff = 1.0;
        }
        StringBuilder builder = new StringBuilder();
        String name = this.nameField.getText();
        String age = this.ageField.getText();
        if (name == null || name.equals("")) {
            name = this.bundle.getString("INCOGNITO");
        }
        if (age.equals("")) {
            age = this.bundle.getString("UNKNOWN");
        }
        String sex = this.femaleCheckBox.isSelected() ? this.bundle.getString("FEMALE") : this.bundle.getString("MALE");
        builder.append(String.format(this.bundle.getString("SUBJECT_AGE_SEX_WEIGHT"), name, age, sex, this.calculator.getWeight() * weightCoeff, this.getWeightUnit()));
        builder.append(String.format(this.bundle.getString("METHOD_RESULT"), this.getActiveFatMethod().getName()));
        builder.append(String.format(this.bundle.getString("DATE_RESULT"), new Date().toString()));
        builder.append(String.format(this.bundle.getString("BODY_FAT_RESULT"), this.calculator.getFatPercentage(), this.calculator.getFatWeight() * weightCoeff, this.getWeightUnit()));
        builder.append(String.format(this.bundle.getString("FAT_LEVEL_RESULT"), this.calculator.getResultDescription()));
        builder.append(String.format(this.bundle.getString("LEAN_WEIGHT_RESULT"), this.calculator.getLeanWeight() * weightCoeff, this.getWeightUnit()));
        builder.append(this.bundle.getString("FOLDS_RESULT"));
        for (SkinFold fold : this.getActiveFatMethod().getFolds(this.femaleCheckBox.isSelected())) {
            builder.append(String.format(this.bundle.getString("FOLD_RESULT_LINE"), fold.getName(), this.calculator.getFold(fold) * lengthCoeff, this.getLengthUnit()));
        }
        this.resultText.setText(builder.toString());
        this.resultText.setCaretPosition(0);
        this.fatUnitLabel.setText(this.getWeightUnit());
        this.fatTextField.setText(String.format("%.2f", this.calculator.getFatPercentage()));
        this.fatWeightTextField.setText(String.format("%.2f", this.calculator.getFatWeight() * weightCoeff));
        this.levelTextField.setText(this.calculator.getResultDescription());
        this.setStatus(this.bundle.getString("CALCULATION_OK"), false);
    }

    private void doHelp() {
        System.out.println("doHelp()");
        JOptionPane.showMessageDialog(this, this.bundle.getString("NO_HELP"), this.bundle.getString("HELP"), 2);
    }

    private void doAbout() {
        System.out.println("doAbout()");
        AboutDialog about = new AboutDialog((Frame)this, true);
        about.setLocationRelativeTo(this);
        about.setResizable(false);
        about.setVisible(true);
    }
}

