/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fatcalc.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sourceforge.fatcalc.Config;

public final class PreferencesDialog
extends JDialog {
    private JButton cancelButton;
    private JCheckBox imperialCheckBox;
    private JPanel jPanel1;
    private JComboBox lookComboBox;
    private JLabel lookLabel;
    private JButton okButton;
    private JPanel preferencesPanel;
    private boolean ok = false;
    private String[] lookAndFeelClassNames;
    private int previousLook = 0;
    private final ResourceBundle bundle = ResourceBundle.getBundle("net/sourceforge/fatcalc/ui/resources/PreferencesDialog");

    public PreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.imperialCheckBox.setSelected(Config.getGlobal().isImperial());
        int index = 0;
        int i = 0;
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelClassNames = new String[infos.length];
        for (UIManager.LookAndFeelInfo info : infos) {
            this.lookComboBox.addItem(info.getName());
            this.lookAndFeelClassNames[i] = info.getClassName();
            if (UIManager.getLookAndFeel().getName().equals(info.getName())) {
                index = i;
            }
            ++i;
        }
        this.lookComboBox.setSelectedIndex(index);
        this.previousLook = index;
    }

    private void initComponents() {
        this.preferencesPanel = new JPanel();
        this.imperialCheckBox = new JCheckBox();
        this.lookComboBox = new JComboBox();
        this.lookLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.bundle.getString("PREFERENCES"));
        this.preferencesPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.preferencesPanel.setPreferredSize(new Dimension(470, 88));
        this.imperialCheckBox.setText(this.bundle.getString("IMPERIAL_UNITS"));
        this.imperialCheckBox.setToolTipText(this.bundle.getString("IMPERIAL_UNITS_HINT"));
        this.lookComboBox.setToolTipText(this.bundle.getString("LOOK_AND_FEEL_HINT"));
        this.lookLabel.setLabelFor(this.lookComboBox);
        this.lookLabel.setText(this.bundle.getString("LOOK_AND_FEEL"));
        GroupLayout preferencesPanelLayout = new GroupLayout(this.preferencesPanel);
        this.preferencesPanel.setLayout(preferencesPanelLayout);
        preferencesPanelLayout.setHorizontalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.imperialCheckBox).addGap(50, 50, 50).addComponent(this.lookLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lookComboBox, 0, 149, Short.MAX_VALUE).addContainerGap()));
        preferencesPanelLayout.setVerticalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imperialCheckBox).addComponent(this.lookComboBox, -2, -1, -2).addComponent(this.lookLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/cancel.png")));
        this.cancelButton.setText(this.bundle.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/fatcalc/ui/resources/ok.png")));
        this.okButton.setText(this.bundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(206, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton).addContainerGap()));
        jPanel1Layout.linkSize(0, this.cancelButton, this.okButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.preferencesPanel, -1, 380, Short.MAX_VALUE).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.preferencesPanel, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int laf = this.lookComboBox.getSelectedIndex();
        if (this.previousLook != laf) {
            try {
                UIManager.setLookAndFeel(this.lookAndFeelClassNames[laf]);
                SwingUtilities.updateComponentTreeUI(this.getParent());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        Config.getGlobal().setImperial(this.imperialCheckBox.isSelected());
        Config.getGlobal().save();
        this.ok = true;
        this.setVisible(false);
    }

    public boolean isImperial() {
        return this.imperialCheckBox.isSelected();
    }

    public void setImperial(boolean value) {
        this.imperialCheckBox.setSelected(value);
    }

    public boolean isOk() {
        return this.ok;
    }
}

