/*
 * Decompiled with CFR 0.152.
 */
package idiet;

import idiet.FoodNode;
import idiet.TreeNodeTreeModel;
import javax.swing.tree.TreeNode;

public class HideableTreeModel
extends TreeNodeTreeModel {
    public HideableTreeModel(TreeNode root) {
        super(root);
    }

    public boolean isNodeVisible(Object node) {
        if (node != this.getRoot() && node instanceof FoodNode) {
            return ((FoodNode)node).isVisible();
        }
        return true;
    }

    public boolean setNodeVisible(Object node, boolean v) {
        if (node != this.getRoot() && node instanceof FoodNode) {
            FoodNode n = (FoodNode)node;
            if (v != n.isVisible()) {
                TreeNode parent = n.getParent();
                if (v) {
                    n.setVisible(v);
                    int index = this.getIndexOfChild(parent, n);
                    super.nodeInserted(parent, n, index);
                } else {
                    int index = this.getIndexOfChild(parent, n);
                    n.setVisible(v);
                    super.nodeRemoved(parent, n, index);
                }
            }
            return true;
        }
        return false;
    }

    public boolean stringMatch(String str1, String str2) {
        boolean match = false;
        String[] tokenz1 = str1.split(" ");
        String[] tokenz2 = str2.split(" ");
        for (int i = 0; i < tokenz1.length; ++i) {
            String token1 = tokenz1[i];
            for (int j = 0; j < tokenz2.length; ++j) {
                if (tokenz2[j].toLowerCase().contains(token1.toLowerCase())) {
                    match = true;
                    break;
                }
                match = false;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public int setNodesVis(String s, Object node) {
        if (node instanceof FoodNode) {
            FoodNode n = (FoodNode)node;
            if (n.isLeaf()) {
                if (!n.isVisible() && this.stringMatch(s.toLowerCase(), n.toString())) {
                    this.setNodeVisible(n, true);
                    return 0;
                }
                if (!this.stringMatch(s.toLowerCase(), n.toString())) {
                    this.setNodeVisible(n, false);
                    return 1;
                }
            } else {
                int c = n.getChildCount();
                int inv = 0;
                for (int i = 0; i < c; ++i) {
                    inv += this.setNodesVis(s, n.getChildAt(i));
                }
                if (inv == c) {
                    this.setNodeVisible(n, false);
                } else {
                    this.setNodeVisible(n, true);
                }
                return 1;
            }
        }
        return 0;
    }

    public boolean isPathToNodeVisible(Object node) {
        Object[] path = this.getPathToRoot(node);
        for (int i = 0; i < path.length; ++i) {
            if (((FoodNode)path[i]).isVisible()) continue;
            return false;
        }
        return true;
    }

    public void ensurePathToNodeVisible(Object node) {
        Object[] path = this.getPathToRoot(node);
        for (int i = 0; i < path.length; ++i) {
            this.setNodeVisible(path[i], true);
        }
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof TreeNode) {
            TreeNode p = (TreeNode)parent;
            int j = -1;
            for (int i = 0; i < p.getChildCount(); ++i) {
                TreeNode pc = p.getChildAt(i);
                if (((FoodNode)pc).isVisible()) {
                    ++j;
                }
                if (j != index) continue;
                return pc;
            }
        }
        return null;
    }

    public int getChildCount(Object parent) {
        int count = 0;
        if (parent instanceof TreeNode && !((TreeNode)parent).isLeaf()) {
            TreeNode p = (TreeNode)parent;
            for (int i = 0; i < p.getChildCount(); ++i) {
                TreeNode pc = p.getChildAt(i);
                if (!((FoodNode)pc).isVisible()) continue;
                ++count;
            }
        }
        return count;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int index = -1;
        if (parent instanceof TreeNode && child instanceof TreeNode) {
            TreeNode p = (TreeNode)parent;
            TreeNode c = (TreeNode)child;
            if (this.isNodeVisible(c)) {
                index = 0;
                for (int i = 0; i < p.getChildCount(); ++i) {
                    TreeNode pc = p.getChildAt(i);
                    if (pc.equals(c)) {
                        return index;
                    }
                    if (!((FoodNode)pc).isVisible()) continue;
                    ++index;
                }
            }
        }
        return index;
    }
}

