/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

final class Arguments
extends IdScriptableObject {
    static final long serialVersionUID = 4275508002492040609L;
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int MAX_INSTANCE_ID = 3;
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall nativeCall) {
        this.activation = nativeCall;
        Scriptable scriptable = nativeCall.getParentScope();
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.args = nativeCall.originalArgs;
        this.lengthObj = new Integer(this.args.length);
        NativeFunction nativeFunction = nativeCall.function;
        this.calleeObj = nativeFunction;
        int n = nativeFunction.getLanguageVersion();
        this.callerObj = n <= 130 && n != 0 ? null : NOT_FOUND;
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.args.length && this.args[n] != NOT_FOUND) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Object object;
        if (n >= 0 && n < this.args.length && (object = this.args[n]) != NOT_FOUND) {
            NativeFunction nativeFunction;
            String string;
            if (this.sharedWithActivation(n) && (object = this.activation.get(string = (nativeFunction = this.activation.function).getParamOrVarName(n), (Scriptable)this.activation)) == NOT_FOUND) {
                Kit.codeBug();
            }
            return object;
        }
        return super.get(n, scriptable);
    }

    private boolean sharedWithActivation(int n) {
        NativeFunction nativeFunction = this.activation.function;
        int n2 = nativeFunction.getParamCount();
        if (n < n2) {
            if (n < n2 - 1) {
                String string = nativeFunction.getParamOrVarName(n);
                int n3 = n + 1;
                while (n3 < n2) {
                    if (string.equals(nativeFunction.getParamOrVarName(n3))) {
                        return false;
                    }
                    ++n3;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.args.length && this.args[n] != NOT_FOUND) {
            if (this.sharedWithActivation(n)) {
                String string = this.activation.function.getParamOrVarName(n);
                this.activation.put(string, (Scriptable)this.activation, object);
                return;
            }
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[n] != NOT_FOUND) {
                    if (this.args == this.activation.originalArgs) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[n] = object;
                    return;
                }
            }
        }
        super.put(n, scriptable, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int n) {
        if (n >= 0 && n < this.args.length) {
            Arguments arguments = this;
            synchronized (arguments) {
                if (this.args[n] != NOT_FOUND) {
                    if (this.args == this.activation.originalArgs) {
                        this.args = (Object[])this.args.clone();
                    }
                    this.args[n] = NOT_FOUND;
                    return;
                }
            }
        }
        super.delete(n);
    }

    @Override
    protected int getMaxInstanceId() {
        return 3;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        if (string.length() == 6) {
            char c = string.charAt(5);
            if (c == 'e') {
                string2 = "callee";
                n2 = 1;
            } else if (c == 'h') {
                string2 = "length";
                n2 = 2;
            } else if (c == 'r') {
                string2 = "caller";
                n2 = 3;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                n = 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Arguments.instanceIdInfo(n, n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
        }
        return null;
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                NativeCall nativeCall;
                Object object = this.callerObj;
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                } else if (object == null && (nativeCall = this.activation.parentActivationCall) != null) {
                    object = nativeCall.get("arguments", (Scriptable)nativeCall);
                }
                return object;
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        switch (n) {
            case 1: {
                this.calleeObj = object;
                return;
            }
            case 2: {
                this.lengthObj = object;
                return;
            }
            case 3: {
                this.callerObj = object != null ? object : UniqueTag.NULL_VALUE;
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    Object[] getIds(boolean bl) {
        Object[] objectArray = super.getIds(bl);
        if (bl && this.args.length != 0) {
            int n;
            boolean[] blArray = null;
            int n2 = this.args.length;
            int n3 = 0;
            while (n3 != objectArray.length) {
                Object object = objectArray[n3];
                if (object instanceof Integer && (n = ((Integer)object).intValue()) >= 0 && n < this.args.length) {
                    if (blArray == null) {
                        blArray = new boolean[this.args.length];
                    }
                    if (blArray[n] == false) {
                        blArray[n] = true;
                        --n2;
                    }
                }
                ++n3;
            }
            if (n2 != 0) {
                Object[] objectArray2 = new Object[n2 + objectArray.length];
                System.arraycopy(objectArray, 0, objectArray2, n2, objectArray.length);
                objectArray = objectArray2;
                int n4 = 0;
                n = 0;
                while (n != this.args.length) {
                    if (blArray == null || !blArray[n]) {
                        objectArray[n4] = new Integer(n);
                        ++n4;
                    }
                    ++n;
                }
                if (n4 != n2) {
                    Kit.codeBug();
                }
            }
        }
        return objectArray;
    }
}

