/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;

class NativeRegExpCtor
extends BaseFunction {
    static final long serialVersionUID = -5733330028285400526L;
    private static final int Id_multiline = 1;
    private static final int Id_STAR = 2;
    private static final int Id_input = 3;
    private static final int Id_UNDERSCORE = 4;
    private static final int Id_lastMatch = 5;
    private static final int Id_AMPERSAND = 6;
    private static final int Id_lastParen = 7;
    private static final int Id_PLUS = 8;
    private static final int Id_leftContext = 9;
    private static final int Id_BACK_QUOTE = 10;
    private static final int Id_rightContext = 11;
    private static final int Id_QUOTE = 12;
    private static final int DOLLAR_ID_BASE = 12;
    private static final int Id_DOLLAR_1 = 13;
    private static final int Id_DOLLAR_2 = 14;
    private static final int Id_DOLLAR_3 = 15;
    private static final int Id_DOLLAR_4 = 16;
    private static final int Id_DOLLAR_5 = 17;
    private static final int Id_DOLLAR_6 = 18;
    private static final int Id_DOLLAR_7 = 19;
    private static final int Id_DOLLAR_8 = 20;
    private static final int Id_DOLLAR_9 = 21;
    private static final int MAX_INSTANCE_ID = 21;

    NativeRegExpCtor() {
    }

    @Override
    public String getFunctionName() {
        return "RegExp";
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp && (objectArray.length == 1 || objectArray[1] == Undefined.instance)) {
            return objectArray[0];
        }
        return this.construct(context, scriptable, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.compile(context, scriptable, objectArray);
        ScriptRuntime.setObjectProtoAndParent(nativeRegExp, scriptable);
        return nativeRegExp;
    }

    private static RegExpImpl getImpl() {
        Context context = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 21;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2;
        block31: {
            n2 = 0;
            String string2 = null;
            switch (string.length()) {
                case 2: {
                    switch (string.charAt(1)) {
                        case '&': {
                            if (string.charAt(0) != '$') break;
                            n2 = 6;
                            break block31;
                        }
                        case '\'': {
                            if (string.charAt(0) != '$') break;
                            n2 = 12;
                            break block31;
                        }
                        case '*': {
                            if (string.charAt(0) != '$') break;
                            n2 = 2;
                            break block31;
                        }
                        case '+': {
                            if (string.charAt(0) != '$') break;
                            n2 = 8;
                            break block31;
                        }
                        case '1': {
                            if (string.charAt(0) != '$') break;
                            n2 = 13;
                            break block31;
                        }
                        case '2': {
                            if (string.charAt(0) != '$') break;
                            n2 = 14;
                            break block31;
                        }
                        case '3': {
                            if (string.charAt(0) != '$') break;
                            n2 = 15;
                            break block31;
                        }
                        case '4': {
                            if (string.charAt(0) != '$') break;
                            n2 = 16;
                            break block31;
                        }
                        case '5': {
                            if (string.charAt(0) != '$') break;
                            n2 = 17;
                            break block31;
                        }
                        case '6': {
                            if (string.charAt(0) != '$') break;
                            n2 = 18;
                            break block31;
                        }
                        case '7': {
                            if (string.charAt(0) != '$') break;
                            n2 = 19;
                            break block31;
                        }
                        case '8': {
                            if (string.charAt(0) != '$') break;
                            n2 = 20;
                            break block31;
                        }
                        case '9': {
                            if (string.charAt(0) != '$') break;
                            n2 = 21;
                            break block31;
                        }
                        case '_': {
                            if (string.charAt(0) != '$') break;
                            n2 = 4;
                            break block31;
                        }
                        case '`': {
                            if (string.charAt(0) != '$') break;
                            n2 = 10;
                            break block31;
                        }
                    }
                    break;
                }
                case 5: {
                    string2 = "input";
                    n2 = 3;
                    break;
                }
                case 9: {
                    char c = string.charAt(4);
                    if (c == 'M') {
                        string2 = "lastMatch";
                        n2 = 5;
                        break;
                    }
                    if (c == 'P') {
                        string2 = "lastParen";
                        n2 = 7;
                        break;
                    }
                    if (c != 'i') break;
                    string2 = "multiline";
                    n2 = 1;
                    break;
                }
                case 11: {
                    string2 = "leftContext";
                    n2 = 9;
                    break;
                }
                case 12: {
                    string2 = "rightContext";
                    n2 = 11;
                }
            }
            if (string2 != null && string2 != string && !string2.equals(string)) {
                n2 = 0;
            }
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n = 4;
                return NativeRegExpCtor.instanceIdInfo(n, super.getMaxInstanceId() + n2);
            }
        }
        n = 5;
        return NativeRegExpCtor.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (1 <= n2 && n2 <= 21) {
            switch (n2) {
                case 1: {
                    return "multiline";
                }
                case 2: {
                    return "$*";
                }
                case 3: {
                    return "input";
                }
                case 4: {
                    return "$_";
                }
                case 5: {
                    return "lastMatch";
                }
                case 6: {
                    return "$&";
                }
                case 7: {
                    return "lastParen";
                }
                case 8: {
                    return "$+";
                }
                case 9: {
                    return "leftContext";
                }
                case 10: {
                    return "$`";
                }
                case 11: {
                    return "rightContext";
                }
                case 12: {
                    return "$'";
                }
            }
            int n3 = n2 - 12 - 1;
            char[] cArray = new char[]{'$', (char)(49 + n3)};
            return new String(cArray);
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        int n2 = n - super.getMaxInstanceId();
        if (1 <= n2 && n2 <= 21) {
            Object object;
            RegExpImpl regExpImpl = NativeRegExpCtor.getImpl();
            switch (n2) {
                case 1: 
                case 2: {
                    return ScriptRuntime.wrapBoolean(regExpImpl.multiline);
                }
                case 3: 
                case 4: {
                    object = regExpImpl.input;
                    break;
                }
                case 5: 
                case 6: {
                    object = regExpImpl.lastMatch;
                    break;
                }
                case 7: 
                case 8: {
                    object = regExpImpl.lastParen;
                    break;
                }
                case 9: 
                case 10: {
                    object = regExpImpl.leftContext;
                    break;
                }
                case 11: 
                case 12: {
                    object = regExpImpl.rightContext;
                    break;
                }
                default: {
                    int n3 = n2 - 12 - 1;
                    object = regExpImpl.getParenSubString(n3);
                }
            }
            return object == null ? "" : object.toString();
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        int n2 = n - super.getMaxInstanceId();
        switch (n2) {
            case 1: 
            case 2: {
                NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(object);
                return;
            }
            case 3: 
            case 4: {
                NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(object);
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }
}

