/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigOperatorAtom;
import org.scilab.forge.jlatexmath.BreakMarkAtom;
import org.scilab.forge.jlatexmath.CharAtom;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.CumulativeScriptsAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.JavaFontRenderingAtom;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.MathAtom;
import org.scilab.forge.jlatexmath.NewCommandMacro;
import org.scilab.forge.jlatexmath.OverUnderDelimiter;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.UnderscoreAtom;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TeXParser {
    TeXFormula a;
    private StringBuffer a;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private boolean b;
    private int g;
    private boolean c;
    private boolean d = true;
    private boolean e;
    protected static boolean a = false;
    private static final Set a;

    public TeXParser(String string, TeXFormula teXFormula) {
        this(string, teXFormula, true);
    }

    public TeXParser(boolean bl, String string, TeXFormula teXFormula) {
        this(string, teXFormula, false);
        this.e = bl;
        this.firstpass();
    }

    public TeXParser(boolean bl, String string, TeXFormula teXFormula, boolean bl2) {
        this.a = teXFormula;
        this.e = bl;
        if (string != null) {
            this.a = new StringBuffer(string);
            this.e = string.length();
            this.a = 0;
            if (bl2) {
                this.firstpass();
            }
        } else {
            this.a = null;
            this.a = 0;
            this.e = 0;
        }
    }

    public TeXParser(String string, TeXFormula teXFormula, boolean bl) {
        this(false, string, teXFormula, bl);
    }

    public TeXParser(boolean bl, String string, ArrayOfAtoms arrayOfAtoms, boolean bl2) {
        this(bl, string, (TeXFormula)arrayOfAtoms, bl2);
        this.c = true;
    }

    public TeXParser(boolean bl, String string, ArrayOfAtoms arrayOfAtoms, boolean bl2, boolean bl3) {
        this(bl, string, (TeXFormula)arrayOfAtoms, bl2, bl3);
        this.c = true;
    }

    public TeXParser(String string, ArrayOfAtoms arrayOfAtoms, boolean bl) {
        this(false, string, (TeXFormula)arrayOfAtoms, bl);
    }

    public TeXParser(boolean bl, String string, TeXFormula teXFormula, boolean bl2, boolean bl3) {
        this(bl, string, teXFormula, bl2);
        this.d = bl3;
    }

    public TeXParser(String string, TeXFormula teXFormula, boolean bl, boolean bl2) {
        this(false, string, teXFormula, bl);
        this.d = bl2;
    }

    public void reset(String string) {
        this.a = new StringBuffer(string);
        this.e = this.a.length();
        this.a.a = null;
        this.a = 0;
        this.b = 0;
        this.c = 0;
        this.d = 0;
        this.f = 0;
        this.b = false;
        this.g = 0;
        this.c = false;
        this.d = true;
        this.firstpass();
    }

    public boolean getIsPartial() {
        return this.e;
    }

    public int getLine() {
        return this.c;
    }

    public int getCol() {
        return this.a - this.d - 1;
    }

    public Atom getLastAtom() {
        Atom atom = this.a.a;
        if (atom instanceof RowAtom) {
            return ((RowAtom)atom).getLastAtom();
        }
        this.a.a = null;
        return atom;
    }

    public Atom getFormulaAtom() {
        Atom atom = this.a.a;
        this.a.a = null;
        return atom;
    }

    public void addAtom(Atom atom) {
        this.a.add(atom);
    }

    public void makeAtLetter() {
        ++this.g;
    }

    public void makeAtOther() {
        --this.g;
    }

    public boolean isAtLetter() {
        return this.g != 0;
    }

    public boolean isArrayMode() {
        return this.c;
    }

    public void setArrayMode(boolean bl) {
        this.c = bl;
    }

    public boolean isIgnoreWhiteSpace() {
        return this.d;
    }

    public boolean isMathMode() {
        return this.d;
    }

    public int getPos() {
        return this.a;
    }

    public int rewind(int n) {
        this.a -= n;
        return this.a;
    }

    public String getStringFromCurrentPos() {
        return this.a.substring(this.a);
    }

    public void finish() {
        this.a = this.a.length();
    }

    public void addRow() {
        if (!this.c) {
            throw new ParseException("You can add a row only in array mode !");
        }
        ((ArrayOfAtoms)this.a).addRow();
    }

    /*
     * Unable to fully structure code
     */
    private void firstpass() {
        block52: {
            if (this.e == 0) break block52;
            block42: while (this.a < this.e) {
                var1_1 = this.a.charAt(this.a);
                switch (var1_1) {
                    case '\\': {
                        var3_3 = this.a;
                        var2_2 = this.getCommand();
                        if (!"newcommand".equals(var2_2) && !"renewcommand".equals(var2_2)) ** GOTO lbl23
                        var4_4 = this.getOptsArgs(2, 2);
                        var5_5 = (MacroInfo)MacroInfo.a.get(var2_2);
                        try {
                            var5_5.invoke(this, var4_4);
                        }
                        catch (ParseException var6_6) {
                            if (this.e) ** GOTO lbl18
                            throw var6_6;
                        }
lbl18:
                        // 2 sources

                        this.a.delete(var3_3, this.a);
                        this.e = this.a.length();
                        this.a = var3_3;
                        continue block42;
lbl23:
                        // 1 sources

                        if (NewCommandMacro.isMacro(var2_2)) {
                            var5_5 = (MacroInfo)MacroInfo.a.get(var2_2);
                            var4_4 = this.getOptsArgs(var5_5.a, var5_5.a != false ? 1 : 0);
                            var4_4[0] = var2_2;
                            try {
                                this.a.replace(var3_3, this.a, (String)var5_5.invoke(this, var4_4));
                            }
                            catch (ParseException var6_7) {
                                if (!this.e) {
                                    throw var6_7;
                                }
                                var3_3 += var2_2.length() + 1;
                            }
                            this.e = this.a.length();
                            this.a = var3_3;
                            continue block42;
                        }
                        if ("begin".equals(var2_2)) {
                            var4_4 = this.getOptsArgs(1, 0);
                            var5_5 = (MacroInfo)MacroInfo.a.get(var4_4[1] + "@env");
                            if (var5_5 == null) {
                                if (this.e) continue block42;
                                throw new ParseException("Unknown environment: " + var4_4[1] + " at position " + this.getLine() + ":" + this.getCol());
                            }
                            try {
                                var6_8 = this.getOptsArgs(var5_5.a - 1, 0);
                                var7_11 = this.getGroup("\\begin{" + var4_4[1] + "}", "\\end{" + var4_4[1] + "}");
                                var8_12 = "{\\makeatletter \\" + var4_4[1] + "@env";
                                for (var9_13 = 1; var9_13 <= var5_5.a - 1; ++var9_13) {
                                    var8_12 = var8_12 + "{" + var6_8[var9_13] + "}";
                                }
                                var8_12 = var8_12 + "{" + var7_11 + "}\\makeatother}";
                                this.a.replace(var3_3, this.a, var8_12);
                                this.e = this.a.length();
                                this.a = var3_3;
                                continue block42;
                            }
                            catch (ParseException var6_9) {
                                if (this.e) continue block42;
                                throw var6_9;
                            }
                        }
                        if ("makeatletter".equals(var2_2)) {
                            ++this.g;
                            continue block42;
                        }
                        if ("makeatother".equals(var2_2)) {
                            --this.g;
                            continue block42;
                        }
                        if (!TeXParser.a.contains(var2_2)) continue block42;
                        this.getOptsArgs(1, 0);
                        continue block42;
                    }
                    case '%': {
                        ++this.a;
                        while (this.a < this.e && (var6_10 = this.a.charAt(this.a++)) != '\r' && var6_10 != '\n') {
                        }
                        if (this.a < this.e) {
                            --this.a;
                        }
                        this.a.replace(var3_3, this.a, "");
                        this.e = this.a.length();
                        this.a = var3_3;
                        continue block42;
                    }
                    case '\u00b0': {
                        this.a.replace(this.a, this.a + 1, "^\\circ");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u00b2': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{2}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u00b3': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{3}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u00b9': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{1}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2070': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{0}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2074': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{4}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2075': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{5}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2076': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{6}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2077': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{7}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2078': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{8}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2079': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{9}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u207a': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{+}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u207b': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{-}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u207c': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{=}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u207d': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{(}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u207e': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{)}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u207f': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsup{n}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2082': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{2}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2083': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{3}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2081': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{1}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2080': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{0}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2084': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{4}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2085': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{5}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2086': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{6}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2087': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{7}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2088': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{8}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u2089': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{9}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u208a': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{+}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u208b': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{-}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u208c': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{=}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u208d': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{(}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                    case '\u208e': {
                        this.a.replace(this.a, this.a + 1, "\\jlatexmathcumsub{)}");
                        this.e = this.a.length();
                        ++this.a;
                        continue block42;
                    }
                }
                ++this.a;
            }
            this.a = 0;
            this.e = this.a.length();
        }
    }

    public void parse() {
        if (this.e != 0) {
            block15: while (this.a < this.e) {
                char c2 = this.a.charAt(this.a);
                block0 : switch (c2) {
                    case '\n': {
                        ++this.c;
                        this.d = this.a;
                    }
                    case '\t': 
                    case '\r': {
                        ++this.a;
                        break;
                    }
                    case ' ': {
                        ++this.a;
                        if (this.d) continue block15;
                        this.a.add(new SpaceAtom());
                        this.a.add(new BreakMarkAtom());
                        while (this.a < this.e && (c2 = this.a.charAt(this.a)) == ' ' && c2 == '\t') {
                            if (c2 != '\r') break block0;
                            ++this.a;
                        }
                        continue block15;
                    }
                    case '$': {
                        ++this.a;
                        if (this.d) continue block15;
                        int n = 2;
                        boolean bl = false;
                        if (this.a.charAt(this.a) == '$') {
                            n = 0;
                            bl = true;
                            ++this.a;
                        }
                        this.a.add(new MathAtom(new TeXFormula((TeXParser)this, (String)this.getDollarGroup((char)'$'), (boolean)false).a, n));
                        if (!bl || this.a.charAt(this.a) != '$') continue block15;
                        ++this.a;
                        break;
                    }
                    case '\\': {
                        Atom atom = this.processEscape();
                        this.a.add(atom);
                        if (this.c && atom instanceof HlineAtom) {
                            ((ArrayOfAtoms)this.a).addRow();
                        }
                        if (!this.b) continue block15;
                        this.b = false;
                        break;
                    }
                    case '{': {
                        Atom atom = this.getArgument();
                        if (atom != null) {
                            atom.a = 0;
                        }
                        this.a.add(atom);
                        break;
                    }
                    case '}': {
                        --this.f;
                        ++this.a;
                        if (this.f == -1) {
                            throw new ParseException("Found a closing '}' without an opening '{'!");
                        }
                        return;
                    }
                    case '^': {
                        this.a.add(this.getScripts(c2));
                        break;
                    }
                    case '_': {
                        if (this.d) {
                            this.a.add(this.getScripts(c2));
                            break;
                        }
                        this.a.add(new UnderscoreAtom());
                        ++this.a;
                        break;
                    }
                    case '&': {
                        if (!this.c) {
                            throw new ParseException("Character '&' is only available in array mode !");
                        }
                        ((ArrayOfAtoms)this.a).addCol();
                        ++this.a;
                        break;
                    }
                    case '\'': {
                        if (this.d) {
                            this.a.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                        } else {
                            this.a.add(this.convertCharacter('\'', true));
                        }
                        ++this.a;
                        break;
                    }
                    case '\u2035': {
                        if (this.d) {
                            this.a.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("backprime")));
                        } else {
                            this.a.add(this.convertCharacter('\u2035', true));
                        }
                        ++this.a;
                        break;
                    }
                    case '\"': {
                        if (this.d) {
                            this.a.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                            this.a.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                        } else {
                            this.a.add(this.convertCharacter('\'', true));
                            this.a.add(this.convertCharacter('\'', true));
                        }
                        ++this.a;
                        break;
                    }
                    default: {
                        this.a.add(this.convertCharacter(c2, false));
                        ++this.a;
                    }
                }
            }
        }
        if (this.a.a == null && !this.c) {
            this.a.add(new EmptyAtom());
        }
    }

    private Atom getScripts(char c2) {
        Atom atom;
        ++this.a;
        Atom atom2 = this.getArgument();
        Atom atom3 = null;
        char c3 = '\u0000';
        if (this.a < this.e) {
            c3 = this.a.charAt(this.a);
        }
        if (c2 == '^' && c3 == '^') {
            atom3 = atom2;
            atom2 = null;
        } else if (c2 == '_' && c3 == '^') {
            ++this.a;
            atom3 = this.getArgument();
        } else if (c2 == '^' && c3 == '_') {
            ++this.a;
            atom3 = atom2;
            atom2 = this.getArgument();
        } else if (c2 == '^' && c3 != '_') {
            atom3 = atom2;
            atom2 = null;
        }
        if (this.a.a instanceof RowAtom) {
            atom = ((RowAtom)this.a.a).getLastAtom();
        } else if (this.a.a == null) {
            atom = new PhantomAtom(new CharAtom('M', "mathnormal"), false, true, true);
        } else {
            atom = this.a.a;
            this.a.a = null;
        }
        if (atom.getRightType() == 1) {
            return new BigOperatorAtom(atom, atom2, atom3);
        }
        if (atom instanceof OverUnderDelimiter) {
            if (((OverUnderDelimiter)atom).isOver()) {
                if (atom3 != null) {
                    ((OverUnderDelimiter)atom).addScript(atom3);
                    return new ScriptsAtom(atom, atom2, null);
                }
            } else if (atom2 != null) {
                ((OverUnderDelimiter)atom).addScript(atom2);
                return new ScriptsAtom(atom, null, atom3);
            }
        }
        return new ScriptsAtom(atom, atom2, atom3);
    }

    public String getDollarGroup(char c2) {
        char c3;
        int n = this.a;
        do {
            if ((c3 = this.a.charAt(this.a++)) != '\\') continue;
            ++this.a;
        } while (this.a < this.e && c3 != c2);
        if (c3 == c2) {
            return this.a.substring(n, this.a - 1);
        }
        return this.a.substring(n, this.a);
    }

    public String getGroup(char c2, char c3) {
        if (this.a == this.e) {
            return null;
        }
        char c4 = this.a.charAt(this.a);
        if (this.a < this.e && c4 == c2) {
            int n = 1;
            int n2 = this.a;
            while (this.a < this.e - 1 && n != 0) {
                ++this.a;
                c4 = this.a.charAt(this.a);
                if (c4 == c2) {
                    ++n;
                    continue;
                }
                if (c4 == c3) {
                    --n;
                    continue;
                }
                if (c4 != '\\' || this.a == this.e - 1) continue;
                ++this.a;
            }
            ++this.a;
            if (n != 0) {
                return this.a.substring(n2 + 1, this.a);
            }
            return this.a.substring(n2 + 1, this.a - 1);
        }
        throw new ParseException("missing '" + c2 + "'!");
    }

    public String getGroup(String string, String string2) {
        int n = 1;
        int n2 = string.length();
        int n3 = string2.length();
        boolean bl = this.isValidCharacterInCommand(string.charAt(n2 - 1));
        boolean bl2 = this.isValidCharacterInCommand(string2.charAt(n3 - 1));
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        char c2 = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (this.a < this.e && n != 0) {
            char c3 = this.a.charAt(this.a);
            if (c2 != '\\' && c3 == ' ') {
                while (this.a < this.e && this.a.charAt(this.a++) == ' ') {
                    stringBuffer.append(' ');
                }
                c3 = this.a.charAt(--this.a);
                if (this.isValidCharacterInCommand(c2) && this.isValidCharacterInCommand(c3)) {
                    n5 = 0;
                    n4 = 0;
                }
            }
            n4 = c3 == string.charAt(n4) ? ++n4 : 0;
            if (c3 == string2.charAt(n5)) {
                if (n5 == 0) {
                    n6 = this.a;
                }
                ++n5;
            } else {
                n5 = 0;
            }
            if (this.a + 1 < this.e) {
                char c4 = this.a.charAt(this.a + 1);
                if (n4 == n2) {
                    if (!bl || !this.isValidCharacterInCommand(c4)) {
                        ++n;
                    }
                    n4 = 0;
                }
                if (n5 == n3) {
                    if (!bl2 || !this.isValidCharacterInCommand(c4)) {
                        --n;
                    }
                    n5 = 0;
                }
            } else {
                if (n4 == n2) {
                    ++n;
                    n4 = 0;
                }
                if (n5 == n3) {
                    --n;
                    n5 = 0;
                }
            }
            c2 = c3;
            stringBuffer.append(c3);
            ++this.a;
        }
        if (n != 0) {
            if (this.e) {
                return stringBuffer.toString();
            }
            throw new ParseException("The token " + string + " must be closed by " + string2);
        }
        return stringBuffer.substring(0, stringBuffer.length() - this.a + n6);
    }

    public Atom getArgument() {
        this.skipWhiteSpace();
        if (this.a >= this.e) {
            return new EmptyAtom();
        }
        char c2 = this.a.charAt(this.a);
        if (c2 == '{') {
            TeXFormula teXFormula = new TeXFormula();
            TeXFormula teXFormula2 = this.a;
            this.a = teXFormula;
            ++this.a;
            ++this.f;
            this.parse();
            this.a = teXFormula2;
            if (this.a.a == null) {
                RowAtom rowAtom = new RowAtom();
                rowAtom.add(teXFormula.a);
                return rowAtom;
            }
            return teXFormula.a;
        }
        if (c2 == '\\') {
            Atom atom = this.processEscape();
            if (this.b) {
                this.b = false;
                return this.getArgument();
            }
            return atom;
        }
        Atom atom = this.convertCharacter(c2, true);
        ++this.a;
        return atom;
    }

    public String getOverArgument() {
        String string;
        if (this.a == this.e) {
            return null;
        }
        int n = 1;
        char c2 = '\u0000';
        int n2 = this.a;
        while (this.a < this.e && n != 0) {
            c2 = this.a.charAt(this.a);
            switch (c2) {
                case '{': {
                    ++n;
                    break;
                }
                case '&': {
                    if (n != 1) break;
                    --n;
                    break;
                }
                case '}': {
                    --n;
                    break;
                }
                case '\\': {
                    ++this.a;
                    if (this.a < this.e && this.a.charAt(this.a) == '\\' && n == 1) {
                        --n;
                        --this.a;
                        break;
                    }
                    if (this.a >= this.e - 1 || this.a.charAt(this.a) != 'c' || this.a.charAt(this.a + 1) != 'r' || n != 1) break;
                    --n;
                    --this.a;
                }
            }
            ++this.a;
        }
        if (n >= 2) {
            throw new ParseException("Illegal end,  missing '}' !");
        }
        if (n == 0) {
            string = this.a.substring(n2, this.a - 1);
        } else {
            string = this.a.substring(n2, this.a);
            c2 = '\u0000';
        }
        if (c2 == '&' || c2 == '\\' || c2 == '}') {
            --this.a;
        }
        return string;
    }

    public float[] getLength() {
        if (this.a == this.e) {
            return null;
        }
        boolean bl = true;
        int n = 0;
        this.skipWhiteSpace();
        int n2 = this.a;
        while (this.a < this.e && n != 32) {
            n = this.a.charAt(this.a++);
        }
        this.skipWhiteSpace();
        return SpaceAtom.getLength(this.a.substring(n2, this.a - 1));
    }

    public Atom convertCharacter(char c2, boolean bl) {
        if (this.d) {
            if (c2 >= '\u03b1' && c2 <= '\u03c9') {
                return SymbolAtom.get(TeXFormula.a[c2]);
            }
            if (c2 >= '\u0391' && c2 <= '\u03a9') {
                return new TeXFormula((String)TeXFormula.c[c2]).a;
            }
        }
        if (!((c2 = TeXParser.convertToRomanNumber(c2)) >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            String string;
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
            if (!a && !DefaultTeXFont.a.contains(unicodeBlock)) {
                DefaultTeXFont.addAlphabet((AlphabetRegistration)DefaultTeXFont.a.get(unicodeBlock));
            }
            if ((string = TeXFormula.a[c2]) == null && (TeXFormula.c == null || TeXFormula.c[c2] == null)) {
                TeXFormula.FontInfos fontInfos = null;
                boolean bl2 = Character.UnicodeBlock.BASIC_LATIN.equals(unicodeBlock);
                if (bl2 && TeXFormula.isRegisteredBlock(Character.UnicodeBlock.BASIC_LATIN) || !bl2) {
                    fontInfos = TeXFormula.getExternalFont(unicodeBlock);
                }
                if (fontInfos != null) {
                    if (bl) {
                        return new JavaFontRenderingAtom(Character.toString(c2), fontInfos);
                    }
                    int n = this.a++;
                    int n2 = this.e - 1;
                    while (this.a < this.e) {
                        c2 = this.a.charAt(this.a);
                        if (!Character.UnicodeBlock.of(c2).equals(unicodeBlock)) {
                            n2 = --this.a;
                            break;
                        }
                        ++this.a;
                    }
                    return new JavaFontRenderingAtom(this.a.substring(n, n2 + 1), fontInfos);
                }
                if (!this.e) {
                    throw new ParseException("Unknown character : '" + Character.toString(c2) + "' (or " + c2 + ")");
                }
                return new ColorAtom(new RomanAtom(new TeXFormula((String)new StringBuilder().append((String)"\\text{(Unknown char ").append((int)c2).append((String)")}").toString()).a), null, Color.RED);
            }
            if (!this.d && TeXFormula.b[c2] != null) {
                return SymbolAtom.get(TeXFormula.b[c2]).setUnicode(c2);
            }
            if (TeXFormula.c != null && TeXFormula.c[c2] != null) {
                return new TeXFormula((String)TeXFormula.c[c2]).a;
            }
            try {
                return SymbolAtom.get(string);
            }
            catch (SymbolNotFoundException symbolNotFoundException) {
                throw new ParseException("The character '" + Character.toString(c2) + "' was mapped to an unknown symbol with the name '" + string + "'!", symbolNotFoundException);
            }
        }
        TeXFormula.FontInfos fontInfos = (TeXFormula.FontInfos)TeXFormula.c.get(Character.UnicodeBlock.BASIC_LATIN);
        if (fontInfos != null) {
            if (bl) {
                return new JavaFontRenderingAtom(Character.toString(c2), fontInfos);
            }
            int n = this.a++;
            int n3 = this.e - 1;
            while (this.a < this.e) {
                c2 = this.a.charAt(this.a);
                if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    n3 = --this.a;
                    break;
                }
                ++this.a;
            }
            return new JavaFontRenderingAtom(this.a.substring(n, n3 + 1), fontInfos);
        }
        return new CharAtom(c2, this.a.a);
    }

    private String getCommand() {
        String string;
        int n = ++this.a;
        char c2 = '\u0000';
        while (this.a < this.e && ((c2 = this.a.charAt(this.a)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || this.g != 0 && c2 == '@')) {
            ++this.a;
        }
        if (c2 == '\u0000') {
            return "";
        }
        if (this.a == n) {
            ++this.a;
        }
        if ("cr".equals(string = this.a.substring(n, this.a)) && this.a < this.e && this.a.charAt(this.a) == ' ') {
            ++this.a;
        }
        return string;
    }

    private Atom processEscape() {
        this.b = this.a;
        String string = this.getCommand();
        if (string.length() == 0) {
            return new EmptyAtom();
        }
        if (MacroInfo.a.get(string) != null) {
            return this.processCommands(string);
        }
        try {
            return TeXFormula.get((String)string).a;
        }
        catch (FormulaNotFoundException formulaNotFoundException) {
            try {
                return SymbolAtom.get(string);
            }
            catch (SymbolNotFoundException symbolNotFoundException) {
                if (!this.e) {
                    throw new ParseException("Unknown symbol or command or predefined TeXFormula: '" + string + "'");
                }
                return new ColorAtom(new RomanAtom(new TeXFormula((String)new StringBuilder().append((String)"\\backslash ").append((String)string).toString()).a), null, Color.RED);
            }
        }
    }

    private void insert(int n, int n2, String string) {
        this.a.replace(n, n2, string);
        this.e = this.a.length();
        this.a = n;
        this.b = true;
    }

    public String[] getOptsArgs(int n, int n2) {
        String[] stringArray = new String[n + 10 + 1];
        if (n != 0) {
            if (n2 == 1) {
                try {
                    for (int i = n + 1; i < n + 11; ++i) {
                        this.skipWhiteSpace();
                        stringArray[i] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException parseException) {
                    stringArray[i] = null;
                }
            }
            this.skipWhiteSpace();
            try {
                stringArray[1] = this.getGroup('{', '}');
            }
            catch (ParseException parseException) {
                if (this.a.charAt(this.a) != '\\') {
                    stringArray[1] = "" + this.a.charAt(this.a);
                    ++this.a;
                }
                stringArray[1] = this.getCommandWithArgs(this.getCommand());
            }
            if (n2 == 2) {
                try {
                    for (int i = n + 1; i < n + 11; ++i) {
                        this.skipWhiteSpace();
                        stringArray[i] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException parseException) {
                    stringArray[i] = null;
                }
            }
            for (int i = 2; i <= n; ++i) {
                this.skipWhiteSpace();
                try {
                    stringArray[i] = this.getGroup('{', '}');
                    continue;
                }
                catch (ParseException parseException) {
                    if (this.a.charAt(this.a) != '\\') {
                        stringArray[i] = "" + this.a.charAt(this.a);
                        ++this.a;
                        continue;
                    }
                    stringArray[i] = this.getCommandWithArgs(this.getCommand());
                }
            }
            if (this.d) {
                this.skipWhiteSpace();
            }
        }
        return stringArray;
    }

    private String getCommandWithArgs(String string) {
        if (string.equals("left")) {
            return this.getGroup("\\left", "\\right");
        }
        MacroInfo macroInfo = (MacroInfo)MacroInfo.a.get(string);
        if (macroInfo != null) {
            String string2;
            int n;
            int n2 = 0;
            if (macroInfo.a) {
                n2 = macroInfo.b;
            }
            String[] stringArray = this.getOptsArgs(macroInfo.a, n2);
            StringBuffer stringBuffer = new StringBuffer("\\");
            stringBuffer.append(string);
            for (n = 0; n < macroInfo.b; ++n) {
                string2 = stringArray[macroInfo.a + n + 1];
                if (string2 == null) continue;
                stringBuffer.append("[").append(string2).append("]");
            }
            for (n = 0; n < macroInfo.a; ++n) {
                string2 = stringArray[n + 1];
                if (string2 == null) continue;
                stringBuffer.append("{").append(string2).append("}");
            }
            return stringBuffer.toString();
        }
        return "\\" + string;
    }

    private Atom processCommands(String string) {
        MacroInfo macroInfo = (MacroInfo)MacroInfo.a.get(string);
        int n = 0;
        if (macroInfo.a) {
            n = macroInfo.b;
        }
        String[] stringArray = this.getOptsArgs(macroInfo.a, n);
        stringArray[0] = string;
        if (NewCommandMacro.isMacro(string)) {
            String string2 = (String)macroInfo.invoke(this, stringArray);
            this.insert(this.b, this.a, string2);
            return null;
        }
        return (Atom)macroInfo.invoke(this, stringArray);
    }

    public final boolean isValidName(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char c2 = '\u0000';
        if (string.charAt(0) == '\\') {
            int n = string.length();
            for (int i = 1; i < n && (Character.isLetter(c2 = string.charAt(i)) || this.g != 0 && c2 == '@'); ++i) {
            }
        } else {
            return false;
        }
        return Character.isLetter(c2);
    }

    public final boolean isValidCharacterInCommand(char c2) {
        return Character.isLetter(c2) || this.g != 0 && c2 == '@';
    }

    private final void skipWhiteSpace() {
        char c2;
        while (this.a < this.e && ((c2 = this.a.charAt(this.a)) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r')) {
            if (c2 == '\n') {
                ++this.c;
                this.d = this.a;
            }
            ++this.a;
        }
    }

    private static char convertToRomanNumber(char c2) {
        if (c2 == '\u066b') {
            return '.';
        }
        if ('\u0660' <= c2 && c2 <= '\u0669') {
            return (char)(c2 - 1584);
        }
        if ('\u06f0' <= c2 && c2 <= '\u06f9') {
            return (char)(c2 - 1728);
        }
        if ('\u0966' <= c2 && c2 <= '\u096f') {
            return (char)(c2 - 2358);
        }
        if ('\u09e6' <= c2 && c2 <= '\u09ef') {
            return (char)(c2 - 2486);
        }
        if ('\u0a66' <= c2 && c2 <= '\u0a6f') {
            return (char)(c2 - 2614);
        }
        if ('\u0ae6' <= c2 && c2 <= '\u0aef') {
            return (char)(c2 - 2742);
        }
        if ('\u0b66' <= c2 && c2 <= '\u0b6f') {
            return (char)(c2 - 2870);
        }
        if ('\u0c66' <= c2 && c2 <= '\u0c6f') {
            return (char)(c2 - 3126);
        }
        if ('\u0d66' <= c2 && c2 <= '\u0d6f') {
            return (char)(c2 - 3382);
        }
        if ('\u0e50' <= c2 && c2 <= '\u0e59') {
            return (char)(c2 - 3616);
        }
        if ('\u0ed0' <= c2 && c2 <= '\u0ed9') {
            return (char)(c2 - 3744);
        }
        if ('\u0f20' <= c2 && c2 <= '\u0f29') {
            return (char)(c2 - 3728);
        }
        if ('\u1040' <= c2 && c2 <= '\u1049') {
            return (char)(c2 - 4112);
        }
        if ('\u17e0' <= c2 && c2 <= '\u17e9') {
            return (char)(c2 - 6064);
        }
        if ('\u1810' <= c2 && c2 <= '\u1819') {
            return (char)(c2 - 6112);
        }
        if ('\u1b50' <= c2 && c2 <= '\u1b59') {
            return (char)(c2 - 6944);
        }
        if ('\u1bb0' <= c2 && c2 <= '\u1bb9') {
            return (char)(c2 - 7040);
        }
        if ('\u1c40' <= c2 && c2 <= '\u1c49') {
            return (char)(c2 - 7184);
        }
        if ('\u1c50' <= c2 && c2 <= '\u1c59') {
            return (char)(c2 - 7200);
        }
        if ('\ua8d0' <= c2 && c2 <= '\ua8d9') {
            return (char)(c2 - 43168);
        }
        return c2;
    }

    static {
        a = new HashSet(6);
        a.add("jlmDynamic");
        a.add("jlmText");
        a.add("jlmTextit");
        a.add("jlmTextbf");
        a.add("jlmTextitbf");
        a.add("jlmExternalFont");
    }
}

