/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.io;

import java.awt.Frame;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.geocentral.geometria.io.GFileChooser;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.io.GRemoteFileHandler;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GRemoteFileReader
extends GRemoteFileHandler
implements GFileReader {
    private String filePath;
    private Frame ownerFrame;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GRemoteFileReader(Frame ownerFrame, URL baseUrl) {
        super(baseUrl);
        logger.info((Object)baseUrl);
        this.ownerFrame = ownerFrame;
    }

    @Override
    public void selectFile() throws Exception {
        logger.info((Object)"");
        GFileChooser treeNodeChooser = new GFileChooser(this.docTreeElement, this.ownerFrame, this.filePath);
        int option = treeNodeChooser.showOpenDialog(null);
        this.filePath = option == 0 ? treeNodeChooser.getSelectionPath() : null;
        logger.info((Object)this.filePath);
    }

    public void selectFile(Frame ownerFrame) {
    }

    @Override
    public InputStream getInputStream() throws Exception {
        logger.info((Object)this.filePath);
        try {
            URL url = new URL(this.baseUrl.getProtocol(), this.baseUrl.getHost(), this.baseUrl.getPort(), this.baseUrl.getPath() + this.filePath);
            logger.info((Object)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (Exception exception) {
            logger.error((Object)this.filePath);
            throw new Exception(GDictionary.get("CannotReadRemoteFile", this.baseUrl.getPath() + this.filePath));
        }
    }

    @Override
    public String getSelectedFilePath() {
        return this.filePath;
    }

    @Override
    public String getSelectedFileName() {
        String[] tokens = this.filePath.split("/");
        return tokens[tokens.length - 1];
    }
}

