/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLog;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.util.GVersionManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class GSolution
extends GDocument {
    private GDocumentEnvelope envelope;
    private GProblem problem;
    private GLog log;
    private Collection<GFigure> importedFigures;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GSolution() {
        this.envelope = new GDocumentEnvelope();
        this.problem = new GProblem();
        this.log = new GLog();
    }

    public GSolution(GProblem problem) {
        this.problem = problem;
        this.envelope = new GDocumentEnvelope();
        this.log = new GLog();
    }

    public GSolution(GSolution masterSolution) {
        this.problem = masterSolution.getProblem();
        this.importFigures(this.problem);
    }

    public void importFigures(GDocument document) {
        logger.info((Object)"");
        this.removeAllFigures();
        this.importedFigures = new LinkedHashSet<GFigure>();
        Iterator<GFigure> it = document.getFigureIterator();
        while (it.hasNext()) {
            GFigure figure = it.next();
            GFigure f = null;
            f = figure.clone();
            this.addFigure(f);
            this.importedFigures.add(f);
        }
        this.setSelectedFigure(0);
    }

    @Override
    public void make(Element node, GXmlEntity parent) throws Exception {
        logger.info((Object)"");
        this.makeVersion(node, parent);
        Element n = (Element)node.getElementsByTagName("envelope").item(0);
        this.envelope.make(n);
        n = (Element)node.getElementsByTagName("problem").item(0);
        this.problem.make(n, this);
        n = (Element)node.getElementsByTagName("log").item(0);
        this.log.make(n);
    }

    @Override
    public String getSchemaFile(String version) {
        return GVersionManager.getInstance().getSolutionSchema(version);
    }

    @Override
    public void serialize(StringBuffer buf, boolean preamble) {
        logger.info((Object)"");
        if (preamble) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n<solution xmlns=\"").append("http://geocentral.net").append("\">").append("\n<version>").append(GVersionManager.getInstance().getApplicationVersion()).append("</version>");
        } else {
            buf.append("\n<solution>");
        }
        this.envelope.serialize(buf);
        this.problem.serialize(buf);
        this.log.serialize(buf);
        buf.append("\n</solution>\n");
    }

    @Override
    public GDocumentEnvelope getEnvelope() {
        return this.envelope;
    }

    @Override
    public void setEnvelope(GDocumentEnvelope envelope) {
        logger.info((Object)envelope);
        this.envelope = envelope;
    }

    public GProblem getProblem() {
        return this.problem;
    }

    public GLog getLog() {
        return this.log;
    }

    public boolean isImported(GFigure figure) {
        return this.importedFigures.contains(figure);
    }
}

