/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer.condition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.answer.condition.GFigureCondition;
import net.geocentral.geometria.model.answer.condition.GLineSetCondition;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GHamiltonianCycleCondition
implements GLineSetCondition,
GFigureCondition {
    private String figureName;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() < 1) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        if (document.getFigure(this.figureName) == null) {
            logger.error((Object)this.figureName);
            throw new Exception();
        }
    }

    @Override
    public void validate(String valueString, GDocument document) throws Exception {
        logger.info((Object)valueString);
        GFigure figure = document.getSelectedFigure();
        if (figure == null) {
            logger.info((Object)"No figure selected");
            throw new Exception(GDictionary.get("NoFigureSelected", new String[0]));
        }
        this.figureName = figure.getName();
    }

    @Override
    public boolean verify(List<GPoint3d[]> lines, GDocument document) {
        logger.info(lines);
        GFigure figure = document.getFigure(this.figureName);
        if (figure == null) {
            return false;
        }
        GSolid solid = figure.getSolid();
        HashSet<GPoint3d> vertices = new HashSet<GPoint3d>();
        Iterator<GPoint3d> iterator = solid.pointIterator();
        while (iterator.hasNext()) {
            GPoint3d p = iterator.next();
            if (!p.isVertex()) continue;
            vertices.add(p);
        }
        HashMap<GPoint3d, Integer> psOccurrence = new HashMap<GPoint3d, Integer>();
        for (GPoint3d[] gPoint3dArray : lines) {
            for (int pIndex = 0; pIndex < 2; ++pIndex) {
                GPoint3d p = gPoint3dArray[pIndex];
                if (!vertices.contains(p)) {
                    return false;
                }
                Integer pOccurrence = (Integer)psOccurrence.get(p);
                if (pOccurrence == null) {
                    pOccurrence = 0;
                } else if (pOccurrence > 1) {
                    return false;
                }
                psOccurrence.put(p, pOccurrence + 1);
            }
        }
        if (psOccurrence.size() != vertices.size()) {
            return false;
        }
        for (Map.Entry entry : psOccurrence.entrySet()) {
            if ((Integer)entry.getValue() == 2) continue;
            return false;
        }
        solid.selectLines(lines);
        figure.repaint();
        return true;
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<condition>");
        buf.append("\n<type>hamiltonianCycle</type>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        buf.append("\n</condition>");
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getDescription() {
        return GDictionary.get("HamiltonianCycle", new String[0]);
    }

    @Override
    public void figureRenamed(GRenameFigureAction action) {
        logger.info((Object)"");
        if (action.getOldFigureName().equals(this.figureName)) {
            this.figureName = action.getNewFigureName();
        }
    }

    @Override
    public void renameFigureUndone(GRenameFigureAction action) {
        logger.info((Object)"");
        if (action.getNewFigureName().equals(this.figureName)) {
            this.figureName = action.getOldFigureName();
        }
    }
}

