/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.geocentral.geometria.action.GJoinAction;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GNoMoreJoinMatchesException;
import net.geocentral.geometria.util.GUndefinedJoinException;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GJoinDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GJoinAction action;
    private String[] figureNames;
    private JList figure1List;
    private JList figure2List;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GJoinDialog(Frame ownerFrame, GJoinAction action, String[] figureNames) {
        super(ownerFrame, true);
        logger.info(Arrays.asList(figureNames));
        this.action = action;
        this.figureNames = figureNames;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.BOTTOM_LEFT);
        this.setTitle(GDictionary.get("JoinFigures", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("FiguresToJoin", new String[0]));
        topPane.setLayout(new BoxLayout(topPane, 0));
        Dimension size = new Dimension(80, 80);
        int padding = 10;
        this.figure1List = new JList<String>(this.figureNames);
        this.figure1List.setSelectedIndex(0);
        JScrollPane sp1 = new JScrollPane(this.figure1List);
        sp1.setPreferredSize(size);
        sp1.setMaximumSize(size);
        topPane.add(sp1);
        topPane.add(Box.createRigidArea(new Dimension(padding, 10)));
        JPanel pane = GGraphicsFactory.getInstance().createImagePane("/images/Join.png");
        topPane.add(pane);
        topPane.add(Box.createRigidArea(new Dimension(padding, 10)));
        this.figure2List = new JList<String>(this.figureNames);
        this.figure1List.setSelectedIndex(0);
        JScrollPane sp2 = new JScrollPane(this.figure2List);
        sp2.setPreferredSize(size);
        sp2.setMaximumSize(size);
        topPane.add(sp2);
        this.getContentPane().add(topPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    public void prefill(String figureName) {
        logger.info((Object)figureName);
        this.figure1List.setSelectedValue(figureName, true);
        this.figure2List.setSelectedValue(figureName, true);
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        Object figure1Name = this.figure1List.getSelectedValue();
        Object figure2Name = this.figure2List.getSelectedValue();
        if (figure1Name == null || figure2Name == null) {
            return;
        }
        this.action.setFigureNames(String.valueOf(figure1Name), String.valueOf(figure2Name));
        try {
            this.action.validateApply(this);
        }
        catch (Exception exception) {
            if (exception instanceof GUndefinedJoinException || exception instanceof GNoMoreJoinMatchesException) {
                this.result = false;
                this.dispose();
                return;
            }
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

