/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import net.geocentral.geometria.action.GSolutionAnswerAction;
import net.geocentral.geometria.model.answer.GMultipleChoiceAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GSolutionMultipleChoiceAnswerDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GSolutionAnswerAction action;
    private GMultipleChoiceAnswer problemAnswer;
    private JRadioButton[] optionButtons;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GSolutionMultipleChoiceAnswerDialog(Frame ownerFrame, GSolutionAnswerAction action, GMultipleChoiceAnswer problemAnswer) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.action = action;
        this.problemAnswer = problemAnswer;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("Answer", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        inputPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel optionsPane = new JPanel();
        optionsPane.setLayout(new BoxLayout(optionsPane, 1));
        Map<String, Boolean> options = this.problemAnswer.getOptions();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.optionButtons = new JRadioButton[options.size()];
        int optionIndex = 0;
        for (Map.Entry<String, Boolean> entry : options.entrySet()) {
            String option = entry.getKey();
            JRadioButton optionButton = new JRadioButton(option);
            buttonGroup.add(optionButton);
            optionsPane.add(optionButton);
            this.optionButtons[optionIndex++] = optionButton;
        }
        inputPane.add(optionsPane);
        inputPane.add(Box.createGlue());
        this.getContentPane().add(inputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        String selectedOption = null;
        int optionIndex = 0;
        for (JRadioButton optionButton : this.optionButtons) {
            if (optionButton.isSelected()) {
                selectedOption = this.optionButtons[optionIndex].getText();
                break;
            }
            ++optionIndex;
        }
        if (selectedOption == null) {
            GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("SelectOption", new String[0]));
            return;
        }
        this.action.setInput(selectedOption, null);
        if (!this.problemAnswer.verify(optionIndex)) {
            this.dispose();
            GGraphicsFactory.getInstance().showAnswerEvaluation(false);
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
        GGraphicsFactory.getInstance().showAnswerEvaluation(true);
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

