/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GLog;

class LogRecordRenderer
extends JLabel
implements ListCellRenderer {
    private static final Color COMMENTED_COLOR = new Color(255, 255, 128);
    private GLog log;
    private static final long serialVersionUID = 1L;

    public LogRecordRenderer(GLog log) {
        this.log = log;
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        GLoggable record = (GLoggable)value;
        String comments = record.getComments();
        this.setText(record.toLogString());
        if (index == this.log.getCurrentPos()) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else if (comments != null) {
            this.setBackground(COMMENTED_COLOR);
            this.setForeground(list.getForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }
}

