/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.io.File;
import java.io.FileWriter;
import java.util.GregorianCalendar;
import java.util.Vector;
import jtides.JTides;
import jtides.TidesDoc;

public class HTMLPageBuilder {
    public static final String header = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    public static final String[] unitName = new String[]{"Meters", "Feet", "Knots"};
    public static final String[] dayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static final String[] monthShortName = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[] monthLongName = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    String metaTags;
    JTides main;

    public HTMLPageBuilder(JTides jTides) {
        this.main = jTides;
        this.metaTags = "<meta name=\"generator\" content=\"" + "JTides 5.3" + "\"/>\n<meta name=\"formatter\" content=\"" + "JTides 5.3" + "\"/>\n";
    }

    public String createMonthString(TidesDoc tidesDoc, String string, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        String string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, 1, 0, 0, 0);
        int n6 = gregorianCalendar.getActualMaximum(5);
        int n7 = gregorianCalendar.get(7) - 1;
        int n8 = (n7 + n6 - 1) / 7 + 1;
        String[][] stringArray = new String[7][n8];
        while (gregorianCalendar.get(2) == n2) {
            string2 = this.createDayData(tidesDoc, gregorianCalendar, n4, bl);
            int n9 = gregorianCalendar.get(5);
            int n10 = n9 + n7 - 1;
            int n11 = n10 % 7;
            n5 = n10 / 7;
            stringArray[n11][n5] = string2;
            gregorianCalendar.add(6, 1);
        }
        string2 = "";
        if (bl) {
            string2 = "&nbsp;&nbsp;";
            if (n2 > 0) {
                string2 = string2 + this.wrapTag("&lt;", "a", "href=\"" + monthLongName[n2 - 1] + ".html\"");
            }
            if (n2 < 11) {
                string2 = string2 + "&nbsp;" + this.wrapTag("&gt;", "a", "href=\"" + monthLongName[n2 + 1] + ".html\"");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n5 = 0; n5 < 7; ++n5) {
            String string3 = this.wrapTag(dayName[n5], "b");
            string3 = this.setFont(string3, n4, bl);
            stringBuffer2.append(this.wrapTag(string3, "td", "align=\"center\" bgcolor=\"" + this.main.configValues.htmlTitleColor + "\""));
        }
        stringBuffer.append(this.wrapTag(stringBuffer2.toString(), "tr"));
        for (n5 = 0; n5 < n8; ++n5) {
            stringBuffer2 = new StringBuffer();
            for (int i = 0; i < 7; ++i) {
                String string4 = stringArray[i][n5] != null ? this.wrapTag(stringArray[i][n5], "td", "valign=\"top\" bgcolor=\"" + this.main.configValues.htmlCellColor + "\"") : this.wrapTag("&nbsp;", "td");
                stringBuffer2.append(string4);
            }
            stringBuffer.append(this.wrapTag(stringBuffer2.toString(), "tr"));
        }
        String string5 = this.wrapTag(stringBuffer.toString(), "table", "bgcolor=\"" + this.main.configValues.htmlBgColor + "\" border=\"" + n3 + "\" cellpadding=\"" + this.main.configValues.htmlCellPadding + "\" cellspacing=\"" + this.main.configValues.htmlCellSpacing + "\"");
        String string6 = "";
        string6 = this.main.tideComp.isDST(gregorianCalendar) ? tidesDoc.siteSet.name + " (UTC" + this.plusSign((int)tidesDoc.siteSet.tz + 1) + ") (DT)" : tidesDoc.siteSet.name + " (UTC" + this.plusSign((int)tidesDoc.siteSet.tz) + ")";
        int n12 = (int)tidesDoc.siteSet.tz;
        String string7 = (n12 > 0 ? "+" : "") + n12;
        string6 = string6 + ", " + monthLongName[n2] + " " + n + ". Units: " + this.main.tideComp.getUnitsTag(tidesDoc.siteSet);
        String string8 = string6 + string2;
        string8 = this.setFont(string8, n4, bl);
        String string9 = this.wrapTag(string8, "b") + "<br/>";
        string9 = string9 + string5;
        if (bl) {
            string9 = string9 + string;
        }
        string9 = this.wrapTag(string9, "div", "align=\"center\"");
        String string10 = this.wrapTag(string9, "body");
        String string11 = this.wrapTag(string6, "title") + this.metaTags;
        string10 = this.wrapTag(string11, "head") + string10;
        string10 = this.wrapTag(string10, "html");
        string10 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n" + string10;
        return string10;
    }

    public void createMonthPage(TidesDoc tidesDoc, String string, File file, int n, int n2, int n3, int n4) {
        String string2 = this.createMonthString(tidesDoc, string, n, n2, n3, n4, true);
        File file2 = new File(file, "" + monthLongName[n2] + ".html");
        try {
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String setFont(String string, int n, boolean bl) {
        return bl ? string : this.wrapTag(string, "font", "style=\"font-size: " + n + "pt;\"");
    }

    private String createDayData(TidesDoc tidesDoc, GregorianCalendar gregorianCalendar, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = gregorianCalendar.get(5);
        String string = this.setFont("- " + n2 + " -", n, bl);
        String string2 = this.wrapTag(this.wrapTag(string, "b"), "a", "name=\"" + n2 + "\"");
        string2 = this.wrapTag(string2, "td", "align=\"center\" colspan=\"2\"");
        stringBuffer.append(this.wrapTag(string2, "tr"));
        long l = gregorianCalendar.getTime().getTime() / 1000L;
        long l2 = l + 86400L;
        long l3 = this.main.tideComp.getNextEventTime(tidesDoc.siteSet, l, false);
        long l4 = this.main.tideComp.getNextEventTime(tidesDoc.siteSet, l2, true);
        Vector vector = this.main.tideComp.predictTideEvents(tidesDoc.siteSet, l3, l4, l, l2, null, null);
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = this.main.tideComp.formatDataString(tidesDoc, i, vector, false, true, "", false, false, this.main.configValues.htmlIncludeHiLoText, "");
            if (string3.length() == 0) continue;
            string3 = string3.trim();
            int n3 = string3.lastIndexOf(32);
            if (this.main.configValues.htmlIncludeHiLoText) {
                n3 = string3.lastIndexOf(32, n3 - 1);
            }
            String string4 = string3.substring(0, n3).trim();
            string4 = this.setFont(string4, n, bl);
            String string5 = "&nbsp;" + string3.substring(n3).trim();
            string5 = this.setFont(string5, n, bl);
            String string6 = this.wrapTag(this.wrapTag(string4, "tt"), "td", "align=\"left\"");
            string6 = string6 + this.wrapTag(this.wrapTag(string5, "tt"), "td", "align=\"right\"");
            string6 = this.wrapTag(string6, "tr");
            stringBuffer.append(string6);
        }
        String string7 = this.wrapTag(stringBuffer.toString(), "table", "border=\"0\" cellpadding=\"0\" cellspacing=\"0\"");
        return string7;
    }

    public String wrapTag(String string, String string2) {
        return "<" + string2 + ">" + string + "</" + string2 + ">\n";
    }

    public String wrapTag(String string, String string2, String string3) {
        return "<" + string2 + " " + string3 + ">" + string + "</" + string2 + ">\n";
    }

    private String plusSign(int n) {
        String string = n > 0 ? "+" : "";
        return string + n;
    }
}

