/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.JDictionary;
import info.jdictionary.gui.NetworkErrorCenteredPanel;
import info.jdictionary.pluginstuff.PluginDownloader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class NewsAgent
extends JPanel
implements Runnable,
HyperlinkListener {
    JDictionary jDictionary;
    boolean success = false;
    JPanel jPanel = new JPanel();
    JLabel header = new JLabel();
    JScrollPane jScrollPane = new JScrollPane();
    JEditorPane newsPane;
    BorderLayout borderLayout = new BorderLayout();
    BoxLayout boxLayout;

    public NewsAgent(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.boxLayout = new BoxLayout(this, 1);
        this.setLayout(this.boxLayout);
        this.setBackground(Color.white);
        this.setAlignmentY(0.0f);
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.jPanel.setBackground(Color.white);
        this.jPanel.setAlignmentX(0.0f);
        this.jPanel.setMinimumSize(new Dimension(300, 100));
        this.jPanel.setLayout(this.borderLayout);
        this.jPanel.add(new JLabel(JDictionary.getString("DowndloadingNews"), IconBank.hourGlass, 0));
        this.header.setIcon(ImageBank.getImageByName("NewsAndInfoHeader.png"));
        this.add((Component)this.header, null);
        this.add((Component)this.jPanel, null);
    }

    void showMessage(String message, ImageIcon icon) {
        final JLabel label = new JLabel(message, icon, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewsAgent.this.jPanel.removeAll();
                NewsAgent.this.jPanel.add(label);
                NewsAgent.this.jPanel.validate();
                NewsAgent.this.jPanel.repaint();
            }
        });
    }

    void showMessage(String message) {
        this.showMessage(message, null);
    }

    void showComponent(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewsAgent.this.jPanel.removeAll();
                NewsAgent.this.jPanel.add(component);
                NewsAgent.this.jPanel.validate();
                NewsAgent.this.jPanel.repaint();
            }
        });
    }

    public void run() {
        URL url = this.getNewsURL();
        if (url == null) {
            this.success = false;
            this.showComponent(new NetworkErrorCenteredPanel(this.jDictionary));
            return;
        }
        this.newsPane = new JEditorPane();
        this.newsPane.setContentType("text/html");
        this.newsPane.setEditable(false);
        this.newsPane.addHyperlinkListener(this);
        this.jScrollPane.getViewport().add(this.newsPane);
        try {
            this.newsPane.setPage(url);
        }
        catch (Exception e) {
            try {
                this.newsPane.setPage(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.success = false;
                this.showComponent(new NetworkErrorCenteredPanel(this.jDictionary));
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewsAgent.this.jPanel.removeAll();
                NewsAgent.this.jPanel.add(NewsAgent.this.jScrollPane);
                NewsAgent.this.jPanel.validate();
                NewsAgent.this.jPanel.repaint();
            }
        });
        this.success = true;
        this.jDictionary.getPrefs().lastCheckedNewsVersion = this.jDictionary.getNewsChecker().getLatest();
    }

    URL getNewsURL() {
        try {
            URL url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("NewsPage")).append("_").append(JDictionary.getLanguage()).append(".html"))));
            if (url.openConnection().getContentLength() > 3800) {
                URL uRL = url;
                return uRL;
            }
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("NewsPage")).append(".html"))));
            if (url.openConnection().getContentLength() > 3800) {
                URL uRL = url;
                return uRL;
            }
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("NewsPage")).append("_").append(JDictionary.getLanguage()).append(".html"))));
            if (url.openConnection().getContentLength() > 3800) {
                URL uRL = url;
                return uRL;
            }
            url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("NewsPage")).append(".html"))));
            if (url.openConnection().getContentLength() > 3800) {
                URL uRL = url;
                return uRL;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getURL().toString();
            if (url.indexOf("PluginDownloader") != -1 && url.indexOf("download") != -1) {
                int begining = url.indexOf("(");
                int end = url.lastIndexOf(")");
                String fileName = url.substring(begining + 1, end);
                PluginDownloader pluginDownloader = this.jDictionary.getPluginDownloader();
                this.jDictionary.getAssembler().getOutput().show(pluginDownloader);
                if (fileName != null) {
                    System.out.println(fileName);
                    pluginDownloader.download(fileName);
                }
                return;
            }
            if (url.indexOf("UpgradeAgent") != -1) {
                this.jDictionary.getAssembler().getOutput().show(this.jDictionary.getUpgradeAgent());
                return;
            }
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.newsPane.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.newsPane.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    public boolean isSuccess() {
        return this.success;
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.url == null) {
                NewsAgent.this.newsPane.setCursor(this.cursor);
                Container parent = NewsAgent.this.newsPane.getParent();
                parent.repaint();
                return;
            }
            Document doc = NewsAgent.this.newsPane.getDocument();
            try {
                try {
                    NewsAgent.this.newsPane.setPage(this.url);
                }
                catch (IOException ioe) {
                    NewsAgent.this.newsPane.setDocument(doc);
                    NewsAgent.this.getToolkit().beep();
                    Object var4_4 = null;
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                    return;
                }
                Object var4_3 = null;
                this.url = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
        }
    }
}

