/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.JDictionary;
import info.jdictionary.Prefs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Preferences
extends JPanel {
    private JDictionary jDictionary;
    private Prefs prefs;
    private boolean changesSaved = false;
    private JButton applyButton;
    private JPanel output;
    private JScrollPane outputScrollPane;
    private JTextField serverTextField;
    private JTextField portTextField;
    private JTextField loginTextField;
    private JPasswordField passwordField;
    private JCheckBox upgradeCheckBox;
    private JCheckBox newsCheckBox;
    private JCheckBox proxyCheckBox;
    private JCheckBox authCheckBox;
    private JComboBox typeComboBox = new JComboBox();
    private String httpType = new String("HTTP Type");
    private String socksType = new String("SOCKS Proxy");
    private String shownType;
    boolean usingHttpProxy;
    boolean usingSocksProxy;
    boolean usingHttpProxyLogin;
    boolean usingSocksProxyLogin;
    String socksServer;
    String socksPort;
    String socksLogin;
    char[] socksPassword;
    String httpServer;
    String httpPort;
    String httpLogin;
    char[] httpPassword;
    private JLabel portLabel;
    private JLabel serverLabel;
    private JLabel typeLabel;
    private JLabel loginLabel;
    private JLabel passwordLabel;
    private Color highLightColor = Color.orange;

    public Preferences(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        this.prefs = jDictionary.getPrefs();
        this.socksServer = new String(this.prefs.socksProxyServer);
        this.socksPort = new String(this.prefs.socksProxyPort);
        this.socksLogin = new String(this.prefs.socksProxyLogin);
        this.socksPassword = new String(this.prefs.socksProxyPassword).toCharArray();
        this.httpServer = new String(this.prefs.httpProxyServer);
        this.httpPort = new String(this.prefs.httpProxyPort);
        this.httpLogin = new String(this.prefs.httpProxyLogin);
        this.httpPassword = new String(this.prefs.httpProxyPassword).toCharArray();
        this.usingHttpProxy = this.prefs.usingHttpProxy;
        this.usingSocksProxy = this.prefs.usingSocksProxy;
        this.usingHttpProxyLogin = this.prefs.usingHttpProxyLogin;
        this.usingSocksProxyLogin = this.prefs.usingSocksProxyLogin;
        this.setBackground(Color.white);
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        JLabel header = new JLabel();
        header = new JLabel(ImageBank.getImageByName("PreferencesHeader.png"));
        header.setAlignmentX(0.0f);
        header.setMinimumSize(new Dimension(300, 65));
        header.setPreferredSize(new Dimension(500, 65));
        header.setBackground(Color.white);
        this.shownType = this.usingSocksProxy ? this.socksType : this.httpType;
        this.serverTextField = new JTextField();
        this.serverTextField.setMaximumSize(new Dimension(200, 22));
        this.serverTextField.setPreferredSize(new Dimension(200, 22));
        this.serverTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Preferences.this.serverTextField_keyTyped(e);
            }
        });
        this.portTextField = new JTextField();
        this.portTextField.setMaximumSize(new Dimension(200, 22));
        this.portTextField.setPreferredSize(new Dimension(200, 22));
        this.portTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Preferences.this.portTextField_keyTyped(e);
            }
        });
        this.loginTextField = new JTextField();
        this.loginTextField.setMaximumSize(new Dimension(200, 22));
        this.loginTextField.setPreferredSize(new Dimension(200, 22));
        this.loginTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Preferences.this.loginTextField_keyTyped(e);
            }
        });
        this.passwordField = new JPasswordField();
        this.passwordField.setMaximumSize(new Dimension(200, 22));
        this.passwordField.setPreferredSize(new Dimension(200, 22));
        this.passwordField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                Preferences.this.passwordField_keyTyped(e);
            }
        });
        this.proxyCheckBox = new JCheckBox(JDictionary.getString("IUseProxy"));
        this.proxyCheckBox.setAlignmentX(0.0f);
        this.proxyCheckBox.setBackground(Color.white);
        this.proxyCheckBox.setSelected(this.usingHttpProxy || this.usingSocksProxy);
        this.proxyCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Preferences.this.proxyCheckBox_stateChanged(e);
            }
        });
        this.authCheckBox = new JCheckBox(JDictionary.getString("LoginToProxy"));
        this.authCheckBox.setBackground(Color.white);
        this.authCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Preferences.this.authCheckBox_stateChanged(e);
            }
        });
        this.typeComboBox.setMaximumSize(new Dimension(200, 24));
        this.typeComboBox.setPreferredSize(new Dimension(200, 24));
        this.typeComboBox.setBackground(Color.white);
        this.typeComboBox.addItem(this.httpType);
        this.typeComboBox.addItem(this.socksType);
        if (this.usingHttpProxy) {
            this.typeComboBox.setSelectedItem(this.httpType);
        }
        if (this.usingSocksProxy) {
            this.typeComboBox.setSelectedItem(this.socksType);
        }
        this.typeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences.this.typeComboBox_actionPerformed(e);
            }
        });
        JPanel networkPanel = new JPanel();
        networkPanel.setBackground(Color.white);
        networkPanel.setLayout(new BoxLayout(networkPanel, 0));
        networkPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("ConnectPrefs")));
        JLabel networkLabel = new JLabel();
        networkLabel.setAlignmentY(0.0f);
        networkLabel = new JLabel(IconBank.getIconByName("NetworkBig.png"));
        JPanel networkIconPanel = new JPanel();
        networkIconPanel.setBackground(Color.white);
        networkIconPanel.setAlignmentY(0.0f);
        networkIconPanel.add(networkLabel);
        networkIconPanel.setMaximumSize(new Dimension(64, 64));
        JPanel proxyPanel = new JPanel();
        proxyPanel.setBackground(Color.white);
        proxyPanel.setAlignmentY(0.0f);
        proxyPanel.setLayout(new BoxLayout(proxyPanel, 1));
        proxyPanel.add(this.proxyCheckBox);
        proxyPanel.add(this.typeComboBox);
        proxyPanel.setMaximumSize(new Dimension(380, 160));
        proxyPanel.setPreferredSize(new Dimension(300, 160));
        JPanel typePanel = new JPanel();
        typePanel.setAlignmentX(0.0f);
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.setBackground(Color.white);
        this.typeLabel = new JLabel(JDictionary.getString("ProxyType"));
        typePanel.add(this.typeLabel);
        JPanel typeSpacer = new JPanel();
        typeSpacer.setBackground(Color.white);
        typePanel.add(typeSpacer);
        typePanel.add(this.typeComboBox);
        proxyPanel.add(typePanel);
        JPanel serverPanel = new JPanel();
        serverPanel.setBackground(Color.white);
        serverPanel.setAlignmentX(0.0f);
        serverPanel.setLayout(new BoxLayout(serverPanel, 0));
        this.serverLabel = new JLabel(JDictionary.getString("ProxyServer"));
        serverPanel.add(this.serverLabel);
        JPanel serverSpacer = new JPanel();
        serverSpacer.setBackground(Color.white);
        serverPanel.add(serverSpacer);
        serverPanel.add(this.serverTextField);
        proxyPanel.add(serverPanel);
        JPanel portPanel = new JPanel();
        portPanel.setBackground(Color.white);
        portPanel.setAlignmentX(0.0f);
        portPanel.setLayout(new BoxLayout(portPanel, 0));
        this.portLabel = new JLabel(JDictionary.getString("ProxyPort"));
        portPanel.add(this.portLabel);
        JPanel portSpacer = new JPanel();
        portSpacer.setBackground(Color.white);
        portPanel.add(portSpacer);
        portPanel.add(this.portTextField);
        proxyPanel.add(portPanel);
        proxyPanel.add(this.authCheckBox);
        JPanel loginPanel = new JPanel();
        loginPanel.setBackground(Color.white);
        loginPanel.setAlignmentX(0.0f);
        loginPanel.setLayout(new BoxLayout(loginPanel, 0));
        this.loginLabel = new JLabel(JDictionary.getString("ProxyLogin"));
        loginPanel.add(this.loginLabel);
        JPanel loginSpacer = new JPanel();
        loginSpacer.setBackground(Color.white);
        loginPanel.add(loginSpacer);
        loginPanel.add(this.loginTextField);
        proxyPanel.add(loginPanel);
        JPanel passwordPanel = new JPanel();
        passwordPanel.setBackground(Color.white);
        passwordPanel.setLayout(new BoxLayout(passwordPanel, 0));
        this.passwordLabel = new JLabel(JDictionary.getString("ProxyPassword"));
        passwordPanel.add(this.passwordLabel);
        JPanel passwordSpacer = new JPanel();
        passwordSpacer.setBackground(Color.white);
        passwordPanel.add(passwordSpacer);
        passwordPanel.add(this.passwordField);
        passwordPanel.setAlignmentX(0.0f);
        proxyPanel.add(passwordPanel);
        networkPanel.add(networkIconPanel);
        JPanel networkSpacer = new JPanel();
        networkSpacer.setMaximumSize(new Dimension(30, 30));
        networkSpacer.setBackground(Color.white);
        networkPanel.add(networkSpacer);
        networkPanel.add(proxyPanel);
        JPanel startupPanel = new JPanel();
        startupPanel.setBackground(Color.white);
        startupPanel.setLayout(new BoxLayout(startupPanel, 0));
        startupPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("StartupPrefs")));
        JLabel startupLabel = new JLabel();
        startupLabel = new JLabel(IconBank.getIconByName("Download.png"));
        startupLabel.setAlignmentY(0.0f);
        JPanel startupIconPanel = new JPanel();
        startupIconPanel.setBackground(Color.white);
        startupIconPanel.add(startupLabel);
        startupIconPanel.setMaximumSize(new Dimension(64, 64));
        startupIconPanel.setAlignmentY(0.0f);
        this.upgradeCheckBox = new JCheckBox(JDictionary.getString("CheckForUpgrades"));
        this.upgradeCheckBox.setBackground(Color.white);
        this.upgradeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences.this.upgradeCheckBox_actionPerformed(e);
            }
        });
        this.newsCheckBox = new JCheckBox(JDictionary.getString("CheckForNews"));
        this.newsCheckBox.setBackground(Color.white);
        this.newsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences.this.newsCheckBox_actionPerformed(e);
            }
        });
        JPanel startupSettingsPanel = new JPanel();
        startupSettingsPanel.setBackground(Color.white);
        startupSettingsPanel.setAlignmentY(0.0f);
        startupSettingsPanel.setLayout(new BoxLayout(startupSettingsPanel, 1));
        startupSettingsPanel.add(this.upgradeCheckBox);
        startupSettingsPanel.add(this.newsCheckBox);
        startupSettingsPanel.setMaximumSize(new Dimension(380, 60));
        startupSettingsPanel.setPreferredSize(new Dimension(300, 60));
        startupPanel.add(startupIconPanel);
        JPanel startupSpacer = new JPanel();
        startupSpacer.setMaximumSize(new Dimension(30, 30));
        startupSpacer.setBackground(Color.white);
        startupPanel.add(startupSpacer);
        startupPanel.add(startupSettingsPanel);
        this.applyButton = new JButton(JDictionary.getString("ApplyButton"));
        this.applyButton.setAlignmentX(0.5f);
        this.applyButton.setIcon(IconBank.getIconByName("Check.png"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences.this.applyButton_actionPerformed(e);
            }
        });
        this.output = new JPanel();
        this.output.setBackground(Color.white);
        this.output.setLayout(new BoxLayout(this.output, 1));
        this.output.setAlignmentX(0.0f);
        JPanel outputSpacer1 = new JPanel();
        outputSpacer1.setBackground(Color.white);
        this.output.add(outputSpacer1);
        this.output.add(networkPanel);
        JPanel outputSpacer2 = new JPanel();
        outputSpacer2.setBackground(Color.white);
        this.output.add(outputSpacer2);
        this.output.add(startupPanel);
        JPanel outputSpacer3 = new JPanel();
        outputSpacer3.setBackground(Color.white);
        this.output.add(outputSpacer3);
        this.output.add(this.applyButton);
        JPanel outputSpacer4 = new JPanel();
        outputSpacer3.setBackground(Color.white);
        this.output.add(outputSpacer3);
        this.outputScrollPane = new JScrollPane();
        this.outputScrollPane.getViewport().add(this.output);
        this.add(header);
        this.add(this.outputScrollPane);
        this.updateNetworkSection();
        this.fillupNetworkTextFields();
        this.updateStartupSection();
    }

    void proxyCheckBox_stateChanged(ChangeEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
        this.updateNetworkSection();
    }

    void authCheckBox_stateChanged(ChangeEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
        if (this.authCheckBox.isSelected()) {
            if (this.typeComboBox.getSelectedItem().equals(this.httpType)) {
                this.usingHttpProxyLogin = true;
            }
            if (this.typeComboBox.getSelectedItem().equals(this.socksType)) {
                this.usingSocksProxyLogin = true;
            }
        } else {
            if (this.typeComboBox.getSelectedItem().equals(this.httpType)) {
                this.usingHttpProxyLogin = false;
            }
            if (this.typeComboBox.getSelectedItem().equals(this.socksType)) {
                this.usingSocksProxyLogin = false;
            }
        }
        this.updateNetworkSection();
    }

    void typeComboBox_actionPerformed(ActionEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
        this.updateNetworkSection();
        this.updateNetworkSectionTextFields();
    }

    void serverTextField_keyTyped(KeyEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
    }

    void portTextField_keyTyped(KeyEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
    }

    void loginTextField_keyTyped(KeyEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
    }

    void passwordField_keyTyped(KeyEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
    }

    void upgradeCheckBox_actionPerformed(ActionEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
        this.prefs.CheckingForUpgrade = ((JCheckBox)e.getSource()).isSelected();
        this.updateStartupSection();
    }

    void newsCheckBox_actionPerformed(ActionEvent e) {
        this.changesSaved = false;
        this.checkApplyButtonStatus();
        this.prefs.CheckingForNews = ((JCheckBox)e.getSource()).isSelected();
        this.updateStartupSection();
    }

    void checkApplyButtonStatus() {
        if (!this.changesSaved) {
            this.applyButton.setEnabled(true);
        }
    }

    void applyButton_actionPerformed(ActionEvent e) {
        if (this.savePrefs()) {
            this.jDictionary.initProxy();
            this.applyButton.setEnabled(false);
        }
    }

    boolean savePrefs() {
        this.prefs.CheckingForNews = this.newsCheckBox.isSelected();
        this.prefs.CheckingForUpgrade = this.upgradeCheckBox.isSelected();
        if (this.validateNetworkSectionTextFileds()) {
            if (this.typeComboBox.getSelectedItem().equals(this.httpType)) {
                this.prefs.usingHttpProxy = true;
                this.prefs.usingSocksProxy = false;
                this.saveNetworkTextFields(this.httpType);
            }
            if (this.typeComboBox.getSelectedItem().equals(this.socksType)) {
                this.prefs.usingSocksProxy = true;
                this.prefs.usingHttpProxy = false;
                this.saveNetworkTextFields(this.socksType);
            }
            if (!this.proxyCheckBox.isSelected()) {
                this.prefs.usingSocksProxy = false;
                this.prefs.usingHttpProxy = false;
            }
            this.prefs.usingHttpProxyLogin = this.usingHttpProxyLogin;
            this.prefs.usingSocksProxyLogin = this.usingSocksProxyLogin;
            this.prefs.httpProxyServer = this.httpServer;
            this.prefs.httpProxyPort = this.httpPort;
            this.prefs.httpProxyLogin = this.httpLogin;
            this.prefs.httpProxyPassword = this.httpPassword;
            this.prefs.socksProxyServer = this.socksServer;
            this.prefs.socksProxyPort = this.socksPort;
            this.prefs.socksProxyLogin = this.socksLogin;
            this.prefs.socksProxyPassword = this.socksPassword;
            this.changesSaved = true;
            return true;
        }
        return false;
    }

    void updateNetworkSection() {
        if (this.proxyCheckBox.isSelected()) {
            this.typeComboBox.setEnabled(true);
            this.typeLabel.setEnabled(true);
            this.portTextField.setEnabled(true);
            this.serverTextField.setEnabled(true);
            this.serverLabel.setEnabled(true);
            this.portLabel.setEnabled(true);
            this.authCheckBox.setEnabled(true);
            if (this.usingHttpProxyLogin && this.typeComboBox.getSelectedItem().equals(this.httpType) || this.usingSocksProxyLogin && this.typeComboBox.getSelectedItem().equals(this.socksType)) {
                if (!this.authCheckBox.isSelected()) {
                    this.authCheckBox.setSelected(true);
                }
                this.loginTextField.setEnabled(true);
                this.passwordField.setEnabled(true);
                this.loginLabel.setEnabled(true);
                this.passwordLabel.setEnabled(true);
            } else {
                if (this.authCheckBox.isSelected()) {
                    this.authCheckBox.setSelected(false);
                }
                this.loginTextField.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.loginLabel.setEnabled(false);
                this.passwordLabel.setEnabled(false);
            }
        } else {
            this.typeComboBox.setEnabled(false);
            this.typeLabel.setEnabled(false);
            this.portTextField.setEnabled(false);
            this.serverTextField.setEnabled(false);
            this.serverLabel.setEnabled(false);
            this.portLabel.setEnabled(false);
            this.authCheckBox.setEnabled(false);
            this.loginTextField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.loginLabel.setEnabled(false);
            this.passwordLabel.setEnabled(false);
        }
    }

    void updateNetworkSectionTextFields() {
        if (this.shownType.equals(this.typeComboBox.getSelectedItem())) {
            return;
        }
        this.shownType = (String)this.typeComboBox.getSelectedItem();
        if (this.shownType.equals(this.httpType)) {
            this.saveNetworkTextFields(this.socksType);
        }
        if (this.shownType.equals(this.socksType)) {
            this.saveNetworkTextFields(this.httpType);
        }
        this.fillupNetworkTextFields();
    }

    boolean validateNetworkSectionTextFileds() {
        boolean approved = true;
        if (this.proxyCheckBox.isSelected()) {
            if (this.serverTextField.getText().length() == 0 && this.portTextField.getText().length() == 0) {
                this.proxyCheckBox.setSelected(false);
            } else {
                if (this.serverTextField.getText().length() == 0) {
                    approved = false;
                    this.highLightTextField(this.serverTextField);
                }
                if (this.portTextField.getText().length() > 0) {
                    RE regexp = null;
                    try {
                        regexp = new RE("^[0-9]+$");
                    }
                    catch (RESyntaxException rESyntaxException) {
                        // empty catch block
                    }
                    if (!regexp.match(this.portTextField.getText())) {
                        approved = false;
                        this.highLightTextField(this.portTextField);
                    }
                } else {
                    if (this.typeComboBox.getSelectedItem().equals(this.httpType)) {
                        this.portTextField.setText("80");
                    }
                    if (this.typeComboBox.getSelectedItem().equals(this.socksType)) {
                        this.portTextField.setText("1080");
                    }
                }
            }
        }
        if (this.authCheckBox.isSelected()) {
            if (this.loginTextField.getText().length() == 0 && this.passwordField.getPassword().length == 0) {
                this.authCheckBox.setSelected(false);
            } else {
                if (this.loginTextField.getText().length() == 0) {
                    approved = false;
                    this.highLightTextField(this.loginTextField);
                }
                if (this.passwordField.getPassword().length == 0) {
                    approved = false;
                    this.highLightTextField(this.passwordField);
                }
            }
        }
        return approved;
    }

    void fillupNetworkTextFields() {
        if (this.typeComboBox.getSelectedItem().equals(this.httpType)) {
            this.serverTextField.setText(this.httpServer);
            this.portTextField.setText(this.httpPort);
            this.loginTextField.setText(this.httpLogin);
            ((JTextComponent)this.passwordField).setText(new String(this.httpPassword));
        }
        if (this.typeComboBox.getSelectedItem().equals(this.socksType)) {
            this.serverTextField.setText(this.socksServer);
            this.portTextField.setText(this.socksPort);
            this.loginTextField.setText(this.socksLogin);
            ((JTextComponent)this.passwordField).setText(new String(this.socksPassword));
        }
    }

    void saveNetworkTextFields(String type) {
        if (type.equals(this.httpType)) {
            this.httpServer = this.serverTextField.getText();
            this.httpPort = this.portTextField.getText();
            this.httpLogin = this.loginTextField.getText();
            this.httpPassword = this.passwordField.getPassword();
        }
        if (type.equals(this.socksType)) {
            this.socksServer = this.serverTextField.getText();
            this.socksPort = this.portTextField.getText();
            this.socksLogin = this.loginTextField.getText();
            this.socksPassword = this.passwordField.getPassword();
        }
    }

    void updateStartupSection() {
        if (this.prefs.CheckingForNews) {
            this.newsCheckBox.setSelected(true);
        } else {
            this.newsCheckBox.setSelected(false);
        }
        if (this.prefs.CheckingForUpgrade) {
            this.upgradeCheckBox.setSelected(true);
        } else {
            this.upgradeCheckBox.setSelected(false);
        }
    }

    void highLightTextField(final JTextField textField) {
        if (textField.getBackground().equals(this.highLightColor)) {
            return;
        }
        final Color originalColor = textField.getBackground();
        new Thread(){

            public void run() {
                textField.setBackground(Preferences.this.highLightColor);
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                textField.setBackground(originalColor);
            }
        }.start();
    }
}

