/*
 * Decompiled with CFR 0.152.
 */
package csheets;

import csheets.SpreadsheetAppEvent;
import csheets.SpreadsheetAppListener;
import csheets.core.Workbook;
import csheets.core.formula.compiler.FormulaCompiler;
import csheets.core.formula.lang.Language;
import csheets.ext.ExtensionManager;
import csheets.io.Codec;
import csheets.io.CodecFactory;
import csheets.io.NamedProperties;
import csheets.ui.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CleanSheets {
    private static final String DEFAULT_PROPERTIES_FILENAME = "res/defaults.xml";
    private static final String USER_PROPERTIES_FILENAME = "csheets.xml";
    private Map<Workbook, File> workbooks = new HashMap<Workbook, File>();
    private NamedProperties props;
    private List<SpreadsheetAppListener> listeners = new ArrayList<SpreadsheetAppListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CleanSheets() {
        FormulaCompiler.getInstance();
        Language.getInstance();
        ExtensionManager.getInstance();
        Properties properties = new Properties();
        InputStream inputStream = CleanSheets.class.getResourceAsStream(DEFAULT_PROPERTIES_FILENAME);
        if (inputStream != null) {
            try {
                properties.loadFromXML(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("Could not load default application properties.");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        File file = new File(USER_PROPERTIES_FILENAME);
        this.props = new NamedProperties(file, properties);
    }

    public static void main(String[] stringArray) {
        CleanSheets cleanSheets = new CleanSheets();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        new Frame.Creator(cleanSheets).createAndWait();
        cleanSheets.create();
    }

    public Properties getUserProperties() {
        return this.props;
    }

    public void exit() {
        if (this.props.size() > 0) {
            try {
                this.props.storeToXML("CleanSheets User Properties (" + DateFormat.getDateTimeInstance().format(new Date()) + ")");
            }
            catch (IOException iOException) {
                System.err.println("An error occurred while saving properties.");
            }
        }
        System.exit(0);
    }

    public void create() {
        Workbook workbook = new Workbook(3);
        this.workbooks.put(workbook, null);
        this.fireSpreadsheetAppEvent(workbook, null, SpreadsheetAppEvent.Type.CREATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException, ClassNotFoundException {
        Workbook workbook;
        Codec codec = new CodecFactory().getCodec(file);
        if (codec != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                workbook = codec.read(fileInputStream);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        throw new IOException("Codec could not be found");
        this.workbooks.put(workbook, file);
        this.fireSpreadsheetAppEvent(workbook, file, SpreadsheetAppEvent.Type.LOADED);
    }

    public void unload(Workbook workbook) {
        File file = this.workbooks.remove(workbook);
        this.fireSpreadsheetAppEvent(workbook, file, SpreadsheetAppEvent.Type.UNLOADED);
    }

    public void save(Workbook workbook) throws IOException {
        File file = this.workbooks.get(workbook);
        if (file == null) {
            throw new FileNotFoundException("No file assigned to the workbook.");
        }
        this.saveAs(workbook, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(Workbook workbook, File file) throws IOException {
        Codec codec = new CodecFactory().getCodec(file);
        if (codec != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                codec.write(workbook, fileOutputStream);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            this.workbooks.put(workbook, file);
            this.fireSpreadsheetAppEvent(workbook, file, SpreadsheetAppEvent.Type.SAVED);
        }
    }

    public Workbook[] getWorkbooks() {
        Set<Workbook> set = this.workbooks.keySet();
        return set.toArray(new Workbook[set.size()]);
    }

    public File getFile(Workbook workbook) {
        return this.workbooks.get(workbook);
    }

    public boolean isWorkbookStored(Workbook workbook) {
        return this.workbooks.get(workbook) != null;
    }

    public Workbook getWorkbook(File file) {
        for (Map.Entry<Workbook, File> entry : this.workbooks.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(file)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isFileOpen(File file) {
        return this.workbooks.containsValue(file);
    }

    public void addSpreadsheetAppListener(SpreadsheetAppListener spreadsheetAppListener) {
        this.listeners.add(spreadsheetAppListener);
    }

    public void removeSpreadsheetAppListener(SpreadsheetAppListener spreadsheetAppListener) {
        this.listeners.remove(spreadsheetAppListener);
    }

    private void fireSpreadsheetAppEvent(Workbook workbook, File file, SpreadsheetAppEvent.Type type) {
        SpreadsheetAppEvent spreadsheetAppEvent = new SpreadsheetAppEvent(this, workbook, file, type);
        if (SwingUtilities.isEventDispatchThread()) {
            for (SpreadsheetAppListener spreadsheetAppListener : this.listeners) {
                switch (spreadsheetAppEvent.getType()) {
                    case CREATED: {
                        spreadsheetAppListener.workbookCreated(spreadsheetAppEvent);
                        break;
                    }
                    case LOADED: {
                        spreadsheetAppListener.workbookLoaded(spreadsheetAppEvent);
                        break;
                    }
                    case UNLOADED: {
                        spreadsheetAppListener.workbookUnloaded(spreadsheetAppEvent);
                        break;
                    }
                    case SAVED: {
                        spreadsheetAppListener.workbookSaved(spreadsheetAppEvent);
                    }
                }
            }
        } else {
            SwingUtilities.invokeLater(new EventDispatcher(spreadsheetAppEvent, this.listeners.toArray(new SpreadsheetAppListener[this.listeners.size()])));
        }
    }

    public static class EventDispatcher
    implements Runnable {
        private SpreadsheetAppEvent event;
        private SpreadsheetAppListener[] listeners;

        public EventDispatcher(SpreadsheetAppEvent spreadsheetAppEvent, SpreadsheetAppListener[] spreadsheetAppListenerArray) {
            this.event = spreadsheetAppEvent;
            this.listeners = spreadsheetAppListenerArray;
        }

        public void run() {
            block6: for (SpreadsheetAppListener spreadsheetAppListener : this.listeners) {
                switch (this.event.getType()) {
                    case CREATED: {
                        spreadsheetAppListener.workbookCreated(this.event);
                        continue block6;
                    }
                    case LOADED: {
                        spreadsheetAppListener.workbookLoaded(this.event);
                        continue block6;
                    }
                    case UNLOADED: {
                        spreadsheetAppListener.workbookUnloaded(this.event);
                        continue block6;
                    }
                    case SAVED: {
                        spreadsheetAppListener.workbookSaved(this.event);
                    }
                }
            }
        }
    }
}

