/*
 * Decompiled with CFR 0.152.
 */
package csheets.core;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
implements Comparable<Address>,
Serializable {
    private static final long serialVersionUID = -1096697824364544991L;
    public static final char LOWEST_CHAR = 'A';
    public static final char HIGHEST_CHAR = 'Z';
    private int column;
    private int row;
    private transient String string;

    public Address(int n, int n2) {
        this.column = n;
        this.row = n2;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Address) || object == null) {
            return false;
        }
        Address address = (Address)object;
        return this.row == address.getRow() && this.column == address.getColumn();
    }

    public int hashCode() {
        return (this.column << 16) + this.row;
    }

    @Override
    public int compareTo(Address address) {
        int n = this.column - address.getColumn();
        if (n != 0) {
            return n;
        }
        return this.row - address.getRow();
    }

    public String toString() {
        if (this.string == null) {
            int n = this.column;
            String string = "";
            while (n >= 0) {
                string = (char)((char)(n % 26) + 65) + string;
                n = n / 26 - 1;
            }
            this.string = string + (this.row + 1);
        }
        return new String(this.string);
    }
}

