/*
 * Decompiled with CFR 0.152.
 */
package csheets.core;

import csheets.core.Value;

public class IllegalValueTypeException
extends Exception {
    private static final long serialVersionUID = 1642715350728576100L;
    private Value value;
    private Value.Type expectedValueType;

    public IllegalValueTypeException(Value value, Value.Type type) {
        this.value = value;
        this.expectedValueType = type;
    }

    public Value getValue() {
        return this.value;
    }

    public Value.Type getExpectedValueType() {
        return this.expectedValueType;
    }

    public String getMessage() {
        return "The value '" + this.value + "' was expected to be of type " + this.expectedValueType.toString().toLowerCase() + ".";
    }

    public String toString() {
        if (this.value.toAny() == null) {
            return "#NULL!";
        }
        return "#TYPE!";
    }
}

