/*
 * Decompiled with CFR 0.152.
 */
package csheets.core;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.CellImpl;
import csheets.core.CellListener;
import csheets.core.Spreadsheet;
import csheets.core.Workbook;
import csheets.core.formula.compiler.FormulaCompilationException;
import csheets.ext.Extension;
import csheets.ext.ExtensionManager;
import csheets.ext.SpreadsheetExtension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetImpl
implements Spreadsheet {
    private static final long serialVersionUID = 7010464744129096272L;
    public static final String BASE_TITLE = "Sheet ";
    private Workbook workbook;
    private SortedSet<Cell> cells = new TreeSet<Cell>();
    private String title;
    private int columns = 0;
    private int rows = 0;
    private transient List<CellListener> cellListeners = new ArrayList<CellListener>();
    private transient CellListener eventForwarder = new EventForwarder();
    private transient Map<String, SpreadsheetExtension> extensions = new HashMap<String, SpreadsheetExtension>();

    SpreadsheetImpl(Workbook workbook, String string) {
        this.workbook = workbook;
        this.title = string;
    }

    SpreadsheetImpl(Workbook workbook, String string, String[][] stringArray) {
        this(workbook, string);
        this.rows = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length;
            if (this.columns < n) {
                this.columns = n;
            }
            for (int j = 0; j < n; ++j) {
                try {
                    CellImpl cellImpl = new CellImpl(this, new Address(j, i), stringArray[i][j]);
                    cellImpl.addCellListener(this.eventForwarder);
                    this.cells.add(cellImpl);
                    continue;
                }
                catch (FormulaCompilationException formulaCompilationException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public Cell getCell(Address address) {
        if (address.getRow() > this.rows) {
            this.rows = address.getRow();
        }
        if (address.getColumn() > this.columns) {
            this.columns = address.getColumn();
        }
        for (Cell cell : this.cells) {
            if (!address.equals(cell.getAddress())) continue;
            return cell;
        }
        CellImpl cellImpl = new CellImpl(this, address);
        cellImpl.addCellListener(this.eventForwarder);
        this.cells.add(cellImpl);
        return cellImpl;
    }

    @Override
    public Cell getCell(int n, int n2) {
        return this.getCell(new Address(n, n2));
    }

    @Override
    public SortedSet<Cell> getCells(Address address, Address address2) {
        Serializable serializable;
        if (address.compareTo(address2) > 0) {
            serializable = address;
            address = address2;
            address2 = serializable;
        }
        serializable = new TreeSet();
        for (int i = address.getColumn(); i <= address2.getColumn(); ++i) {
            for (int j = address.getRow(); j <= address2.getRow(); ++j) {
                serializable.add(this.getCell(new Address(i, j)));
            }
        }
        return serializable;
    }

    @Override
    public Cell[] getColumn(int n) {
        Cell[] cellArray = new Cell[this.rows];
        for (int i = 0; i < i; ++i) {
            cellArray[i] = this.getCell(new Address(n, i));
        }
        return cellArray;
    }

    @Override
    public Cell[] getRow(int n) {
        Cell[] cellArray = new Cell[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            cellArray[i] = this.getCell(new Address(i, n));
        }
        return cellArray;
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cells.iterator();
    }

    @Override
    public void addCellListener(CellListener cellListener) {
        this.cellListeners.add(cellListener);
    }

    @Override
    public void removeCellListener(CellListener cellListener) {
        this.cellListeners.remove(cellListener);
    }

    @Override
    public CellListener[] getCellListeners() {
        return this.cellListeners.toArray(new CellListener[this.cellListeners.size()]);
    }

    @Override
    public Spreadsheet getExtension(String string) {
        Extension extension;
        SpreadsheetExtension spreadsheetExtension = this.extensions.get(string);
        if (spreadsheetExtension == null && (extension = ExtensionManager.getInstance().getExtension(string)) != null && (spreadsheetExtension = extension.extend(this)) != null) {
            this.extensions.put(string, spreadsheetExtension);
        }
        return spreadsheetExtension;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.eventForwarder = new EventForwarder();
        for (Cell cell : this.cells) {
            cell.addCellListener(this.eventForwarder);
        }
        this.cellListeners = new ArrayList<CellListener>();
        this.extensions = new HashMap<String, SpreadsheetExtension>();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                SpreadsheetExtension spreadsheetExtension = (SpreadsheetExtension)objectInputStream.readObject();
                this.extensions.put(spreadsheetExtension.getName(), spreadsheetExtension);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.extensions.size());
        for (SpreadsheetExtension spreadsheetExtension : this.extensions.values()) {
            objectOutputStream.writeObject(spreadsheetExtension);
        }
    }

    private class EventForwarder
    implements CellListener {
        public void valueChanged(Cell cell) {
            for (CellListener cellListener : SpreadsheetImpl.this.cellListeners) {
                cellListener.valueChanged(cell);
            }
        }

        public void contentChanged(Cell cell) {
            for (CellListener cellListener : SpreadsheetImpl.this.cellListeners) {
                cellListener.contentChanged(cell);
            }
        }

        public void dependentsChanged(Cell cell) {
            for (CellListener cellListener : SpreadsheetImpl.this.cellListeners) {
                cellListener.dependentsChanged(cell);
            }
        }

        public void cellCleared(Cell cell) {
            for (CellListener cellListener : SpreadsheetImpl.this.cellListeners) {
                cellListener.cellCleared(cell);
            }
        }

        public void cellCopied(Cell cell, Cell cell2) {
            for (CellListener cellListener : SpreadsheetImpl.this.cellListeners) {
                cellListener.cellCopied(cell, cell2);
            }
        }
    }
}

