/*
 * Decompiled with CFR 0.152.
 */
package csheets.core;

import csheets.core.Spreadsheet;
import csheets.core.SpreadsheetImpl;
import csheets.core.WorkbookListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbook
implements Iterable<Spreadsheet>,
Serializable {
    private static final long serialVersionUID = -6324252462576447242L;
    private List<Spreadsheet> spreadsheets = new ArrayList<Spreadsheet>();
    private transient List<WorkbookListener> listeners = new ArrayList<WorkbookListener>();
    private int createdSpreadsheets;

    public Workbook() {
    }

    public Workbook(int n) {
        for (int i = 0; i < n; ++i) {
            this.spreadsheets.add(new SpreadsheetImpl(this, this.getNextSpreadsheetTitle()));
        }
    }

    public Workbook(String[][] ... stringArray) {
        for (String[][] stringArray2 : stringArray) {
            this.spreadsheets.add(new SpreadsheetImpl(this, this.getNextSpreadsheetTitle(), stringArray2));
        }
    }

    public void addSpreadsheet() {
        SpreadsheetImpl spreadsheetImpl = new SpreadsheetImpl(this, this.getNextSpreadsheetTitle());
        this.spreadsheets.add(spreadsheetImpl);
        this.fireSpreadsheetInserted(spreadsheetImpl, this.spreadsheets.size() - 1);
    }

    public void addSpreadsheet(String[][] stringArray) {
        SpreadsheetImpl spreadsheetImpl = new SpreadsheetImpl(this, this.getNextSpreadsheetTitle(), stringArray);
        this.spreadsheets.add(spreadsheetImpl);
        this.fireSpreadsheetInserted(spreadsheetImpl, this.spreadsheets.size() - 1);
    }

    private String getNextSpreadsheetTitle() {
        return "Sheet  " + (this.createdSpreadsheets++ + 1);
    }

    public void removeSpreadsheet(Spreadsheet spreadsheet) {
        this.spreadsheets.remove(spreadsheet);
        this.fireSpreadsheetRemoved(spreadsheet);
    }

    public Spreadsheet getSpreadsheet(int n) throws IndexOutOfBoundsException {
        return this.spreadsheets.get(n);
    }

    public int getSpreadsheetCount() {
        return this.spreadsheets.size();
    }

    @Override
    public Iterator<Spreadsheet> iterator() {
        return this.spreadsheets.iterator();
    }

    public void addWorkbookListener(WorkbookListener workbookListener) {
        this.listeners.add(workbookListener);
    }

    public void removeWorkbookListener(WorkbookListener workbookListener) {
        this.listeners.remove(workbookListener);
    }

    public WorkbookListener[] getWorkbookListeners() {
        return this.listeners.toArray(new WorkbookListener[this.listeners.size()]);
    }

    private void fireSpreadsheetInserted(Spreadsheet spreadsheet, int n) {
        for (WorkbookListener workbookListener : this.listeners) {
            workbookListener.spreadsheetInserted(spreadsheet, n);
        }
    }

    private void fireSpreadsheetRemoved(Spreadsheet spreadsheet) {
        for (WorkbookListener workbookListener : this.listeners) {
            workbookListener.spreadsheetRemoved(spreadsheet);
        }
    }

    private void fireSpreadsheetRenamed(Spreadsheet spreadsheet) {
        for (WorkbookListener workbookListener : this.listeners) {
            workbookListener.spreadsheetRenamed(spreadsheet);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<WorkbookListener>();
    }
}

